/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.rail;

import com.google.common.base.Joiner;
import com.gridnine.xtrip.common.model.MulticallException;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.rest.InformationMessage;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Xeption2RestMessageTransformationAdvice
extends BaseAdvice {
    public static final String HANDLE_KEY = "handle";
    private static final Joiner commaJoiner = Joiner.on((String)", ");
    private boolean handle = true;

    public void configure(Map<String, String> params) throws Exception {
        super.configure(params);
        if (params.containsKey(HANDLE_KEY)) {
            this.handle = Boolean.parseBoolean(params.get(HANDLE_KEY));
        }
    }

    public boolean handleException(Throwable e, MessageContext ctx) throws Exception {
        ArrayList<InformationMessage> messages = (ArrayList<InformationMessage>)ctx.getObject((Enum)IBusRestContextKeys.REST_MESSAGES);
        if (messages == null) {
            messages = new ArrayList<InformationMessage>();
            ctx.putObject((Enum)IBusRestContextKeys.REST_MESSAGES, messages);
        }
        if (e instanceof MulticallException) {
            MulticallException multicallException = (MulticallException)e;
            boolean allHandled = true;
            for (Throwable exception : multicallException.getSubrouteExceptions().values()) {
                if (this.handle(exception, messages)) continue;
                allHandled = false;
            }
            if (allHandled) {
                return this.handle;
            }
        } else if (this.handle(e, messages)) {
            return this.handle;
        }
        return false;
    }

    private boolean handle(Throwable exception, List<InformationMessage> messages) {
        if (exception instanceof Xeption) {
            return this.handle((Xeption)exception, messages);
        }
        return false;
    }

    private boolean handle(Xeption xeption, List<InformationMessage> messages) {
        if (xeption.getEndUserMessage() != null || xeption.getAdminMessage() != null) {
            ArrayList<String> textMessages = new ArrayList<String>();
            if (xeption.getEndUserMessage() != null) {
                textMessages.add(xeption.getEndUserMessage().toString());
            }
            if (xeption.getAdminMessage() != null) {
                textMessages.add(xeption.getAdminMessage().toString());
            }
            final String text = commaJoiner.join(textMessages);
            messages.add(new InformationMessage(){

                public String getCode() {
                    return text;
                }

                public String getText() {
                    return text;
                }

                public InformationMessage.Severity getSeverity() {
                    return InformationMessage.Severity.ERROR;
                }
            });
            return true;
        }
        return false;
    }
}

