/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.rail.util;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;

public class CreateEntityContainerProcessor
extends BaseProcessor {
    private String key;
    private static final String entityClassParam = "entityClass";
    private Class<? extends BaseEntity> entityClassValue;

    public void configure(Map<String, String> parameters) {
        this.key = IbusConfigurationHelper.getMandatoryParameter(parameters, (String)"key");
        String paramValue = parameters.get(entityClassParam);
        if (TextUtil.isBlank((String)paramValue)) {
            throw Xeption.forDeveloper((String)"empty clazz parameters", (Object[])new Object[0]);
        }
        this.entityClassValue = this.checkClass(paramValue);
    }

    public void process(MessageContext ctx) throws Exception {
        try {
            BaseEntity baseEntity = this.entityClassValue.newInstance();
            ctx.putObject(this.key, (Object)EntityContainer.create((BaseEntity)baseEntity));
        }
        catch (Exception exception) {
            throw Xeption.forDeveloper((String)"can't create new Object {0}", (Object[])new Object[]{this.entityClassValue});
        }
    }

    private Class checkClass(String paramValue) {
        try {
            Class<?> aClass = Class.forName(paramValue);
            if (!BaseEntity.class.isAssignableFrom(aClass)) {
                throw Xeption.forDeveloper((String)"EntityClass must be subtype of BaseEntity", (Object[])new Object[0]);
            }
            return aClass;
        }
        catch (ClassNotFoundException e) {
            throw Xeption.forDeveloper((String)("class not found " + paramValue), (Throwable)e, (Object[])new Object[0]);
        }
    }
}

