/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.rail.util;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.BooleanUtils;

public class SearchIndexexByQueryProcessor<E extends BaseEntity, I extends EntityIndex<E>>
extends BaseProcessor {
    private String key;
    private Class<I> cls;
    private boolean mater;
    private EmptyBehavior emptyBehavior;
    private String result;

    public void configure(Map<String, String> parameters) {
        this.key = IbusConfigurationHelper.getMandatoryParameter(parameters, (String)"key");
        this.result = IbusConfigurationHelper.getMandatoryParameter(parameters, (String)"result");
        this.mater = BooleanUtils.toBoolean((String)IbusConfigurationHelper.getOptionalParameter(parameters, (String)"mastrer"));
        this.emptyBehavior = EmptyBehavior.valueOf(IbusConfigurationHelper.getMandatoryParameter(parameters, (String)"if-empty"));
        try {
            this.cls = Class.forName(IbusConfigurationHelper.getMandatoryParameter(parameters, (String)"cls"));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void process(MessageContext ctx) throws Exception {
        List res;
        block9: {
            SearchResult searchResult;
            block8: {
                SearchQuery searchQuery = (SearchQuery)ctx.getObject(this.key);
                if (Objects.isNull(searchQuery)) {
                    ctx.putObject(this.result, Collections.emptyList());
                    return;
                }
                EntityStorageSearchParameters searchParameters = new EntityStorageSearchParameters();
                if (!this.mater) {
                    searchParameters.context("irrelevance-tolerant-query", (Object)Boolean.TRUE);
                }
                try {
                    searchResult = EntityStorage.get().search(this.cls, searchQuery, searchParameters);
                }
                catch (StackOverflowError error) {
                    throw Xeption.forDeveloper((String)"{0} searchQuery {1}", (Object[])new Object[]{MiscUtil.getSimpleClassName(error.getClass()), XSUtil.toString((XSSerializable)searchQuery)});
                }
                if (!EntityStorageHelper.isEmpty((SearchResult)searchResult)) break block8;
                switch (this.emptyBehavior) {
                    case NULL: {
                        res = null;
                        break block9;
                    }
                    case EMPTY: {
                        res = Collections.emptyList();
                        break block9;
                    }
                    default: {
                        throw Xeption.forDeveloper((String)("unsupported EmptyBehavior=" + (Object)((Object)this.emptyBehavior)), (Object[])new Object[0]);
                    }
                }
            }
            res = searchResult.getData();
        }
        ctx.putObject(this.result, res);
    }

    private static enum EmptyBehavior {
        NULL,
        EMPTY;

    }
}

