/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.rail.util;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;

public class SetContextValueProcessor
extends BaseProcessor {
    private String key;
    private String str;
    private Boolean bool;
    private Class cls;
    private String value;

    public void configure(Map<String, String> parameters) {
        this.key = IbusConfigurationHelper.getMandatoryParameter(parameters, (String)"key");
        this.str = IbusConfigurationHelper.getOptionalParameter(parameters, (String)"str");
        this.bool = BooleanUtils.toBooleanObject((String)IbusConfigurationHelper.getOptionalParameter(parameters, (String)"bool"));
        this.value = IbusConfigurationHelper.getOptionalParameter(parameters, (String)"value");
        String buf = IbusConfigurationHelper.getOptionalParameter(parameters, (String)"cls");
        if (!TextUtil.isBlank((String)buf)) {
            try {
                this.cls = Class.forName(buf);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void process(MessageContext ctx) throws Exception {
        Object res = null;
        if (!TextUtil.isBlank((String)this.str)) {
            res = this.str;
        } else if (this.bool != null) {
            res = this.bool;
        } else if (this.cls != null) {
            res = Enum.class.isAssignableFrom(this.cls) ? Enum.valueOf(this.cls, this.value) : (BaseDictionary.class.isAssignableFrom(this.cls) ? DictionaryCache.get().findByCode(this.cls, this.value) : this.cls.newInstance());
        }
        ctx.putObject(this.key, res);
    }
}

