/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.site.getCountries;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.site.GetCountriesResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class GetCountriesProcessor
extends BaseProcessor {
    private static DictionaryReference<Country> defaultCountry = null;
    public static final Comparator<BaseDictionary> COMPARATOR_RESOURCES_IGNORE_CASE = (res1, res2) -> {
        String res1Translation = GetCountriesProcessor.getTranslation(res1);
        String res2Translation = GetCountriesProcessor.getTranslation(res2);
        if (res1Translation == null && res2Translation == null) {
            return 0;
        }
        if (res1Translation == null) {
            return 1;
        }
        if (res2Translation == null) {
            return -1;
        }
        return Collator.getInstance(LocaleHelper.getCurrentLocale()).compare(res1Translation, res2Translation);
    };
    public static final Comparator<Country> COMPARATOR_DEFAULT_COUNTRY_TOP = (c1, c2) -> {
        if (c1.getCode().equals(defaultCountry.getCode())) {
            return -1;
        }
        if (c2.getCode().equals(defaultCountry.getCode())) {
            return 1;
        }
        return 0;
    };

    public void process(MessageContext ctx) throws Exception {
        GetCountriesResult result = new GetCountriesResult();
        defaultCountry = Objects.requireNonNull(CommonHelper.getGeneralSettings((EntityReference<SMSite>)((EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE)))).getDefaultCountry();
        result.getCountries().addAll(DictionaryCache.get().getAll(Country.class).values().stream().filter(this.exclude()).sorted(COMPARATOR_RESOURCES_IGNORE_CASE).sorted(COMPARATOR_DEFAULT_COUNTRY_TOP).map(item -> {
            com.gridnine.xtrip.server.ibecorp.common.rest.model.site.Country c = new com.gridnine.xtrip.server.ibecorp.common.rest.model.site.Country();
            c.setCaption(item.toString());
            c.setUid(item.getCode());
            c.setPhoneCode(item.getPhoneCode());
            return c;
        }).collect(Collectors.toList()));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private static String getTranslation(BaseDictionary dictionary) {
        return (String)CommonConverterHelper.findByLocale(dictionary.getTranslations(), LocaleHelper.getCurrentLocale());
    }

    private Predicate<? super Country> exclude() {
        return country -> country.getCodeVariants().keySet().containsAll(Arrays.asList(CodeSystem.IATA.name(), CodeSystem.CRT.name()));
    }
}

