/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.site.getGeneralSettings;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMVisualSettings;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.SiteConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.site.GeneralSettingsResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Objects;

public class GetGeneralSettingsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        SMSiteType siteType = (SMSiteType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE_TYPE);
        SMVisualSettings visualSettings = Objects.requireNonNull(CommonHelper.getVisualSettings((EntityReference<SMSite>)siteRef));
        EntityContainer siteCtr = EntityStorage.get().resolve(siteRef);
        SMGeneralSettings generalSettings = Objects.requireNonNull(CommonHelper.getGeneralSettings((EntityReference<SMSite>)siteRef));
        GeneralSettingsResult result = new GeneralSettingsResult();
        result.setSettings(SiteConverterHelper.convertGeneralSettings2Rest(generalSettings, false));
        result.setSiteType(siteType);
        result.setB2cAsB2b(siteType == SMSiteType.B2C && ((SMSite)siteCtr.getEntity()).isB2cAsB2b());
        result.setSiteTitle(SiteConverterHelper.getLocalizedText(visualSettings.getSiteTitle()));
        result.setSiteIcon(SiteConverterHelper.getConverterToBase64(visualSettings.getFavicon()));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

