/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.site.getSiteSettings;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep1Settings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep2Settings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep3Settings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep4Settings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMVisualSettings;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.SiteConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.site.SiteSettingsResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Objects;

public class GetSiteSettingsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        SMSiteType siteType = (SMSiteType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE_TYPE);
        SalesContext saleContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityContainer siteCtr = EntityStorage.get().resolve(siteRef);
        SMStep1Settings firstStepSettings = Objects.requireNonNull(CommonHelper.getStep1Settings((EntityReference<SMSite>)siteRef));
        SMStep2Settings secondStepSettings = Objects.requireNonNull(CommonHelper.getStep2Settings((EntityReference<SMSite>)siteRef));
        SMStep3Settings thirdStepSettings = Objects.requireNonNull(CommonHelper.getStep3Settings((EntityReference<SMSite>)siteRef));
        SMStep4Settings fourthStepSettings = Objects.requireNonNull(CommonHelper.getStep4Settings((EntityReference<SMSite>)siteRef));
        SMVisualSettings visualSettings = Objects.requireNonNull(CommonHelper.getVisualSettings((EntityReference<SMSite>)siteRef));
        SMGeneralSettings generalSettings = Objects.requireNonNull(CommonHelper.getGeneralSettings((EntityReference<SMSite>)siteRef));
        SiteSettingsResult result = new SiteSettingsResult();
        result.setGeneralSettings(SiteConverterHelper.convertGeneralSettings2Rest(generalSettings, true));
        result.setVisualSettings(SiteConverterHelper.convertVisualSettings2Rest(visualSettings, saleContext));
        result.setFirstStepSettings(SiteConverterHelper.convertFirstStepSettings2Rest(firstStepSettings, saleContext));
        result.setSecondStepSettings(SiteConverterHelper.convertSecondStepSettings2Rest(secondStepSettings));
        result.setThirdStepSettings(SiteConverterHelper.convertThirdStepSettings2Rest(thirdStepSettings));
        result.setFourthStepSettings(SiteConverterHelper.convertFourthStepSettings2Rest(fourthStepSettings));
        result.getPassengerTypes().addAll(DictHelper.getAllPassengerTypes());
        result.setLocale(LocaleHelper.getCurrentLocale().getLanguage());
        result.setB2cAsB2b(siteType == SMSiteType.B2C && ((SMSite)siteCtr.getEntity()).isB2cAsB2b());
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

