/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.correspondence.storage;

import com.gridnine.xtrip.common.ibecorp.correspondence.CorrespondenceHelper;
import com.gridnine.xtrip.common.ibecorp.correspondence.rules.NotificationActionsProvider;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.mail.MailAddress;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressListProducer {
    private static Logger log = LoggerFactory.getLogger(AddressListProducer.class);
    private final EntityReference<Person> assigneeRef;
    private final EntityReference<Person> authorRef;
    private final EntityReference<Person> postAuthorRef;
    private final PersonCommunication bookingAgentEmail;
    private final Communication customerEmail;
    private final Collection<Communication> travellersEmails;
    private final String hotelEmail;

    public AddressListProducer(EntityReference<Person> assigneeRef, EntityReference<Person> authorRef, EntityReference<Person> postAuthorRef, PersonCommunication bookingAgentEmail, Communication customerEmail, Collection<Communication> travellersEmails, String hotelEmail) {
        this.assigneeRef = assigneeRef;
        this.authorRef = authorRef;
        this.postAuthorRef = postAuthorRef;
        this.bookingAgentEmail = bookingAgentEmail;
        this.customerEmail = customerEmail;
        this.travellersEmails = travellersEmails;
        this.hotelEmail = hotelEmail;
    }

    public Collection<MailAddress> collectAddresses(NotificationActionsProvider provider) {
        EntityContainer postAuthorCtr;
        EntityContainer authorCtr;
        EntityContainer assigneeCtr;
        LinkedList<String> addresses = new LinkedList<String>();
        EntityStorage entityStorage = EntityStorage.get();
        if (provider.isNotifyAssignee() && (assigneeCtr = entityStorage.resolve(this.assigneeRef)) != null) {
            addresses.addAll(CorrespondenceHelper.getPersonEmails((Person)((Person)assigneeCtr.getEntity())));
        }
        if (provider.isNotifyAuthor() && (authorCtr = entityStorage.resolve(this.authorRef)) != null) {
            addresses.addAll(CorrespondenceHelper.getPersonEmails((Person)((Person)authorCtr.getEntity())));
        }
        if (provider.isNotifyHotel()) {
            addresses.add(this.hotelEmail);
        }
        if (provider.isNotifyBookingAgent() && this.bookingAgentEmail != null) {
            addresses.add(this.bookingAgentEmail.getSense());
        }
        if (provider.isNotifyBookingCustomer() && this.customerEmail != null) {
            addresses.add(this.customerEmail.getSense());
        }
        if (provider.isNotifyBookingTravellers() && !this.travellersEmails.isEmpty()) {
            addresses.addAll(this.travellersEmails.stream().map(Communication::getSense).collect(Collectors.toSet()));
        }
        if (provider.getEmails() != null) {
            addresses.addAll(provider.getEmails());
        }
        addresses.removeIf(address -> !CorrespondenceHelper.isValidEmailAddress((String)address));
        if (provider.isDontNotifyPostAuthor() && (postAuthorCtr = entityStorage.resolve(this.postAuthorRef)) != null) {
            addresses.removeIf(CorrespondenceHelper.getPersonEmails((Person)((Person)postAuthorCtr.getEntity()))::contains);
        }
        HashSet uniqueValues = new HashSet(addresses);
        log.trace("Collected unique addresses {}", uniqueValues);
        return uniqueValues.stream().map(this::newMailAddress).collect(Collectors.toSet());
    }

    private MailAddress newMailAddress(String address) {
        MailAddress mailAddress = new MailAddress();
        mailAddress.setAddress(address);
        mailAddress.setHotelAddress(address.equals(this.hotelEmail));
        return mailAddress;
    }
}

