/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.correspondence.storage;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.util.ObjectFactory;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageConfigurator;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.ibecorp.correspondence.storage.CorrespondenceSequenceNumberInterceptor;
import com.gridnine.xtrip.server.ibecorp.correspondence.storage.CreationSourceInterceptor;
import com.gridnine.xtrip.server.ibecorp.correspondence.storage.EventsCollectorInterceptor;
import com.gridnine.xtrip.server.ibecorp.correspondence.storage.EventsPurgerInterceptor;
import com.gridnine.xtrip.server.ibecorp.correspondence.storage.IssueIndexHandler;
import com.gridnine.xtrip.server.ibecorp.correspondence.storage.IssueInterceptor;
import com.gridnine.xtrip.server.ibecorp.correspondence.storage.NotificationInterceptor;
import com.gridnine.xtrip.server.model.ModelLogicalStorageConfigurator;
import org.slf4j.LoggerFactory;

public class CorrespondenceLogicalStorageConfigurator
implements LogicalStorageConfigurator {
    public void configure(LogicalStorageRegistry registry) {
        this.registerIndexHandlers(registry);
        this.registryEntityInterceptors(registry);
    }

    private void registryEntityInterceptors(LogicalStorageRegistry registry) {
        registry.registerEntityInterceptor((EntityInterceptor)new CorrespondenceSequenceNumberInterceptor());
        registry.registerEntityInterceptor((EntityInterceptor)new NotificationInterceptor());
        registry.registerEntityInterceptor((EntityInterceptor)new EventsPurgerInterceptor());
        registry.registerEntityInterceptor((EntityInterceptor)new EventsCollectorInterceptor());
        registry.registerEntityInterceptor((EntityInterceptor)new CreationSourceInterceptor());
        registry.registerEntityInterceptor((EntityInterceptor)new IssueInterceptor());
    }

    private void registerIndexHandlers(LogicalStorageRegistry registry) {
        registry.registerIndexHandler(this.createHandler("issue-index-handler.className", IssueIndexHandler::new));
    }

    private <E extends BaseEntity, I extends EntityIndex<E>, H extends IndexHandler<E, I>> H createHandler(String key, ObjectFactory<H> objectFactory) {
        String clsName = System.getProperty(key);
        if (clsName == null) {
            return (H)((IndexHandler)objectFactory.createObject());
        }
        try {
            return (H)((IndexHandler)ModelLogicalStorageConfigurator.class.getClassLoader().loadClass(clsName).newInstance());
        }
        catch (Exception e) {
            LoggerFactory.getLogger(ModelLogicalStorageConfigurator.class).error("unable to load class " + clsName, (Throwable)e);
            return (H)((IndexHandler)objectFactory.createObject());
        }
    }
}

