/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.correspondence.storage;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.BaseIssue;
import com.gridnine.xtrip.common.model.system.ActionSource;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreationSourceInterceptor
implements EntityInterceptor {
    private Logger log = LoggerFactory.getLogger(CreationSourceInterceptor.class);

    public double getPriority() {
        return 7.0;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) {
        if (!(data.getEntity() instanceof BaseIssue)) {
            return;
        }
        EntityContainer<?> issue = data;
        if (issue.getVersionsCount() == 1 && ((BaseIssue)issue.getEntity()).getCreationSource() == null) {
            ActionSource actionSource = this.determineActionSource(issue);
            this.log.debug("create issue {} source {}", (Object)issue.getUid(), (Object)actionSource.name());
            ((BaseIssue)issue.getEntity()).setCreationSource(actionSource);
        }
    }

    public void onDelete(SessionCallback sessionCallback, EntityContainer<?> data) throws Exception {
    }

    private ActionSource determineActionSource(EntityContainer<BaseIssue> issue) {
        Map entitySaveParams = LogicalStorage.get().getEntityStorage().getGlobalOperationContext().getParameters();
        MessageContext ibusContext = (MessageContext)entitySaveParams.get(IBusStandardContextKeys.MESSAGE_CONTEXT.name());
        ActionSource source = ibusContext != null && ibusContext.hasObject(IBusStandardContextKeys.ACTION_SOURCE.name()) ? (ActionSource)ibusContext.getObject(IBusStandardContextKeys.ACTION_SOURCE.name()) : (ActionSource)entitySaveParams.get(IBusStandardContextKeys.ACTION_SOURCE.name());
        return source == null ? this.getDefaultSource(issue) : source;
    }

    private ActionSource getDefaultSource(EntityContainer<BaseIssue> issue) {
        this.log.warn(String.format("source not resolved, issue {%s}", issue.getUid()));
        return ActionSource.SYSTEM;
    }
}

