/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.correspondence.storage;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.BaseIssue;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.NotificationEvent;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.db.storage.model.LogicalEntityOperationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class EventsCollectorInterceptor
implements EntityInterceptor {
    public double getPriority() {
        return 5.0;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) {
        if (EntityStorageHelper.isEmpty(data)) {
            return;
        }
        if (!(data.getEntity() instanceof BaseIssue)) {
            return;
        }
        EntityContainer<?> issueCtr = data;
        BaseIssue issue = (BaseIssue)issueCtr.getEntity();
        LogicalEntityOperationContext globalOperationContext = LogicalStorage.get().getEntityStorage().getGlobalOperationContext();
        EntityContainer<BaseIssue> oldIssueCtr = this.oldIssue(globalOperationContext);
        BaseIssue oldIssue = (BaseIssue)EntityStorageHelper.entity(oldIssueCtr);
        List<NotificationEvent> events = this.generateEvents(issue, oldIssue);
        events.addAll(issue.getEvents());
        issue.getEvents().clear();
        issue.getEvents().addAll(events);
    }

    private EntityContainer<BaseIssue> oldIssue(LogicalEntityOperationContext logicalEntityOperationContext) {
        EntityContainer oldCtr = logicalEntityOperationContext.getOldCtr();
        if (EntityStorageHelper.isEmpty((EntityContainer)oldCtr)) {
            return null;
        }
        if (!(oldCtr.getEntity() instanceof BaseIssue)) {
            return null;
        }
        return oldCtr;
    }

    private List<NotificationEvent> generateEvents(BaseIssue newIssue, BaseIssue oldIssue) {
        ArrayList<NotificationEvent> notificationEvents = new ArrayList<NotificationEvent>();
        if (null == oldIssue) {
            notificationEvents.add(NotificationEvent.ISSUE_CREATED);
            return notificationEvents;
        }
        if (!Objects.equals(newIssue.getAssignee(), oldIssue.getAssignee())) {
            notificationEvents.add(NotificationEvent.ASSIGNEE_CHANGED);
        }
        if (!Objects.equals(newIssue.getStatus(), oldIssue.getStatus())) {
            notificationEvents.add(NotificationEvent.STATUS_CHANGED);
        }
        if (!Objects.equals(newIssue.getClient(), oldIssue.getClient())) {
            notificationEvents.add(NotificationEvent.CLIENT_CHANGED);
        }
        if (!Objects.equals(newIssue.getTitle(), oldIssue.getTitle())) {
            notificationEvents.add(NotificationEvent.TITLE_CHANGED);
        }
        if (!Objects.equals(newIssue.getDescription(), oldIssue.getDescription())) {
            notificationEvents.add(NotificationEvent.DESCRIPTION_CHANGED);
        }
        return notificationEvents;
    }
}

