/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.correspondence.storage;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.BaseIssue;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.IssueStatus;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class EventsPurgerInterceptor
implements EntityInterceptor {
    public double getPriority() {
        return 10.0;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (EntityStorageHelper.isEmpty(data)) {
            return;
        }
        if (!BaseIssue.class.isInstance(data.getEntity())) {
            return;
        }
        EntityContainer<?> issueCtr = data;
        BaseIssue issue = (BaseIssue)issueCtr.getEntity();
        EntityContainer oldIssueCtr = LogicalStorage.get().getEntityStorage().getLocalOperationContext(issueCtr.toReference()).getOldCtr();
        BaseIssue oldIssue = (BaseIssue)EntityStorageHelper.entity((EntityContainer)oldIssueCtr);
        List issueEvents = issue.getEvents();
        if (CollectionUtil.isNotEmpty((Collection)issueEvents)) {
            issueEvents.clear();
            if (issue.getPosts().size() == 0) {
                issue.setUpdateDate(new Date());
            }
        }
        if (IssueStatus.CLOSED == issue.getStatus() && (Objects.isNull(oldIssue) || IssueStatus.CLOSED != oldIssue.getStatus())) {
            issue.setLastCloseDate(new Date());
        }
    }
}

