/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.correspondence.storage;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.correspondence.handlers.BaseIssueHandler;
import com.gridnine.xtrip.common.ibecorp.correspondence.handlers.IssueHandlersRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.StorageException;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageActualizeParameters;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.BaseIssue;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.IssueIndex;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.IssueIndexData;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.Post;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.db.storage.model.LogicalEntityOperationContext;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class IssueIndexHandler
implements IndexHandler<BaseIssue, IssueIndex> {
    public Class<? extends BaseIndexData<BaseIssue, IssueIndex>> getDataClass() {
        return IssueIndexData.class;
    }

    public Class<IssueIndex> getIndexClass() {
        return IssueIndex.class;
    }

    public Class<BaseIssue> getEntityType() {
        return BaseIssue.class;
    }

    public void create(EntityContainer<BaseIssue> etc, Collection<BaseIndexData<BaseIssue, IssueIndex>> indexes) {
        BaseIssueHandler handler = IssueHandlersRegistry.get().getHandler(etc.getEntityType());
        DataAggregator aggregator = new DataAggregator();
        LogicalEntityOperationContext globalOperationContext = LogicalStorage.get().getEntityStorage().getGlobalOperationContext();
        MessageContext messageContext = this.messageContext(globalOperationContext);
        EntityContainer<BookingFile> bookingFileCtr = this.bookingFileCtr((BaseIssue)etc.getEntity(), messageContext);
        IssueIndexData data = new IssueIndexData();
        this.fillData(etc, bookingFileCtr, handler, aggregator, data);
        data.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<BaseIssue, IssueIndex>)data);
    }

    private MessageContext messageContext(LogicalEntityOperationContext globalOperationContext) {
        Map parameters = globalOperationContext.getParameters();
        Object messageContextObj = parameters.get(IBusStandardContextKeys.MESSAGE_CONTEXT.name());
        if (Objects.isNull(messageContextObj)) {
            return null;
        }
        return (MessageContext)messageContextObj;
    }

    private EntityContainer<BookingFile> bookingFileCtr(BaseIssue issue, MessageContext messageContext) {
        Object bookingFileCtrObj;
        if (Objects.nonNull(messageContext) && Objects.nonNull(bookingFileCtrObj = messageContext.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE))) {
            return (EntityContainer)bookingFileCtrObj;
        }
        EntityReference bookingFileRef = issue.getBooking();
        if (Objects.isNull(bookingFileRef)) {
            return null;
        }
        EntityContainer bookingFileCtr = EntityStorage.get().resolve(bookingFileRef);
        if (EntityStorageHelper.isEmpty((EntityContainer)bookingFileCtr)) {
            return null;
        }
        return bookingFileCtr;
    }

    protected void fillData(EntityContainer<BaseIssue> etc, EntityContainer<BookingFile> bookingFileContainer, BaseIssueHandler handler, DataAggregator aggregator, IssueIndexData data) throws StorageException {
        BaseIssue issue = (BaseIssue)etc.getEntity();
        data.setAssignee(issue.getAssignee());
        data.setAuthor(issue.getAuthor());
        String fullNumber = TextUtil.buildFullNumber((CompositeNumber)issue);
        data.setNumber(fullNumber);
        String bookingNumber = null;
        if (bookingFileContainer != null) {
            bookingNumber = TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)bookingFileContainer.getEntity()));
            LinkedList<String> travellers = new LinkedList<String>();
            for (Traveller t : ((BookingFile)bookingFileContainer.getEntity()).getTravellers()) {
                if (t.getPassport() != null) {
                    String traveller;
                    Iterator sb = new StringBuilder();
                    Passport p = t.getPassport();
                    String lastName = p.getLastName();
                    if (!StringUtils.isBlank((String)lastName)) {
                        aggregator.aggregate((Object)lastName);
                        ((StringBuilder)((Object)sb)).append(lastName);
                        if (!StringUtils.isBlank((String)p.getFirstName())) {
                            ((StringBuilder)((Object)sb)).append(' ');
                            ((StringBuilder)((Object)sb)).append(p.getFirstName());
                            if (!StringUtils.isBlank((String)p.getMiddleName())) {
                                ((StringBuilder)((Object)sb)).append(' ');
                                ((StringBuilder)((Object)sb)).append(p.getMiddleName());
                            }
                        }
                    }
                    if (StringUtils.isBlank((String)(traveller = ((StringBuilder)((Object)sb)).toString()))) continue;
                    travellers.add(traveller);
                    continue;
                }
                if (!StringUtils.isNotBlank((String)t.getName())) continue;
                travellers.add(t.getName());
            }
            data.setTravellers(travellers);
            if (!((BookingFile)bookingFileContainer.getEntity()).getReservations().isEmpty()) {
                ProductHandler productHandler;
                data.setDisplayedGdsName(CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)((Reservation)((BookingFile)bookingFileContainer.getEntity()).getReservations().get(0))));
                data.setGdsNames((Collection)IndexBuilderHelper.getGdsNames((Reservation)((Reservation)((BookingFile)bookingFileContainer.getEntity()).getReservations().get(0))));
                BaseProduct mainProduct = null;
                String route = null;
                block1: for (Reservation rs : ((BookingFile)bookingFileContainer.getEntity()).getReservations()) {
                    for (BaseProduct bp : rs.getProducts()) {
                        if (!(bp instanceof Product) && !(bp instanceof RailwayProduct)) continue;
                        mainProduct = bp;
                        productHandler = HandlersRegistry.get().findProductHandler(bp.getClass());
                        route = productHandler.getLocalizedRouteLine(bp);
                        data.setServiceDescription(route);
                        data.setServiceStartDate(productHandler.findFirstTravelDate(bp));
                        break block1;
                    }
                }
                if (mainProduct == null) {
                    for (Reservation rs : ((BookingFile)bookingFileContainer.getEntity()).getReservations()) {
                        BaseProduct bp;
                        Iterator iterator = rs.getProducts().iterator();
                        if (!iterator.hasNext()) continue;
                        bp = (BaseProduct)iterator.next();
                        productHandler = HandlersRegistry.get().findProductHandler(bp.getClass());
                        route = productHandler.getLocalizedRouteLine(bp);
                        data.setServiceDescription(route);
                        data.setServiceStartDate(productHandler.findFirstTravelDate(bp));
                        break;
                    }
                }
                if (!TextUtil.isBlank(route)) {
                    aggregator.aggregate(route);
                }
                data.setBookingAgent(((Reservation)((BookingFile)bookingFileContainer.getEntity()).getReservations().get(0)).getBookingAgent());
            }
        }
        data.setBookingNumber(bookingNumber);
        data.setBooking(bookingFileContainer != null ? bookingFileContainer.toReference() : null);
        data.setType(handler.getIssueType());
        data.setSubject(handler.getSubject(issue));
        data.setNavigationKey(issue.getUid());
        data.setStatus(issue.getStatus());
        String title = issue.getTitle();
        data.setTitle(null == title || title.length() <= 252 ? title : title.substring(0, 252) + "...");
        data.setCreateDate(issue.getCreateDate());
        data.setUpdateDate(issue.getUpdateDate());
        data.setUnreadPosts(issue.getUnreadPosts());
        data.setTotalPosts(handler.getTotalPosts(issue));
        EntityContainer clientContainer = EntityStorage.get().resolve(issue.getClient());
        if (clientContainer != null) {
            data.setHolding(((Organization)clientContainer.getEntity()).getHolding());
            aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
        }
        data.setClient(issue.getClient());
        data.setSubagency(issue.getSubagency());
        data.setAgency(issue.getAgency());
        int responsesCount = 0;
        for (Passport p : issue.getPosts()) {
            if (p.isClient()) continue;
            ++responsesCount;
        }
        data.setResponsesCount(Integer.valueOf(responsesCount));
        data.setLastCloseDate(issue.getLastCloseDate());
        if (bookingFileContainer != null) {
            EntityReference agencyRef = ((BookingFile)bookingFileContainer.getEntity()).getAgency();
            EntityStorage.get().actualize(agencyRef, new EntityStorageActualizeParameters().processedUncachedEntity(false).useRemoteCallIfNecessary(true));
            data.setAgency(agencyRef);
        }
        Date firstOperatorPostDate = null;
        EntityReference firstOperatorPostAuthor = null;
        for (Post post : issue.getPosts()) {
            if (post.isClient() || firstOperatorPostDate != null && post.getDateCreated().compareTo(firstOperatorPostDate) >= 0) continue;
            firstOperatorPostDate = post.getDateCreated();
            firstOperatorPostAuthor = post.getAuthor();
        }
        data.setFirstOperatorPostDate(firstOperatorPostDate);
        data.setFirstOperatorPostAuthor(firstOperatorPostAuthor);
        aggregator.aggregate((Object)issue.getSubagency());
        aggregator.aggregate((Object)issue.getAssignee());
        aggregator.aggregate((Object)issue.getAuthor());
        aggregator.aggregate(issue.getCreateDate());
        aggregator.aggregate((Enum)issue.getStatus());
        aggregator.aggregate((Object)fullNumber);
        aggregator.aggregate((Object)bookingNumber);
    }
}

