/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.correspondence.storage;

import com.gridnine.xtrip.common.ibecorp.correspondence.handlers.BaseIssueHandler;
import com.gridnine.xtrip.common.ibecorp.correspondence.handlers.IssueHandlersRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.BaseIssue;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.NotificationEvent;
import com.gridnine.xtrip.common.model.mail.MailAddress;
import com.gridnine.xtrip.common.model.mail.MailDocument;
import com.gridnine.xtrip.common.user.UserData;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;

public class MailDocumentBuilder {
    private final BaseIssue oldIssue;
    private final EntityContainer<BaseIssue> issueCtr;
    private final NotificationEvent event;
    private final Supplier<MailAddress> defaultFromAddressSupplier;
    private final Collection<MailAddress> addresses;
    private final EntityContainer<BookingFile> bookingFileCtr;

    public MailDocumentBuilder(BaseIssue oldIssue, EntityContainer<BaseIssue> issueCtr, NotificationEvent event, Supplier<MailAddress> defaultFromAddressSupplier, Collection<MailAddress> addresses, EntityContainer<BookingFile> bookingFileCtr) {
        this.oldIssue = oldIssue;
        this.issueCtr = issueCtr;
        this.event = event;
        this.defaultFromAddressSupplier = defaultFromAddressSupplier;
        this.addresses = addresses;
        this.bookingFileCtr = bookingFileCtr;
    }

    public MailDocument create() {
        BaseIssueHandler issueHandler = IssueHandlersRegistry.get().getHandler(((BaseIssue)this.issueCtr.getEntity()).getClass());
        MailDocument mailDocument = issueHandler.buildMailMessage(this.issueCtr, this.oldIssue, this.event, UserData.get().getCurrentUser(), this.bookingFileCtr);
        List mailAddressTo = mailDocument.getTo();
        mailAddressTo.addAll(this.addresses);
        mailDocument.setFrom(this.defaultFromAddressSupplier.get());
        return mailDocument;
    }
}

