/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.correspondence.storage;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.correspondence.rules.NotificationActionsProvider;
import com.gridnine.xtrip.common.ibecorp.correspondence.rules.NotificationTargets;
import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.BaseIssue;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.CorrespondenceDelaySettings;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.NotificationEvent;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.Post;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.RequestForHotelBookingIssue;
import com.gridnine.xtrip.common.model.ibecorp.sm.BaseSMProfileIndex;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMNotificationsSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMProfileType;
import com.gridnine.xtrip.common.model.mail.MailAddress;
import com.gridnine.xtrip.common.model.mail.MailDocument;
import com.gridnine.xtrip.common.model.mail.MailServerParameters;
import com.gridnine.xtrip.common.model.mail.MailServerSettings;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.db.storage.model.LogicalEntityOperationContext;
import com.gridnine.xtrip.server.ibecorp.correspondence.storage.AddressListProducer;
import com.gridnine.xtrip.server.ibecorp.correspondence.storage.MailDocumentBuilder;
import com.gridnine.xtrip.server.ibecorp.correspondence.storage.NotificationPropertySetImpl;
import com.gridnine.xtrip.server.ibecorp.notifications.IssueNotification;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import com.gridnine.xtrip.server.model.mail.MailConfigUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationInterceptor
implements EntityInterceptor {
    private static final Logger log = LoggerFactory.getLogger(NotificationInterceptor.class);

    public double getPriority() {
        return 7.5;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) {
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        EntityContainer settingsCtr;
        if (!(data.getEntity() instanceof BaseIssue)) {
            return;
        }
        EntityContainer<?> issueCtr = data;
        BaseIssue issue = (BaseIssue)issueCtr.getEntity();
        if (issue.getEvents().isEmpty()) {
            return;
        }
        MessageContext messageContext = this.messageContext(LogicalStorage.get().getEntityStorage().getGlobalOperationContext());
        EntityContainer<BookingFile> bookingFileCtr = this.bookingFileCtr(issue, messageContext);
        BookingFile bookingFile = (BookingFile)EntityStorageHelper.entity(bookingFileCtr);
        if (null == bookingFile) {
            return;
        }
        List uniqueEvents = issue.getEvents().stream().distinct().sorted().collect(Collectors.toList());
        LogicalEntityOperationContext globalOperationContext = LogicalStorage.get().getEntityStorage().getGlobalOperationContext();
        BaseIssue oldIssue = this.oldIssue(globalOperationContext);
        PersonCommunication bookingAgentEmail = this.bookingAgentEmail(bookingFile);
        Communication customerEmail = this.bookingCustomerEmail(bookingFile);
        Collection<Communication> travellersEmails = this.bookingTravellersEmails(bookingFile);
        EntityReference assigneeRef = issue.getAssignee();
        EntityReference authorRef = issue.getAuthor();
        if (log.isDebugEnabled()) {
            log.debug("Process issue {}, events [{}]", new Object[]{issue.getNumber(), uniqueEvents.stream().map(Enum::name).collect(Collectors.joining(","))});
        }
        SMNotificationsSettings settings = null;
        EntityReference notificationSettingsRef = null;
        EntityReference siteRef = bookingFile.getSite();
        if (siteRef != null) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BaseSMProfileIndex.Property.site.name(), (Object)siteRef));
            List indexes = EntityStorage.get().search(BaseSMProfileIndex.class, query).getData();
            for (BaseSMProfileIndex index : indexes) {
                if (index.getProfileType() != SMProfileType.NOTIFICATIONS_SETTINGS) continue;
                notificationSettingsRef = index.getSource();
                break;
            }
        }
        if (null != (settingsCtr = EntityStorage.get().resolve(notificationSettingsRef))) {
            settings = (SMNotificationsSettings)settingsCtr.getEntity();
        }
        MailAddress mailFrom = new MailAddress();
        long delayCurrent = 0L;
        CorrespondenceDelaySettings delaySettings = (CorrespondenceDelaySettings)CollectionUtil.singleOrNull((Collection)SystemHelper.searchSystemSettings(CorrespondenceDelaySettings.class));
        long delayDelta = 1000L * (long)Optional.ofNullable(delaySettings).map(CorrespondenceDelaySettings::getDelayInSeconds).orElse(0).intValue();
        for (NotificationEvent event : uniqueEvents) {
            MailServerParameters mailServerParameters;
            Collection<MailAddress> addresses;
            EntityReference postAuthorRef;
            NotificationActionsProvider actions = this.applyRules(issue, event, bookingFile);
            if (null == actions) continue;
            EntityReference entityReference = postAuthorRef = event == NotificationEvent.COMMENT_ADDED && !issue.getPosts().isEmpty() ? ((Post)CollectionUtil.getLastElement((List)issue.getPosts())).getAuthor() : null;
            if (issue instanceof RequestForHotelBookingIssue) {
                Post lastPost = (Post)CollectionUtil.getLastElement((List)issue.getPosts());
                if (lastPost.isClient()) {
                    actions.setNotifyHotel(false);
                }
                Communication hotelEmail = lastPost.getHotelEmail();
                String emailSense = hotelEmail.getSense();
                Pattern pattern = Pattern.compile(".*<(.+)>");
                Matcher matcher = pattern.matcher(emailSense);
                if (matcher.matches()) {
                    emailSense = matcher.group(1);
                }
                addresses = new AddressListProducer((EntityReference<Person>)assigneeRef, (EntityReference<Person>)authorRef, (EntityReference<Person>)postAuthorRef, bookingAgentEmail, customerEmail, travellersEmails, emailSense).collectAddresses(actions);
                MailServerSettings mailServerSettings = MailConfigUtil.readMailServerParameters();
                mailServerParameters = mailServerSettings.getHotelMailServerParameters();
                mailFrom.setAddress(mailServerSettings.getFromAddress());
                mailFrom.setName(mailServerSettings.getFromName());
            } else {
                addresses = new AddressListProducer((EntityReference<Person>)assigneeRef, (EntityReference<Person>)authorRef, (EntityReference<Person>)postAuthorRef, bookingAgentEmail, customerEmail, travellersEmails, null).collectAddresses(actions);
                if (settings != null) {
                    mailServerParameters = settings.getMailServerParameters();
                    mailFrom.setAddress(settings.getFromAddress());
                } else {
                    MailServerSettings mailServerSettings = MailConfigUtil.readMailServerParameters();
                    mailServerParameters = mailServerSettings.getMailServerParameters();
                    mailFrom.setAddress(mailServerSettings.getDefaultFrom());
                }
            }
            if (addresses.isEmpty()) continue;
            try {
                MailDocument mailDocument;
                IssueNotification issueNotification = new IssueNotification((BaseIssue)issueCtr.getEntity(), oldIssue, event, bookingFile);
                if (issueNotification.getTemplate() == null) {
                    mailDocument = new MailDocumentBuilder(oldIssue, issueCtr, event, () -> mailFrom, addresses, bookingFileCtr).create();
                } else {
                    addresses.stream().map(MailAddress::getAddress).forEach(issueNotification::addOtherRecipient);
                    mailDocument = NotificationHelper.buildMailDocument(issueNotification, false, mailFrom);
                }
                NotificationHelper.sendMail(mailServerParameters, mailDocument, true, delayCurrent);
                delayCurrent += delayDelta;
            }
            catch (Exception ex) {
                IncidentsHelper.addStackTraceElement((Throwable)ex, (StackTraceElement[])new StackTraceElement[]{IncidentsHelper.getContextStackTraceElement((String)"issueNumber", (String)issue.getNumber())});
                IncidentsHelper.addStackTraceElement((Throwable)ex, (StackTraceElement[])new StackTraceElement[]{IncidentsHelper.getContextStackTraceElement((String)"issueEvent", (String)event.toString())});
                IncidentsHelper.addStackTraceElement((Throwable)ex, (StackTraceElement[])new StackTraceElement[]{IncidentsHelper.getContextStackTraceElement((String)"bookingFileNumber", (String)bookingFile.getNumber())});
                log.error("send issueNotification failed", (Throwable)ex);
                SysLogHelper.audit((EntityReference)bookingFileCtr.toReference(), (String)"notification", (Message[])new Message[]{MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)"process event '{0}' failed", (Throwable)ex, (Object[])new Object[]{event.toString()})});
            }
        }
    }

    private BaseIssue oldIssue(LogicalEntityOperationContext globalOperationContext) {
        EntityContainer oldCtr = globalOperationContext.getOldCtr();
        if (EntityStorageHelper.isEmpty((EntityContainer)oldCtr)) {
            return null;
        }
        BaseEntity entity = oldCtr.getEntity();
        if (!(entity instanceof BaseIssue)) {
            return null;
        }
        return (BaseIssue)entity;
    }

    private MessageContext messageContext(LogicalEntityOperationContext globalOperationContext) {
        Map parameters = globalOperationContext.getParameters();
        Object messageContextObj = parameters.get(IBusStandardContextKeys.MESSAGE_CONTEXT.name());
        if (Objects.isNull(messageContextObj)) {
            return null;
        }
        return (MessageContext)messageContextObj;
    }

    private EntityContainer<BookingFile> bookingFileCtr(BaseIssue issue, MessageContext messageContext) {
        EntityContainer bookingFileCtrObj;
        if (Objects.nonNull(messageContext) && Objects.nonNull(bookingFileCtrObj = (EntityContainer)messageContext.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE))) {
            return bookingFileCtrObj;
        }
        EntityReference bookingFileRef = issue.getBooking();
        if (Objects.isNull(bookingFileRef)) {
            return null;
        }
        EntityContainer bookingFileCtr = EntityStorage.get().resolve(bookingFileRef);
        if (EntityStorageHelper.isEmpty((EntityContainer)bookingFileCtr)) {
            return null;
        }
        return bookingFileCtr;
    }

    private PersonCommunication bookingAgentEmail(BookingFile bookingFile) {
        if (bookingFile == null || bookingFile.getReservations() == null || bookingFile.getReservations().isEmpty()) {
            return null;
        }
        EntityReference bookingAgentRef = ((Reservation)bookingFile.getReservations().get(0)).getBookingAgent();
        if (Objects.isNull(bookingAgentRef)) {
            return null;
        }
        EntityContainer bookingAgentCtr = EntityStorage.get().resolve(bookingAgentRef);
        if (EntityStorageHelper.isEmpty((EntityContainer)bookingAgentCtr)) {
            return null;
        }
        return (PersonCommunication)ProfileHelper.filterCommunications((Collection)((Person)bookingAgentCtr.getEntity()).getCommunications(), (CommunicationType)CommunicationType.EMAIL);
    }

    private Communication bookingCustomerEmail(BookingFile bookingFile) {
        if (bookingFile == null) {
            return null;
        }
        Customer customer = bookingFile.getCustomer();
        if (null == customer) {
            return null;
        }
        return ProfileHelper.filterCommunications((Collection)customer.getCommunications(), (CommunicationType)CommunicationType.EMAIL);
    }

    private Collection<Communication> bookingTravellersEmails(BookingFile bookingFile) {
        if (bookingFile == null) {
            return Collections.emptyList();
        }
        return bookingFile.getTravellers().stream().map(t -> ProfileHelper.filterCommunications((Collection)t.getCommunications(), (CommunicationType)CommunicationType.EMAIL)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public NotificationActionsProvider applyRules(BaseIssue issue, NotificationEvent event, BookingFile bookingFile) throws Exception {
        List<EntityReference<Contract>> contractRefs = bookingFile.getReservations().stream().flatMap(r -> r.getProducts().stream()).flatMap(product -> GeneralProductHelper.getHandler((BaseProduct)product).getUnmodifiableContractRelations(product).stream()).map(relationData -> relationData.getGeneralData().getContractData().getContract()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (contractRefs.isEmpty()) {
            return null;
        }
        Date date = new Date();
        NotificationActionsProvider provider = new NotificationActionsProvider();
        NotificationPropertySetImpl propSet = new NotificationPropertySetImpl(issue, event, bookingFile);
        RuleProxy proxy = new RuleProxy();
        proxy.setActionSet((Object)provider);
        proxy.setPropertySet((Object)propSet);
        proxy.setProxyDate(date);
        proxy.setProxyType(NotificationTargets.NOTIFICATION_TARGET.getId());
        NotificationInterceptor.applyRules(contractRefs, proxy, date);
        return provider;
    }

    public static void applyRules(List<EntityReference<Contract>> contractRefs, RuleProxy<?, ?> proxy, Date date) throws Exception {
        for (EntityReference<Contract> contractRef : contractRefs) {
            EntityContainer contractCtr = EntityStorage.get().resolve(contractRef);
            for (EntityContainer rc : ProfileHelper.getRuleContainers((EntityContainer)contractCtr, (Date)date)) {
                RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)((BaseRulesContainer)rc.getEntity()).getRuleSet());
            }
        }
    }
}

