/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.correspondence.storage;

import com.gridnine.xtrip.common.ibecorp.correspondence.handlers.BaseIssueHandler;
import com.gridnine.xtrip.common.ibecorp.correspondence.handlers.IssueHandlersRegistry;
import com.gridnine.xtrip.common.ibecorp.correspondence.rules.NotificationPropertySet;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.BaseIssue;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.IssueSubject;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.NotificationEvent;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.standard.TravelSubjectsPropertyProvider;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Collectors;

public final class NotificationPropertySetImpl
implements NotificationPropertySet,
TravelSubjectsPropertyProvider {
    private final String eventName;
    private final String issueSubject;
    private final String agencyCode;
    private final String subagencyCode;
    private final String clientCode;
    private final Collection<TravelSubject> travelSubjects = new HashSet<TravelSubject>();
    private final String salesPointUid;

    public NotificationPropertySetImpl(BaseIssue issue, NotificationEvent event, BookingFile bookingFile) {
        EntityStorage entityStorage = EntityStorage.get();
        this.agencyCode = this.getOrgCode((EntityReference<Organization>)issue.getAgency(), entityStorage);
        this.subagencyCode = this.getOrgCode((EntityReference<Organization>)issue.getSubagency(), entityStorage);
        this.clientCode = this.getOrgCode((EntityReference<Organization>)issue.getClient(), entityStorage);
        this.eventName = event != null ? event.name() : null;
        BaseIssueHandler handler = IssueHandlersRegistry.get().getHandler(issue.getClass());
        IssueSubject subject = handler.getSubject(issue);
        this.issueSubject = subject != null ? subject.name() : null;
        this.setTravelSubjects(bookingFile);
        EntityReference salesPoint = bookingFile != null ? BookingHelper.getSalesPoint((BookingFile)bookingFile) : null;
        this.salesPointUid = salesPoint != null ? salesPoint.getUid() : null;
    }

    public String getAgency() {
        return this.agencyCode;
    }

    public String getSubagency() {
        return this.subagencyCode;
    }

    public String getClient() {
        return this.clientCode;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getIssueSubject() {
        return this.issueSubject;
    }

    public Collection<TravelSubject> getTravelSubjects() {
        return this.travelSubjects;
    }

    private void setTravelSubjects(BookingFile bookingFile) {
        if (bookingFile != null) {
            this.travelSubjects.addAll(BookingHelper.getTravelSubjects((BookingFile)bookingFile).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
    }

    public String getSalesPointUid() {
        return this.salesPointUid;
    }

    private String getOrgCode(EntityReference<Organization> orgRef, EntityStorage entityStorage) {
        EntityContainer orgCtr = entityStorage.resolve(orgRef);
        return orgCtr != null ? ((Organization)orgCtr.getEntity()).getCode() : null;
    }
}

