/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.correspondence.storage;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.IntegrationBusException;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.BaseIssue;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.IssueIndex;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.IssueStatus;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.NotificationEvent;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.Post;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.RequestForHotelBookingIssue;
import com.gridnine.xtrip.common.model.mail.MailServerParameters;
import com.gridnine.xtrip.common.model.mail.MailServerSettings;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.standard.helpers.HttpHelper;
import com.gridnine.xtrip.common.model.system.ActionSource;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.EmailServerProtocol;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MailSecurityHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.ibecorp.l10n.Messages;
import com.gridnine.xtrip.server.model.mail.MailConfigUtil;
import com.sun.mail.util.MailConnectException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeUtility;

public class ParseHotelEmailsTask
extends BaseScheduledTask {
    private static final String CONFIRMED = "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043e.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doJob() throws Exception {
        String hostIncoming;
        MailServerSettings mailServerSettings = MailConfigUtil.readMailServerParameters();
        MailServerParameters parameters = mailServerSettings.getHotelMailServerParameters();
        Properties props = new Properties();
        EmailServerProtocol emailServerProtocol = mailServerSettings.getProtocolIncoming();
        Integer port = mailServerSettings.getPortIncoming();
        if (port == null) {
            port = this.getDefaultPort(emailServerProtocol);
        }
        String protocol = this.getProtocol(emailServerProtocol);
        if (parameters.isAuth()) {
            props.put("mail." + protocol + ".auth", "true");
        }
        if (TextUtil.isBlank((String)(hostIncoming = mailServerSettings.getHostIncoming()))) {
            throw Xeption.forAdmin((String)"\u0412 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u044b\u0445 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430\u0445 \"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b\" \u043d\u0435 \u0437\u0430\u0434\u0430\u043d \"\u0410\u0434\u0440\u0435\u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0434\u043b\u044f \u0432\u0445\u043e\u0434\u044f\u0449\u0438\u0445 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439\"", (Object[])new Object[0]);
        }
        props.put("mail." + protocol + ".host", hostIncoming);
        if (parameters.isSsl()) {
            props.put("mail.imaps.ssl.trust", "*");
        }
        Session session = Session.getDefaultInstance((Properties)props);
        Store store = session.getStore(protocol);
        try {
            store.connect(hostIncoming, port.intValue(), parameters.getUser(), MailSecurityHelper.decode((String)parameters.getPasswrod()));
            Folder inboxFolder = store.getFolder("INBOX");
            if (!inboxFolder.exists()) {
                throw new IntegrationBusException("folder not found or invalid: " + inboxFolder);
            }
            Folder destFolder = store.getFolder(mailServerSettings.getEmailsFolder());
            if (!destFolder.exists()) {
                destFolder.create(1);
            }
            inboxFolder.open(2);
            try {
                Message[] messages;
                for (Message message : messages = inboxFolder.getMessages()) {
                    try {
                        BaseIssue issue;
                        String subject = message.getSubject();
                        EntityReference issueRef = this.getIssueReference(subject);
                        EntityContainer issueCtr = EntityStorageHelper.resolve(issueRef);
                        if (issueCtr == null) {
                            issueCtr = new EntityContainer(RequestForHotelBookingIssue.class);
                            issueRef = issueCtr.toReference();
                            issue = (BaseIssue)issueCtr.getEntity();
                            issue.setStatus(IssueStatus.NEW);
                            issue.setCreateDate(new Date());
                            issue.setUpdateDate(new Date());
                            issue.setUnreadPosts(issue.getUnreadPosts() + 1);
                            issue.setCreationSource(ActionSource.MIDOFFICE_CLIENT_FX);
                        } else {
                            issue = (BaseIssue)issueCtr.getEntity();
                        }
                        Post post = this.createPost(message, (EntityReference<? extends BaseIssue>)issueRef);
                        if (post.getContent().contains(CONFIRMED)) {
                            Reservation reservation;
                            EntityReference bookingFileRef = issue.getBooking();
                            EntityContainer bookingFileCtr = EntityStorage.get().resolve(bookingFileRef);
                            NestedEntityReference nestedReservation = issue.getReservation();
                            if (bookingFileCtr != null && nestedReservation != null && (reservation = (Reservation)EntityStorageHelper.findNestedEntity((BaseEntity)bookingFileCtr.getEntity(), (NestedEntityReference)nestedReservation)) != null) {
                                reservation.getProducts().stream().filter(baseProduct -> baseProduct instanceof HotelProduct).map(baseProduct -> (HotelProduct)baseProduct).forEach(hotelProduct -> hotelProduct.setStatus(ProductStatus.SELL));
                                bookingFileCtr.getVersionInfo().setDataSource("parse-hotel-emails-task");
                                EntityStorage.get().save(bookingFileCtr, true);
                            }
                        }
                        issue.getEvents().add(NotificationEvent.COMMENT_ADDED);
                        issue.getPosts().add(post);
                        inboxFolder.copyMessages(new Message[]{message}, destFolder);
                        message.setFlag(Flags.Flag.DELETED, true);
                        issueCtr.getVersionInfo().setDataSource("parse-hotel-emails-task");
                        EntityStorage.get().save(issueCtr, true);
                    }
                    catch (Exception e) {
                        this.log.error("failed to create issue", (Throwable)e);
                    }
                }
            }
            finally {
                if (inboxFolder.isOpen()) {
                    inboxFolder.close(true);
                }
            }
        }
        catch (MailConnectException ex) {
            throw Xeption.forAdmin((String)Messages.PARSE_HOTEL_EMAILS_TASK_MAIL_CONNECT_EXCEPTION, (Object[])new Object[]{ex.getHost(), ex.getPort()});
        }
        finally {
            if (store.isConnected()) {
                store.close();
            }
        }
    }

    private Post createPost(Message message, EntityReference<? extends BaseIssue> issueRef) throws MessagingException, IOException, NoSuchAlgorithmException {
        Post post = new Post();
        post.setDateCreated(message.getReceivedDate());
        post.setClient(true);
        post.setContent(this.getText((Part)message));
        Communication communication = new Communication();
        communication.setType(CommunicationType.EMAIL);
        communication.setSense(this.getHeader(message, "From"));
        post.setHotelEmail(communication);
        HashMap<String, DataHandler> attachments = null;
        Object content = message.getContent();
        if (content instanceof Multipart) {
            attachments = new HashMap<String, DataHandler>();
            this.extractAttachmentsFromMultipart((Multipart)content, attachments);
        }
        if (attachments != null && attachments.size() > 0) {
            for (Map.Entry entry : attachments.entrySet()) {
                byte[] data;
                String name = (String)entry.getKey();
                DataHandler dh = (DataHandler)entry.getValue();
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    IoUtil.copyStream((InputStream)dh.getInputStream(), (OutputStream)baos, (int)4096);
                    data = baos.toByteArray();
                }
                EntityContainer docCtr = new EntityContainer(Document.class);
                ContentType contentType = HttpHelper.getContentType((String)dh.getContentType());
                Document doc = (Document)docCtr.getEntity();
                doc.setContent(data);
                doc.setCheckSum(MiscUtil.getCheckSum((byte[])data));
                doc.setContentType(contentType != null ? contentType : ContentType.BINARY);
                doc.setCreated(message.getReceivedDate());
                doc.setDescription(name);
                doc.setName(name);
                doc.setNavigationKey(post.getUid());
                doc.setOwner(issueRef);
                doc.setTitle(name);
                post.getAttachments().add(docCtr.toReference());
                docCtr.getVersionInfo().setDataSource("parse-hotel-emails-task");
                EntityStorage.get().save(docCtr, true);
            }
        }
        return post;
    }

    private EntityReference<BaseIssue> getIssueReference(String subject) {
        String issueNumber = "";
        Pattern pattern = Pattern.compile("Issue number:\\s*(\\d+)");
        Matcher matcher = pattern.matcher(subject);
        if (matcher.find()) {
            issueNumber = matcher.group(1);
        }
        if (TextUtil.nonBlank((String)issueNumber)) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)IssueIndex.Property.number.name(), (Object)issueNumber));
            List issueIndices = EntityStorage.get().search(IssueIndex.class, query).getData();
            if (issueIndices.size() == 1) {
                return ((IssueIndex)issueIndices.get(0)).getSource();
            }
        }
        return null;
    }

    private String getHeader(Message message, String name) throws MessagingException {
        String[] values = message.getHeader(name);
        return values != null ? values[values.length - 1] : null;
    }

    private String getText(Part p) throws MessagingException, IOException {
        if (p.isMimeType("text/*")) {
            return (String)p.getContent();
        }
        if (p.isMimeType("multipart/alternative")) {
            Multipart mp = (Multipart)p.getContent();
            String text = null;
            for (int i = 0; i < mp.getCount(); ++i) {
                BodyPart bp = mp.getBodyPart(i);
                if (bp.isMimeType("text/plain")) {
                    if (text != null) continue;
                    text = this.getText((Part)bp);
                    continue;
                }
                if (bp.isMimeType("text/html")) {
                    String s = this.getText((Part)bp);
                    if (s == null) continue;
                    return s;
                }
                return this.getText((Part)bp);
            }
            return text;
        }
        if (p.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)p.getContent();
            for (int i = 0; i < mp.getCount(); ++i) {
                String s = this.getText((Part)mp.getBodyPart(i));
                if (s == null) continue;
                return s;
            }
        }
        return null;
    }

    private void extractAttachmentsFromMultipart(Multipart mp, Map<String, DataHandler> map) throws MessagingException, IOException {
        for (int i = 0; i < mp.getCount(); ++i) {
            BodyPart part = mp.getBodyPart(i);
            if (part.isMimeType("multipart/*")) {
                this.extractAttachmentsFromMultipart((Multipart)part.getContent(), map);
                continue;
            }
            String disposition = part.getDisposition();
            String fileName = part.getFileName();
            if (fileName != null) {
                fileName = MimeUtility.decodeText((String)fileName);
            }
            if ((disposition == null || !disposition.equalsIgnoreCase("attachment") && !disposition.equalsIgnoreCase("inline")) && fileName == null) continue;
            if (!map.containsKey(fileName)) {
                map.put(fileName, part.getDataHandler());
                continue;
            }
            this.log.warn("cannot extract duplicate file attachment: " + fileName + ".");
        }
    }

    private String getProtocol(EmailServerProtocol protocol) {
        if (protocol == null) {
            return "pop3";
        }
        switch (protocol) {
            case IMAP: {
                return "imap";
            }
            case IMAPS: {
                return "imaps";
            }
            case POP3: {
                return "pop3";
            }
            case POP3S: {
                return "pop3s";
            }
            case SMTP: {
                return "smtp";
            }
            case SMTPS: {
                return "smtps";
            }
        }
        return "pop3";
    }

    private int getDefaultPort(EmailServerProtocol protocol) {
        if (protocol == null) {
            return 110;
        }
        switch (protocol) {
            case IMAP: {
                return 143;
            }
            case IMAPS: {
                return 993;
            }
            case POP3: {
                return 110;
            }
            case POP3S: {
                return 995;
            }
            case SMTP: {
                return 25;
            }
            case SMTPS: {
                return 465;
            }
        }
        return 110;
    }
}

