/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.db.update;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.ibecorp.db.update.UpdateHelper;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import com.gridnine.xtrip.server.update.db.BaseResourceSetupUpdateHandler;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class AircraftUpdateDictionaryHandler
extends BaseResourceSetupUpdateHandler {
    private static final Logger log = LoggerFactory.getLogger(AircraftUpdateDictionaryHandler.class);

    public void execute(Element elm) throws Exception {
        String fileName = XHelper.readString((Element)elm, (String)"@fileName");
        URL url = UpdateHelper.getURL(fileName, this.getBaseResourceUrl());
        List<Aircraft> aircraftXmlList = UpdateHelper.buildBaseEntity(url, Aircraft.class);
        Collection<Aircraft> aircraftDictList = DictionaryCache.get().getAll(Aircraft.class).values();
        for (Aircraft aircraftXml : aircraftXmlList) {
            if (AircraftUpdateDictionaryHandler.isSuccessAddTranslations(aircraftXml, aircraftDictList)) continue;
            AircraftUpdateDictionaryHandler.save(aircraftXml);
            log.info("add Aircraft code " + aircraftXml.getCode());
        }
    }

    private static boolean isSuccessAddTranslations(Aircraft aircraftXml, Collection<Aircraft> aircraftDictList) {
        String codeXml = aircraftXml.getCode();
        if (codeXml != null) {
            for (Aircraft aircraftDict : aircraftDictList) {
                String codeDict = aircraftDict.getCode();
                if (codeDict == null || !codeXml.equals(codeDict)) continue;
                boolean save = false;
                Map translations = aircraftDict.getTranslations();
                for (Locale locale : aircraftXml.getTranslations().keySet()) {
                    if (!TextUtil.isBlank((String)((String)translations.get(locale)))) continue;
                    translations.put(locale, aircraftXml.getTranslations().get(locale));
                    save = true;
                }
                if (save) {
                    AircraftUpdateDictionaryHandler.save(aircraftDict);
                    log.info("update Aircraft code " + aircraftDict.getCode());
                }
                return true;
            }
        }
        return false;
    }

    public static void save(Aircraft aircraft) {
        try {
            aircraft.setDataSource("AircraftUpdateDictionaryHandler");
            DictionaryStorage.get().save((BaseDictionary)aircraft);
        }
        catch (Exception e) {
            String text = "error save code: " + aircraft.getCode();
            log.error(text, (Throwable)e);
            IncidentsLog.reportException((String)text, (Throwable)e);
        }
    }
}

