/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.db.update;

import com.gridnine.xtrip.common.ibecorp.restriction.resource.IbeRestrictionGroupResources;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.security.acl.IbeCorpAclAspect;
import com.gridnine.xtrip.common.model.security.acl.IbeCorpAclAspectIndex;
import com.gridnine.xtrip.common.model.security.acl.IbeCorpAclAspectVariant;
import com.gridnine.xtrip.common.model.security.acl.IbeCorpAclAspectVariantEntry;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.security.acl.entry.AclEntry;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class BookingAclResourceUpdateHandler
implements SetupUpdateHandler {
    public void execute(Element command) throws Exception {
        this.processAcl();
        this.processAclAspects();
    }

    private void processAcl() throws Exception {
        SearchQuery sq = new SearchQuery();
        sq.getCriteria().getCriterions().add(SearchCriterion.eq((String)AclEntry.Property.resourceId.name(), (Object)IbeRestrictionGroupResources.GROUP_ISSUE.getId()));
        List aclEntries = AssetsStorage.get().search(AclEntry.class, sq).getData();
        for (AclEntry aclEntry : aclEntries) {
            AclEntry newAclEntry = (AclEntry)XCloneHelper.clone((XCloneable)aclEntry, (boolean)true);
            newAclEntry.setResourceId(IbeRestrictionGroupResources.GROUP_BOOKING.getId());
            AssetsStorage.get().save((BaseAsset)newAclEntry);
        }
    }

    private void processAclAspects() throws Exception {
        List indexes = EntityStorage.get().search(IbeCorpAclAspectIndex.class, new SearchQuery()).getData();
        for (IbeCorpAclAspectIndex index : indexes) {
            EntityContainer aspectCtr = EntityStorage.get().resolve(index.getSource());
            if (aspectCtr == null) continue;
            boolean changed = false;
            for (IbeCorpAclAspectVariant variant : ((IbeCorpAclAspect)aspectCtr.getEntity()).getVariants()) {
                ArrayList<IbeCorpAclAspectVariantEntry> newVariants = new ArrayList<IbeCorpAclAspectVariantEntry>();
                for (IbeCorpAclAspectVariantEntry aspectVariant : variant.getAspectVariants()) {
                    if (!MiscUtil.equals((Object)aspectVariant.getResourceId(), (Object)IbeRestrictionGroupResources.GROUP_ISSUE.getId())) continue;
                    newVariants.add(this.copyToBooking(aspectVariant));
                }
                if (newVariants.isEmpty()) continue;
                variant.getAspectVariants().addAll(newVariants);
                changed = true;
            }
            if (!changed) continue;
            aspectCtr.getVersionInfo().setDataSource("IBECORP-5321");
            aspectCtr.getVersionInfo().setVersionNotes("add site/booking acl group");
            EntityStorage.get().save(aspectCtr, true);
        }
    }

    private IbeCorpAclAspectVariantEntry copyToBooking(IbeCorpAclAspectVariantEntry source) throws Exception {
        IbeCorpAclAspectVariantEntry result = (IbeCorpAclAspectVariantEntry)XCloneHelper.clone((XCloneable)source, (boolean)true);
        result.setResourceId(IbeRestrictionGroupResources.GROUP_BOOKING.getId());
        return result;
    }
}

