/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.db.update;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.bus.BusStation;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibecorp.db.update.UpdateHelper;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import com.gridnine.xtrip.server.update.db.BaseResourceSetupUpdateHandler;
import java.io.InputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class BusStationUpdateDictionaryHandler
extends BaseResourceSetupUpdateHandler {
    private static final Logger log = LoggerFactory.getLogger(BusStationUpdateDictionaryHandler.class);

    public void execute(Element elm) throws Exception {
        Element root;
        String fileName = XHelper.readString((Element)elm, (String)"@fileName");
        URL url = UpdateHelper.getURL(fileName, this.getBaseResourceUrl());
        try (InputStream strm = IoUtil.getResourceInputStream((URL)url);){
            root = DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)strm)).getDocumentElement();
        }
        for (Element objElm : XmlUtil.getElements((Element)root, (String)"object")) {
            BusStation busStation;
            String code = XmlUtil.getValue((Element)objElm, (String)"code");
            if (!TextUtil.nonBlank((String)code) || (busStation = (BusStation)DictionaryStorage.get().load(BusStation.class, code)) != null) continue;
            busStation = new BusStation();
            busStation.fromXML(objElm);
            if (TextUtil.isBlank((String)busStation.getUid())) {
                busStation.setUid(UUIDGenerator.generate((boolean)true).toString());
            }
            if (TextUtil.isBlank((String)busStation.getCreatedBy())) {
                busStation.setCreatedBy(LogicalStorage.get().getUser());
            }
            if (TextUtil.isBlank((String)busStation.getModifiedBy())) {
                busStation.setModifiedBy(LogicalStorage.get().getUser());
            }
            try {
                busStation.setDataSource("BusStationUpdateDictionaryHandler");
                DictionaryStorage.get().save((BaseDictionary)busStation);
                log.debug("dictionary Bus station with code " + code + " was saved");
            }
            catch (Exception e) {
                String text = String.format("error when saving dictionary Bus station with code: %s", code);
                log.error(text, (Throwable)e);
                IncidentsLog.reportException((String)text, (Throwable)e);
            }
        }
    }
}

