/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.db.update;

import com.gridnine.xtrip.common.gds.rules.FilteringCategories;
import com.gridnine.xtrip.common.gds.rules.Properties;
import com.gridnine.xtrip.common.gds.rules.Targets;
import com.gridnine.xtrip.common.gds.rules.TimeLimitActions;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.TimeLimitType;
import com.gridnine.xtrip.common.model.booking.timelimit.TimeLimitTypeAndTime;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.RulesHolder;
import com.gridnine.xtrip.common.model.profile.RulesHolderIndex;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettingsIndex;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class DefaultRulesForTimeLimit
implements SetupUpdateHandler {
    private static final EntityStorage STORAGE = EntityStorage.get();
    private static final int ONE_DAY_IN_MINUTES = 1440;
    private static final String TASK_CLASS_NAME = "com.gridnine.xtrip.server.ibecorp.tasks.ExpiringTimeLimitNotificationScheduleTask";
    private static final String MINUTES_BEFORE_TIME_LIMIT = "minutesBeforeTimeLimit";

    public void execute(Element command) throws Exception {
        int minutesFromTask = this.getMinutes();
        STORAGE.search(RulesHolderIndex.class, new SearchQuery()).getData().stream().map(rulesIndex -> STORAGE.resolve(rulesIndex.getSource())).forEach(etc -> this.populateRules(this.getRules((EntityContainer<RulesHolder>)etc), minutesFromTask, (EntityContainer<RulesHolder>)etc));
    }

    private int getMinutes() {
        return STORAGE.search(ScheduledTaskSettingsIndex.class, new SearchQuery()).getData().stream().map(index -> STORAGE.resolve(index.getSource())).map(EntityContainer::getEntity).filter(entity -> TASK_CLASS_NAME.equals(entity.getJobClass())).flatMap(entity -> entity.getDataMap().stream()).filter(data -> MINUTES_BEFORE_TIME_LIMIT.equals(data.getName())).findFirst().map(data -> this.convertValue(data.getValue())).orElse(1440);
    }

    private int convertValue(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return 1440;
        }
    }

    private List<RuleSettings> getRules(EntityContainer<RulesHolder> etc) {
        RuleSet ruleSet;
        RulesHolder entity = (RulesHolder)etc.getEntity();
        if (entity != null && (ruleSet = entity.getRuleSet()) != null) {
            return ruleSet.getRules();
        }
        return null;
    }

    private void populateRules(List<RuleSettings> rules, int warningAboutExpiring, EntityContainer<RulesHolder> etc) {
        if (rules == null) {
            return;
        }
        List<RuleSettings> timeLimitRules = this.getTimeLimitRules(rules);
        if (timeLimitRules.isEmpty()) {
            rules.add(this.buildRules(Boolean.TRUE, TimeLimitType.SUPPLIER_TIME_LIMIT, 0));
            rules.add(this.buildRules(Boolean.FALSE, TimeLimitType.BOOKING_TIME, 30));
            rules.add(this.buildRules(warningAboutExpiring));
            STORAGE.save(etc, true);
        } else if (this.isWarningAboutExpiringNeeded(timeLimitRules)) {
            rules.add(this.buildRules(warningAboutExpiring));
            STORAGE.save(etc, true);
        }
    }

    private List<RuleSettings> getTimeLimitRules(List<RuleSettings> rules) {
        return rules.stream().filter(rule -> FilteringCategories.TIME_LIMIT.getId().equals(rule.getFilteringCategory().getId())).collect(Collectors.toList());
    }

    private boolean isWarningAboutExpiringNeeded(List<RuleSettings> timeLimitRules) {
        return timeLimitRules.stream().filter(timeLimitRule -> timeLimitRule.getRestrictions().isEmpty()).flatMap(timeLimitRule -> timeLimitRule.getResults().stream()).noneMatch(rr -> rr.getAction() == TimeLimitActions.WARNING_ABOUT_EXPIRING);
    }

    private RuleSettings buildRules(boolean restrictionValue, TimeLimitType timeLimitType, int timeLimitTime) {
        RuleSettings rs = this.buildRulesCommon();
        rs.getRestrictions().add(this.buildRestrictionTimeLimitFromSupplier(restrictionValue));
        rs.getResults().add(this.buildResultSetTimeLimit(timeLimitType, timeLimitTime));
        return rs;
    }

    private RuleSettings buildRules(int minutes) {
        RuleSettings rs = this.buildRulesCommon();
        rs.getResults().add(this.buildResultWarningAboutExpiring(minutes));
        return rs;
    }

    private RuleSettings buildRulesCommon() {
        RuleSettings rs = new RuleSettings();
        rs.setTarget((RuleTarget)Targets.GDS_PARAMETERS_EX);
        rs.setFilteringCategory((RuleFilteringCategory)FilteringCategories.TIME_LIMIT);
        return rs;
    }

    private RuleRestriction buildRestrictionTimeLimitFromSupplier(boolean value) {
        RuleRestriction restriction = new RuleRestriction();
        restriction.setProperty((RuleProperty)Properties.TIME_LIMIT_FROM_SUPPLIER);
        restriction.setCondition((RuleCondition)Conditions.EQUALS);
        restriction.setValue((Object)value);
        return restriction;
    }

    private RuleResult buildResultWarningAboutExpiring(int minutes) {
        RuleResult result = new RuleResult();
        result.setAction((RuleAction)TimeLimitActions.WARNING_ABOUT_EXPIRING);
        result.setValue(new ArrayList<Integer>(Collections.singletonList(minutes)));
        return result;
    }

    private RuleResult buildResultSetTimeLimit(TimeLimitType type, int time) {
        RuleResult result = new RuleResult();
        result.setAction((RuleAction)TimeLimitActions.SET_TIME_LIMIT);
        result.setValue((Object)this.buildTimeLimitTypeAndTime(type, time));
        return result;
    }

    private TimeLimitTypeAndTime buildTimeLimitTypeAndTime(TimeLimitType type, int time) {
        TimeLimitTypeAndTime value = new TimeLimitTypeAndTime();
        value.setType(type);
        value.setTime(time);
        return value;
    }
}

