/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.db.update;

import com.gridnine.xtrip.common.ibecorp.rules.Actions;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.profile.ModelContractIndex;
import com.gridnine.xtrip.common.model.rules.finance.Targets;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class IbeCorpMigrateSbisRulesHandler
implements SetupUpdateHandler {
    public void execute(Element command) throws Exception {
        for (ModelContractIndex index : EntityStorage.get().search(ModelContractIndex.class, new SearchQuery()).getData()) {
            EntityContainer modelContract = EntityStorage.get().resolve(index.getSource());
            if (EntityStorageHelper.isEmpty((EntityContainer)modelContract) || ((ModelContract)modelContract.getEntity()).getRuleSet() == null) continue;
            HashMap sbisRules = new HashMap();
            for (RuleSettings ruleSettings : ((ModelContract)modelContract.getEntity()).getRuleSet().getRules()) {
                List sbisRuleResults;
                if (ruleSettings.getTarget() == null || !Targets.SHIPMENT.getId().equals(ruleSettings.getTarget().getId()) || (sbisRuleResults = ruleSettings.getResults().stream().filter(result -> result.getAction() != null && Actions.SBIS_DOCUMENTS_FORMAT.getId().equals(result.getAction().getId())).collect(Collectors.toList())).isEmpty()) continue;
                sbisRules.put(ruleSettings, sbisRuleResults);
            }
            if (sbisRules.isEmpty()) continue;
            for (Map.Entry entry : sbisRules.entrySet()) {
                RuleSettings oldRule = (RuleSettings)entry.getKey();
                List ruleResults = (List)entry.getValue();
                RuleSettings newRule = new RuleSettings();
                newRule.setTarget((RuleTarget)com.gridnine.xtrip.common.ibecorp.rules.Targets.SBIS_PARAMETERS);
                newRule.setName(oldRule.getName());
                newRule.setPeriodBegin(oldRule.getPeriodBegin());
                newRule.setPeriodEnd(oldRule.getPeriodEnd());
                newRule.setIgnoreOnExport(oldRule.isIgnoreOnExport());
                newRule.setPreserveOnImport(oldRule.isPreserveOnImport());
                newRule.setDescription(oldRule.getDescription());
                newRule.getResults().addAll(ruleResults);
                oldRule.getResults().removeAll(ruleResults);
                ((ModelContract)modelContract.getEntity()).getRuleSet().getRules().add(newRule);
                if (!oldRule.getResults().isEmpty()) continue;
                ((ModelContract)modelContract.getEntity()).getRuleSet().getRules().remove(oldRule);
            }
            modelContract.getVersionInfo().setDataSource("migrate-sbis-rules-task");
            EntityStorage.get().save(modelContract, true);
        }
    }
}

