/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.db.update;

import com.gridnine.xtrip.common.gds.sabre.Co2EmissionsComplementBookingHandlerSettings;
import com.gridnine.xtrip.common.gds.sabre.rules.SabreActions;
import com.gridnine.xtrip.common.ibecorp.model.AirCO2EmissionSettings;
import com.gridnine.xtrip.common.midoffice.model.ComplementBookingSettings;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.rules.standard.MidofficeTargets;
import com.gridnine.xtrip.common.model.system.BaseSystemSettings;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.util.List;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class MigrateAirCo2EmissionSettingsHandler
implements SetupUpdateHandler {
    public void execute(Element command) throws Exception {
        List<EntityReference<AirCO2EmissionSettings>> oldSettingsRefs = this.findSystemSettings(AirCO2EmissionSettings.class);
        for (EntityReference<AirCO2EmissionSettings> oldSettingsRef : oldSettingsRefs) {
            EntityContainer oldSettingsCtr = EntityStorage.get().resolve(oldSettingsRef);
            AirCO2EmissionSettings oldSettings = (AirCO2EmissionSettings)oldSettingsCtr.getEntity();
            if (oldSettings.getSabreGdsAccount() != null) {
                List<EntityReference<ComplementBookingSettings>> newSettingsRefs = this.findSystemSettings(ComplementBookingSettings.class);
                EntityReference<ComplementBookingSettings> newSettingsRef = newSettingsRefs.isEmpty() ? null : newSettingsRefs.get(0);
                EntityContainer newSettingsCtr = EntityStorage.get().resolve(newSettingsRef);
                if (newSettingsCtr == null) {
                    newSettingsCtr = EntityContainer.create((BaseEntity)new ComplementBookingSettings());
                }
                ComplementBookingSettings newSettings = (ComplementBookingSettings)newSettingsCtr.getEntity();
                newSettings.setName("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0434\u043e\u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0437\u0430\u043a\u0430\u0437\u0430");
                RuleSettings rs = new RuleSettings();
                rs.setName(oldSettings.getName());
                rs.setTarget((RuleTarget)MidofficeTargets.COMPLEMENT_BOOKING);
                RuleResult rr = new RuleResult();
                rr.setAction((RuleAction)SabreActions.SABRE_CO2_EMISSIONS_COMPLEMENT_BOOKING);
                Co2EmissionsComplementBookingHandlerSettings value = new Co2EmissionsComplementBookingHandlerSettings();
                value.setActive(true);
                value.setGdsAccount(oldSettings.getSabreGdsAccount());
                rr.setValue((Object)value);
                rs.getResults().add(rr);
                newSettings.getRuleSet().getRules().add(rs);
                EntityStorage.get().save(newSettingsCtr, true);
            }
            EntityStorage.get().delete(oldSettingsCtr);
        }
    }

    private <S extends BaseSystemSettings> List<EntityReference<S>> findSystemSettings(Class<S> clazz) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"entityType", (Object)clazz.getName()));
        return EntityStorage.get().search(BasicSystemSettingsIndex.class, query).getData().stream().map(ind -> ind.getSource()).collect(Collectors.toList());
    }
}

