/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.db.update;

import com.gridnine.xtrip.common.ibecorp.rules.IbecorpFilteringCategories;
import com.gridnine.xtrip.common.ibecorp.rules.IbecorpProperties;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.ibecorp.PriceDetailDisplay;
import com.gridnine.xtrip.common.model.ibecorp.PriceDetailDisplayArea;
import com.gridnine.xtrip.common.model.profile.RulesHolder;
import com.gridnine.xtrip.common.model.profile.RulesHolderIndex;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class MigratePriceDetailDisplayAreaHandler
implements SetupUpdateHandler {
    private final Logger log = LoggerFactory.getLogger(MigratePriceDetailDisplayAreaHandler.class);

    public void execute(Element elm) throws Exception {
        Collection<EntityContainer<RulesHolder>> rulesHolderList = this.getRulesHolderList();
        for (EntityContainer<RulesHolder> rulesHolderCtr : rulesHolderList) {
            this.log.info(String.format("init name %s, uid %s", ((RulesHolder)rulesHolderCtr.getEntity()).toString(), rulesHolderCtr.getUid()));
            List rules = ((RulesHolder)rulesHolderCtr.getEntity()).getRuleSet().getRules();
            ArrayList rulesClone = new ArrayList(rules);
            rules.clear();
            boolean save = false;
            for (RuleSettings rule : rulesClone) {
                if (IbecorpFilteringCategories.PRICE_DETAIL_DISPLAY.equals((Object)rule.getFilteringCategory())) {
                    if (MigratePriceDetailDisplayAreaHandler.isDetailed(rule)) {
                        rule.getRestrictions().add(MigratePriceDetailDisplayAreaHandler.createRuleRestriction(PriceDetailDisplayArea.SITE, PriceDetailDisplayArea.NOTIFICATION));
                        this.log.info(String.format("Add rule restriction SITE and NOTIFICATION in rule: name - %s, uid - %s", rule.getName(), rule.getUid()));
                    } else {
                        RuleSettings newRuleSettings = MigratePriceDetailDisplayAreaHandler.getNewRuleSettings(rule);
                        rules.add(newRuleSettings);
                        this.log.info(String.format("Create new rule: name - %s, uid - %s, rule based: name - %s, uid - %s", newRuleSettings.getName(), newRuleSettings.getUid(), rule.getName(), rule.getUid()));
                        rule.getRestrictions().add(MigratePriceDetailDisplayAreaHandler.createRuleRestriction(PriceDetailDisplayArea.SITE));
                        this.log.info(String.format("Add rule restriction SITE in rule: name - %s, uid - %s", rule.getName(), rule.getUid()));
                    }
                    save = true;
                }
                rules.add(rule);
            }
            this.log.info(String.format("end name %s, uid %s, changes = %s ", ((RulesHolder)rulesHolderCtr.getEntity()).toString(), rulesHolderCtr.getUid(), save));
            this.save(rulesHolderCtr, save);
        }
        this.log.info("Migration completed");
    }

    private Collection<EntityContainer<RulesHolder>> getRulesHolderList() {
        List rulesHolderIndices = EntityStorage.get().search(RulesHolderIndex.class, new SearchQuery()).getData();
        return MiscUtil.guarded((Collection)rulesHolderIndices).stream().map(RulesHolderIndex::getSource).map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)).filter(EntityStorageHelper::nonEmpty).collect(Collectors.toList());
    }

    private static boolean isDetailed(RuleSettings rule) {
        return rule.getResults().stream().map(RuleResult::getValue).filter(Objects::nonNull).anyMatch(e -> e.equals(PriceDetailDisplay.DETAILED));
    }

    private static RuleSettings getNewRuleSettings(RuleSettings rule) throws Exception {
        RuleSettings cloneRuleSettings = (RuleSettings)XCloneHelper.clone((XCloneable)rule, (boolean)true);
        cloneRuleSettings.getRestrictions().add(MigratePriceDetailDisplayAreaHandler.createRuleRestriction(PriceDetailDisplayArea.NOTIFICATION));
        for (RuleResult result : cloneRuleSettings.getResults()) {
            result.setValue((Object)PriceDetailDisplay.DETAILED);
        }
        cloneRuleSettings.setName((String)MiscUtil.guarded((Object)cloneRuleSettings.getName(), (Object)"") + " (new notification rule)");
        return cloneRuleSettings;
    }

    public static RuleRestriction createRuleRestriction(PriceDetailDisplayArea ... priceDetailDisplayAreas) {
        RuleRestriction rr = new RuleRestriction();
        rr.setProperty((RuleProperty)IbecorpProperties.PRICE_DETAIL_DISPLAY_AREA);
        rr.setCondition((RuleCondition)Conditions.INCLUDE);
        rr.setValue(Arrays.asList(priceDetailDisplayAreas));
        return rr;
    }

    private void save(EntityContainer<RulesHolder> rulesHolderCtr, boolean save) {
        if (save) {
            rulesHolderCtr.getVersionInfo().setModified(new Date());
            rulesHolderCtr.getVersionInfo().setModifiedBy("system");
            rulesHolderCtr.getVersionInfo().setDataSource("data-migration");
            rulesHolderCtr.getVersionInfo().setVersionNotes("IBECORP-5309");
            EntityStorage.get().save(rulesHolderCtr, true);
        }
    }
}

