/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.db.update;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMCurrencyDisplaySettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettingsIndex;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.w3c.dom.Element;

public class MigrateSMGeneralSettingsDisplayCurrenciesHandler
implements SetupUpdateHandler {
    public void execute(Element command) throws Exception {
        SearchQuery query = new SearchQuery();
        List data = EntityStorage.get().search(SMGeneralSettingsIndex.class, query).getData();
        for (SMGeneralSettingsIndex idx : data) {
            EntityContainer ctr = EntityStorage.get().resolve(idx.getSource());
            if (!((SMGeneralSettings)ctr.getEntity()).isCurrencyConverterEnabled()) continue;
            ((SMGeneralSettings)ctr.getEntity()).getDisplayCurrencies().add(MigrateSMGeneralSettingsDisplayCurrenciesHandler.createSettings("USD"));
            ((SMGeneralSettings)ctr.getEntity()).getDisplayCurrencies().add(MigrateSMGeneralSettingsDisplayCurrenciesHandler.createSettings("EUR"));
            ctr.getVersionInfo().setDataSource(this.getClass().getSimpleName());
            EntityStorage.get().save(ctr, true);
        }
    }

    private static SMCurrencyDisplaySettings createSettings(String code) {
        SMCurrencyDisplaySettings result = new SMCurrencyDisplaySettings();
        result.setCurrency((DictionaryReference)Objects.requireNonNull(DictHelper.getCurrencyInfoByAnyCode((String)code)).toReference());
        result.setRateType(CurrencyRateType.IATA);
        result.setRiskRatio(new BigDecimal("1.00"));
        result.setRoundingValue(RoundingValue.V_1);
        result.setRoundingMode(RoundingMode.MATH);
        return result;
    }
}

