/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.db.update;

import com.gridnine.xtrip.common.gds.rules.Properties;
import com.gridnine.xtrip.common.ibecorp.rules.IbecorpFilteringCategories;
import com.gridnine.xtrip.common.ibecorp.rules.IbecorpProperties;
import com.gridnine.xtrip.common.ibecorp.rules.PriceDetailActions;
import com.gridnine.xtrip.common.ibecorp.rules.Targets;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.ibecorp.PriceDetailDisplay;
import com.gridnine.xtrip.common.model.ibecorp.sm.AgencyFeeDisplayStyle;
import com.gridnine.xtrip.common.model.ibecorp.sm.BaseSMProfileIndex;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMProfileType;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep3Settings;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.RulesHolder;
import com.gridnine.xtrip.common.model.profile.RulesHolderIndex;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class PriceDetailDisplayMigrationHandler
implements SetupUpdateHandler {
    private final Logger log = LoggerFactory.getLogger(PriceDetailDisplayMigrationHandler.class);
    private static final Map<AgencyFeeDisplayStyle, PriceDetailDisplay> displayStylePriceDetailMap = new HashMap<AgencyFeeDisplayStyle, PriceDetailDisplay>();

    public void execute(Element elm) throws Exception {
        Map<PriceDetailDisplay, List<EntityReference<SMSite>>> map = this.getPriceDetailDisplayMap();
        Collection<OrganizationIndex> organizationAllIndex = this.getOrganizationAllIndex();
        this.log.info("For migration settings site in rules organizations received: " + organizationAllIndex.size());
        for (OrganizationIndex org : organizationAllIndex) {
            EntityReference b2bSite = org.getB2bSite();
            EntityReference entityReference = org.getB2cSite();
        }
        this.sortRulesHolderForRestrictionsAgencyCode();
        this.log.info("Migration completed");
    }

    private void builder(Map<PriceDetailDisplay, List<EntityReference<SMSite>>> map, OrganizationIndex org, EntityReference<SMSite> site, List<String> b2bRulesUids) {
        if (CollectionUtil.isNotEmpty(b2bRulesUids) && site != null) {
            PriceDetailDisplay priceDetailDisplay = this.getPriceDetailDisplay(map, site);
            Collection<EntityContainer<RulesHolder>> rulesHolderList = this.getRulesHolderList(b2bRulesUids);
            rulesHolderList.forEach(rulesHolderIndex -> {
                RuleSettings ruleSettings = this.createRuleSettings(org, site, priceDetailDisplay);
                if (this.updateRule((EntityContainer<RulesHolder>)rulesHolderIndex, ruleSettings)) {
                    this.log.info(String.format("Moved settings from site %s to rules %s", ((RulesHolder)rulesHolderIndex.getEntity()).getName(), site.getCaption()));
                } else {
                    this.log.info(String.format("Failed to create rules, from %s to rules %s", ((RulesHolder)rulesHolderIndex.getEntity()).getName(), site.getCaption()));
                }
            });
        } else {
            this.log.info(String.format("There are no migration settings for organizations %s", org.getName()));
        }
    }

    private RuleSettings createRuleSettings(OrganizationIndex org, EntityReference<SMSite> site, PriceDetailDisplay priceDetailDisplay) {
        RuleSettings ruleSettings = new RuleSettings();
        ruleSettings.setName(String.join((CharSequence)" ", ((L10nString)MiscUtil.guarded((Object)org.getName(), (Object)org.getShortName())).toString(), site.getCaption()));
        ruleSettings.setFilteringCategory((RuleFilteringCategory)IbecorpFilteringCategories.PRICE_DETAIL_DISPLAY);
        ruleSettings.setTarget((RuleTarget)Targets.PRICE_DETAIL_DISPLAY);
        RuleResult ruleResult = new RuleResult();
        ruleResult.setAction((RuleAction)PriceDetailActions.PRICE_DETAIL_DISPLAY);
        ruleResult.setValue((Object)priceDetailDisplay);
        ruleSettings.getResults().add(ruleResult);
        RuleRestriction ruleRestrictionSiteType = new RuleRestriction();
        ruleRestrictionSiteType.setProperty((RuleProperty)IbecorpProperties.SM_SITE_TYPE);
        ruleRestrictionSiteType.setCondition((RuleCondition)Conditions.EQUALS);
        EntityContainer smSite = EntityStorage.get().resolve(site);
        if (EntityStorageHelper.isEmpty((EntityContainer)smSite)) {
            return null;
        }
        ruleRestrictionSiteType.setValue((Object)((SMSite)smSite.getEntity()).getSiteType());
        ruleSettings.getRestrictions().add(ruleRestrictionSiteType);
        RuleRestriction ruleRestrictionAgencyCode = new RuleRestriction();
        Properties propertiesCode = org.getTypes().contains(OrganizationType.AGENCY) && org.getTypes().contains(OrganizationType.CORPORATE_CLIENT) || org.getTypes().contains(OrganizationType.AGENCY) ? Properties.SUBAGENCY_CODE : Properties.CLIENT_CODE;
        ruleRestrictionAgencyCode.setProperty((RuleProperty)propertiesCode);
        ruleRestrictionAgencyCode.setCondition((RuleCondition)Conditions.INCLUDE);
        ruleRestrictionAgencyCode.setValue(Arrays.asList(org.getCode()));
        ruleSettings.getRestrictions().add(ruleRestrictionAgencyCode);
        return ruleSettings;
    }

    private Collection<EntityContainer<RulesHolder>> getRulesHolderList(List<String> b2bRulesUids) {
        SearchQuery queryRule = new SearchQuery();
        queryRule.getCriteria().getCriterions().add(SearchCriterion.in((String)"containerUid", (Object[])b2bRulesUids.toArray()));
        List rulesHolderIndices = EntityStorage.get().search(RulesHolderIndex.class, queryRule).getData();
        return MiscUtil.guarded((Collection)rulesHolderIndices).stream().map(RulesHolderIndex::getSource).map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)).filter(EntityStorageHelper::nonEmpty).collect(Collectors.toList());
    }

    private PriceDetailDisplay getPriceDetailDisplay(Map<PriceDetailDisplay, List<EntityReference<SMSite>>> map, EntityReference<SMSite> b2bSite) {
        return map.entrySet().stream().filter(m -> ((List)m.getValue()).contains(b2bSite)).map(Map.Entry::getKey).filter(Objects::nonNull).findFirst().orElse(PriceDetailDisplay.TOTAL_ONLY);
    }

    private Map<PriceDetailDisplay, List<EntityReference<SMSite>>> getPriceDetailDisplayMap() {
        HashMap<PriceDetailDisplay, List<EntityReference<SMSite>>> map = new HashMap<PriceDetailDisplay, List<EntityReference<SMSite>>>();
        SearchQuery querySMP = new SearchQuery();
        querySMP.getCriteria().getCriterions().add(SearchCriterion.eq((String)BaseSMProfileIndex.Property.profileType.name(), (Object)SMProfileType.STEP3_SETTINGS));
        List indexes = EntityStorage.get().search(BaseSMProfileIndex.class, querySMP).getData();
        for (BaseSMProfileIndex baseSMProfileIndex : MiscUtil.guarded((Collection)indexes)) {
            EntityContainer etc = EntityStorage.get().resolve(baseSMProfileIndex.getSource());
            if (!EntityStorageHelper.nonEmpty((EntityContainer)etc)) continue;
            SMStep3Settings baseSMProfile = (SMStep3Settings)etc.getEntity();
            AgencyFeeDisplayStyle agencyFeeDisplayStyle = baseSMProfile.getAgencyFeeDisplayStyle();
            map.computeIfAbsent(displayStylePriceDetailMap.get(agencyFeeDisplayStyle), list -> new ArrayList()).add(baseSMProfileIndex.getSite());
        }
        return map;
    }

    private Collection<OrganizationIndex> getOrganizationAllIndex() {
        SearchQuery queryOrg = new SearchQuery();
        queryOrg.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.AGENCY), SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.CORPORATE_CLIENT)}));
        this.preferredProperties(queryOrg);
        List organizationIndex = EntityStorage.get().search(OrganizationIndex.class, queryOrg).getData();
        return MiscUtil.guarded((Collection)organizationIndex);
    }

    private void preferredProperties(SearchQuery queryOrg) {
        queryOrg.getPreferredProperties().addAll(Arrays.asList(OrganizationIndex.Property.code.name(), OrganizationIndex.Property.name.name(), OrganizationIndex.Property.shortName.name(), OrganizationIndex.Property.b2bSite.name(), OrganizationIndex.Property.b2cSite.name(), OrganizationIndex.Property.parent.name(), OrganizationIndex.Property.types.name()));
    }

    private boolean updateRule(EntityContainer<RulesHolder> rulesHolderIndex, RuleSettings ruleSettings) {
        if (ruleSettings != null) {
            List rules = ((RulesHolder)rulesHolderIndex.getEntity()).getRuleSet().getRules();
            rules.add(ruleSettings);
            rulesHolderIndex.getVersionInfo().setDataSource("data-migration");
            rulesHolderIndex.getVersionInfo().setVersionNotes("Migration price display settings to site rules");
            EntityStorage.get().save(rulesHolderIndex, true);
            return true;
        }
        return false;
    }

    private void sortRulesHolderForRestrictionsAgencyCode() {
        List rulesHolderIndices = EntityStorage.get().search(RulesHolderIndex.class, new SearchQuery()).getData();
        MiscUtil.guarded((Collection)rulesHolderIndices).stream().map(RulesHolderIndex::getSource).map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)).filter(EntityStorageHelper::nonEmpty).peek(rulesHolderCtr -> {
            List rules = ((RulesHolder)rulesHolderCtr.getEntity()).getRuleSet().getRules();
            if (CollectionUtil.isNotEmpty((Collection)rules)) {
                rules.sort(Comparator.comparing(rs -> rs.getFilteringCategory() == IbecorpFilteringCategories.PRICE_DETAIL_DISPLAY && rs.getRestrictions().stream().anyMatch(ruleRestriction -> Properties.CLIENT_CODE.equals((Object)ruleRestriction.getProperty()))));
            }
        }).forEach(rulesHolder -> EntityStorage.get().save(rulesHolder, true));
    }

    static {
        displayStylePriceDetailMap.put(AgencyFeeDisplayStyle.SEPARATE, PriceDetailDisplay.DETAILED_WITH_FEES_IN_TAXES);
        displayStylePriceDetailMap.put(AgencyFeeDisplayStyle.SUM_WITH_AIRLINE_FEE, PriceDetailDisplay.DETAILED);
        displayStylePriceDetailMap.put(AgencyFeeDisplayStyle.SUM_WITH_TOTAL_ONLY, PriceDetailDisplay.TOTAL_ONLY);
        displayStylePriceDetailMap.put(AgencyFeeDisplayStyle.TOTAL_ONLY, PriceDetailDisplay.TOTAL_ONLY);
    }
}

