/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.db.update;

import com.gridnine.xtrip.common.model.booking.xtriphotels.MainHotelProductIndex;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class RemoveObsoleteHotelAggregatorGeoLocationsHandler
implements SetupUpdateHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void execute(Element command) throws Exception {
        EntityStorage entityStorage = EntityStorage.get();
        HashSet<String> existingCodes = new HashSet<String>(Files.readAllLines(Paths.get(this.getClass().getResource("hotel-agg-geo.dat").toURI())));
        DictionaryCache.get().getAll(GeoLocation.class).values().forEach(loc -> {
            try {
                String haCode = (String)loc.getCodeVariants().get(CodeSystem.HOTEL_AGGREGATOR.name());
                if (haCode != null && !existingCodes.contains(haCode)) {
                    loc.getCodeVariants().remove(CodeSystem.HOTEL_AGGREGATOR.name());
                    if (loc.getCodeVariants().isEmpty()) {
                        SearchQuery query = new SearchQuery();
                        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)MainHotelProductIndex.Property.hotelCity.name(), (Object)loc.toReference()));
                        query.setResultMode(ResultMode.COUNT_ONLY);
                        int totalCount = entityStorage.search(MainHotelProductIndex.class, query).getTotalCount();
                        if (totalCount == 0) {
                            DictionaryStorage.get().delete((BaseDictionary)loc);
                            this.logger.debug("removed geolocation {}", (Object)loc.getCode());
                        } else {
                            this.logger.error("geolocation {} was not removed because there are {} products linked to it", (Object)loc.getCode(), (Object)totalCount);
                        }
                    } else {
                        DictionaryStorage.get().save((BaseDictionary)loc);
                        this.logger.debug("geolocation {} was not removed because it has other codes", (Object)loc.getCode());
                    }
                }
            }
            catch (Exception ex) {
                this.logger.error("failed for location {}", (Object)loc.getCode(), (Object)ex);
            }
        });
    }
}

