/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.db.update;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.TravelPolicyMatchType;
import com.gridnine.xtrip.common.model.ibecorp.travelPolicy.TravelPolicyMinimalPriceRuleValue;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.profile.ModelContractIndex;
import com.gridnine.xtrip.common.model.travelPolicy.OrganizationTravelPolicy;
import com.gridnine.xtrip.common.model.travelPolicy.OrganizationTravelPolicyAuthorizationStep;
import com.gridnine.xtrip.common.model.travelPolicy.OrganizationTravelPolicyIndex;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationParameters;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyRuleRouteLimitParameters;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class TravelPolicyMigrationHandler
implements SetupUpdateHandler {
    private static final Logger log = LoggerFactory.getLogger(TravelPolicyMigrationHandler.class);

    public void execute(Element command) throws Exception {
        EntityContainer ctr;
        SearchQuery query = new SearchQuery();
        query.getPreferredProperties().add("uid");
        for (ModelContractIndex idx : EntityStorage.get().search(ModelContractIndex.class, query).getData()) {
            ctr = EntityStorage.get().resolve(idx.getSource());
            TravelPolicyMigrationHandler.migrate(((ModelContract)ctr.getEntity()).getRuleSet(), ctr);
        }
        for (ModelContractIndex idx : EntityStorage.get().search(ContractIndex.class, query).getData()) {
            ctr = EntityStorage.get().resolve(idx.getSource());
            TravelPolicyMigrationHandler.migrate(((Contract)ctr.getEntity()).getRuleSet(), ctr);
        }
        for (ModelContractIndex idx : EntityStorage.get().search(OrganizationTravelPolicyIndex.class, query).getData()) {
            ctr = EntityStorage.get().resolve(idx.getSource());
            TravelPolicyMigrationHandler.migrate(((OrganizationTravelPolicy)ctr.getEntity()).getRuleSet(), ctr);
            if (((OrganizationTravelPolicy)ctr.getEntity()).getAuthorizationScheme() == null) continue;
            for (OrganizationTravelPolicyAuthorizationStep step : ((OrganizationTravelPolicy)ctr.getEntity()).getAuthorizationScheme().getSteps()) {
                TravelPolicyMigrationHandler.migrate(step.getRules(), ctr);
            }
        }
    }

    private static void migrate(RuleSet ruleSet, EntityContainer<?> ctr) {
        if (ruleSet == null || ruleSet.getRules() == null) {
            return;
        }
        boolean modified = false;
        for (RuleSettings rs : ruleSet.getRules()) {
            TravelPolicyRuleRouteLimitParameters newParams;
            com.gridnine.xtrip.common.model.ibecorp.TravelPolicyRuleRouteLimitParameters oldParams;
            for (RuleRestriction restriction : rs.getRestrictions()) {
                if (restriction.getValue() instanceof com.gridnine.xtrip.common.model.ibecorp.TravelPolicyRuleRouteLimitParameters) {
                    oldParams = (com.gridnine.xtrip.common.model.ibecorp.TravelPolicyRuleRouteLimitParameters)restriction.getValue();
                    newParams = new TravelPolicyRuleRouteLimitParameters();
                    newParams.setArriveLocation(oldParams.getArriveLocation());
                    newParams.setDepartureLocation(oldParams.getDepartureLocation());
                    newParams.setOneWayAmount(oldParams.getOneWayAmount());
                    newParams.setRoundTripAmount(oldParams.getRoundTripAmount());
                    restriction.setValue((Object)newParams);
                    modified = true;
                }
                if (!(restriction.getValue() instanceof TravelPolicyMinimalPriceRuleValue)) continue;
                oldParams = (TravelPolicyMinimalPriceRuleValue)restriction.getValue();
                newParams = new com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyMinimalPriceRuleValue();
                newParams.setPercent(oldParams.getPercent());
                if (oldParams.getProperties() != null) {
                    try {
                        newParams.setValue("properties", (Object)EntityStorage.get().resolve(oldParams.getProperties()).toReference());
                    }
                    catch (Exception e) {
                        log.error(String.format("failed to set properties in rules, %s", ctr), (Throwable)e);
                    }
                }
                restriction.setValue((Object)newParams);
                modified = true;
            }
            for (RuleResult rr : rs.getResults()) {
                if (rr.getValue() instanceof TravelPolicyMatchType) {
                    TravelPolicyMatchType matchType = (TravelPolicyMatchType)rr.getValue();
                    rr.setValue((Object)com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyMatchType.valueOf((String)matchType.name()));
                    modified = true;
                }
                if (!(rr.getValue() instanceof com.gridnine.xtrip.common.model.ibecorp.TravelPolicyAuthorizationParameters)) continue;
                oldParams = (com.gridnine.xtrip.common.model.ibecorp.TravelPolicyAuthorizationParameters)rr.getValue();
                newParams = new TravelPolicyAuthorizationParameters();
                newParams.setTimeLimit(oldParams.getTimeLimit());
                newParams.setPriceLimitPercent(oldParams.getPriceLimitPercent());
                newParams.getSteps().addAll(oldParams.getSteps());
                rr.setValue((Object)newParams);
                modified = true;
            }
        }
        if (modified) {
            try {
                ctr.getVersionInfo().setDataSource("TravelPolicyMigrationHandler");
                EntityStorage.get().save(ctr, true);
            }
            catch (Exception e) {
                log.error(String.format("failed to save rules, %s", ctr), (Throwable)e);
            }
        }
    }
}

