/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.db.update;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.TravelPolicyMatchType;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.profile.ModelContractIndex;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyActions;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import org.w3c.dom.Element;

public class TravelPolicyRecommendedMigrationHandler
implements SetupUpdateHandler {
    public void execute(Element command) throws Exception {
        EntityContainer ctr;
        SearchQuery query = new SearchQuery();
        query.getPreferredProperties().add("uid");
        for (ModelContractIndex idx : EntityStorage.get().search(ModelContractIndex.class, query).getData()) {
            ctr = EntityStorage.get().resolve(idx.getSource());
            TravelPolicyRecommendedMigrationHandler.migrate(((ModelContract)ctr.getEntity()).getRuleSet(), ctr);
        }
        for (ModelContractIndex idx : EntityStorage.get().search(ContractIndex.class, query).getData()) {
            ctr = EntityStorage.get().resolve(idx.getSource());
            TravelPolicyRecommendedMigrationHandler.migrate(((Contract)ctr.getEntity()).getRuleSet(), ctr);
        }
    }

    private static void migrate(RuleSet ruleSet, EntityContainer<?> ctr) {
        if (ruleSet == null || ruleSet.getRules() == null) {
            return;
        }
        boolean modified = false;
        for (RuleSettings rs : ruleSet.getRules()) {
            for (RuleResult rr : rs.getResults()) {
                TravelPolicyMatchType matchType;
                if (rr.getAction() != TravelPolicyActions.TRAVEL_POLICY_MATCH_TYPE || !(rr.getValue() instanceof TravelPolicyMatchType) || (matchType = (TravelPolicyMatchType)rr.getValue()) != TravelPolicyMatchType.RECOMMENDED) continue;
                rr.setAction((RuleAction)TravelPolicyActions.TRAVEL_POLICY_RECOMMENDED);
                rr.setValue((Object)Boolean.TRUE);
                modified = true;
            }
        }
        if (modified) {
            ctr.getVersionInfo().setDataSource("TravelPolicyRecommendedMigrationHandler");
            EntityStorage.get().save(ctr, true);
        }
    }
}

