/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.db.update;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.common.model.profile.TripartiteContractIndex;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.tripartite.AviaTripartiteContractActions;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.w3c.dom.Element;

public class TripartiteContractRemovePrefixAccountCodeHandler
implements SetupUpdateHandler {
    private static final String PREFIX_ACC = "ACC";
    private static final String PREFIX_IDT = "\u0418\u0414\u0422";
    private static final int PREFIX_LENGTH = "ACC".length();

    public void execute(Element command) throws Exception {
        SearchQuery query = this.buildSearchQuery();
        EntityStorage entityStorage = EntityStorage.get();
        entityStorage.search(TripartiteContractIndex.class, query).getData().stream().map(index -> entityStorage.resolve(index.getSource())).filter(this::isSaveNeeded).forEach(etc -> entityStorage.save(etc, true));
    }

    private SearchQuery buildSearchQuery() {
        SearchQuery query = new SearchQuery();
        List criteria = query.getCriteria().getCriterions();
        criteria.add(SearchCriterion.ne((String)TripartiteContractIndex.Property.accountCode.name(), null));
        return query;
    }

    private boolean isSaveNeeded(EntityContainer<TripartiteContract> etc) {
        AtomicBoolean isModified = new AtomicBoolean(false);
        RuleSet ruleSet = ((TripartiteContract)etc.getEntity()).getRuleSet();
        if (ruleSet == null) {
            return false;
        }
        ruleSet.getRules().stream().flatMap(rule -> rule.getResults().stream()).filter(rr -> AviaTripartiteContractActions.AVIA_ACCOUNTING_CODE.equals((Object)rr.getAction())).forEach(rr -> {
            String accountCode;
            List strings = RulesHelper.toStringCollection((Object)rr.getValue());
            if (CollectionUtil.isNotEmpty((Collection)strings) && ((accountCode = (String)strings.get(0)).startsWith(PREFIX_ACC) || accountCode.startsWith(PREFIX_IDT))) {
                ArrayList<String> newStrings = new ArrayList<String>();
                newStrings.add(accountCode.substring(PREFIX_LENGTH));
                rr.setValue(newStrings);
                isModified.set(true);
            }
        });
        return isModified.get();
    }
}

