/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.db.update;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UpdateHelper {
    public static <T extends BaseEntity> List<T> buildBaseEntity(URL url, Class<T> clazz) throws Exception {
        Element root = UpdateHelper.getRootElement(url);
        ArrayList<BaseEntity> locations = new ArrayList<BaseEntity>();
        for (Element objElm : XmlUtil.getElements((Element)root, (String)"object")) {
            BaseEntity dict = (BaseEntity)clazz.newInstance();
            dict.fromXML(objElm);
            locations.add(dict);
        }
        return locations;
    }

    private static Element getRootElement(URL url) throws IOException, SAXException {
        Element root;
        try (InputStream strm = IoUtil.getResourceInputStream((URL)url);){
            root = DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)strm)).getDocumentElement();
        }
        return root;
    }

    public static URL getURL(String fileName, URL baseResourceUrl) throws IOException, URISyntaxException {
        URL url = baseResourceUrl == null ? IoUtil.encodeUrl((URL)new URL(String.format("file:///%s/setup/dict/%s", Environment.getConfigurationFolder().getCanonicalPath(), fileName))) : IoUtil.file2url((File)new File(IoUtil.url2file((URL)baseResourceUrl), String.format("dict/%s", fileName)));
        return url;
    }

    public static URL getURL(String nameFile, Class<?> clazz) {
        return clazz.getResource(nameFile);
    }

    public static <T extends BaseEntity> void fillModified(EntityContainer<T> resolve, String notes) {
        resolve.getVersionInfo().setModified(new Date());
        resolve.getVersionInfo().setModifiedBy("system");
        resolve.getVersionInfo().setDataSource("setup-update");
        resolve.getVersionInfo().setVersionNotes(notes);
    }
}

