/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.db.update;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class UpdateRailwayStationLocationsHandler
implements SetupUpdateHandler {
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final Logger logger = LoggerFactory.getLogger(UpdateRailwayStationLocationsHandler.class);
    @JsonProperty(value="TransportNodes")
    private List<IMStation> stations;
    @JsonProperty(value="Cities")
    private List<IMCity> cities;
    @JsonProperty(value="Countries")
    private List<IMCountry> countries;

    public void execute(Element command) throws Exception {
        DictionaryCache dc = DictionaryCache.get();
        DictionaryStorage ds = DictionaryStorage.get();
        Map<String, IMStation> imStations = ((UpdateRailwayStationLocationsHandler)UpdateRailwayStationLocationsHandler.MAPPER.readValue((InputStream)this.getClass().getResourceAsStream((String)"TransportNodes.json"), UpdateRailwayStationLocationsHandler.class)).stations.stream().collect(Collectors.toMap(k -> k.code, k -> k));
        Map<String, IMCity> imCities = ((UpdateRailwayStationLocationsHandler)UpdateRailwayStationLocationsHandler.MAPPER.readValue((InputStream)this.getClass().getResourceAsStream((String)"Cities.json"), UpdateRailwayStationLocationsHandler.class)).cities.stream().collect(Collectors.toMap(k -> k.id, k -> k));
        Map<String, IMCountry> imCountries = ((UpdateRailwayStationLocationsHandler)UpdateRailwayStationLocationsHandler.MAPPER.readValue((InputStream)this.getClass().getResourceAsStream((String)"Countries.json"), UpdateRailwayStationLocationsHandler.class)).countries.stream().collect(Collectors.toMap(k -> k.id, k -> k));
        List cities = dc.getAll(GeoLocation.class).values().stream().filter(gl -> gl.getType() == LocationType.CITY).filter(gl -> gl.getCountry() != null).collect(Collectors.toList());
        AtomicInteger yes = new AtomicInteger(0);
        AtomicInteger code = new AtomicInteger(0);
        AtomicInteger imStation = new AtomicInteger(0);
        AtomicInteger imCity = new AtomicInteger(0);
        AtomicInteger imCountry = new AtomicInteger(0);
        AtomicInteger noCity = new AtomicInteger(0);
        AtomicInteger manyCities = new AtomicInteger(0);
        AtomicInteger all = new AtomicInteger(0);
        dc.getAll(RailwayStation.class).values().stream().filter(rs -> rs.getGeoLocation() == null).forEach(rs -> {
            all.incrementAndGet();
            if (rs.getCode() == null) {
                logger.warn("No code in dictionary for station {}", (Object)rs.toReference().getCaption());
                code.incrementAndGet();
                return;
            }
            IMStation station = (IMStation)imStations.get(rs.getCode());
            if (station == null) {
                logger.warn("No station in InMob for station {}", (Object)rs.toReference().getCaption());
                imStation.incrementAndGet();
                return;
            }
            IMCity city = (IMCity)imCities.get(station.cityId);
            if (city == null) {
                logger.warn("No city in InMob with id {} for station {}", (Object)station.cityId, (Object)rs.toReference().getCaption());
                imCity.incrementAndGet();
                return;
            }
            IMCountry country = (IMCountry)imCountries.get(city.countryId);
            if (country == null) {
                logger.warn("No country in InMob with id {} for station {}", (Object)station.countryId, (Object)rs.toReference().getCaption());
                imCountry.incrementAndGet();
                return;
            }
            List foundCities = cities.stream().filter(c -> c.getTranslations().values().stream().anyMatch(t -> t.equals(city.nameRu) || t.equals(city.nameEn)) && TextUtil.equals((String)country.code, (String)c.getCountry().getCode(), (boolean)false)).collect(Collectors.toList());
            if (foundCities.isEmpty()) {
                logger.warn("No city in dictionary with name {}/{} in country {} for station {}", new Object[]{city.nameRu, city.nameEn, country.code, rs.toReference().getCaption()});
                noCity.incrementAndGet();
                return;
            }
            if (foundCities.size() > 1) {
                logger.warn("{} cities in dictionary with name {}/{} in country {} for station {}", new Object[]{foundCities.size(), city.nameRu, city.nameEn, country.code, rs.toReference().getCaption()});
                manyCities.incrementAndGet();
                return;
            }
            rs.setGeoLocation((DictionaryReference)((GeoLocation)foundCities.get(0)).toReference());
            try {
                rs.setDataSource("UpdateRailwayStationLocationsHandler");
                ds.save((BaseDictionary)rs);
                yes.incrementAndGet();
            }
            catch (Exception e) {
                logger.error("Error occurred while trying to save {}", (Object)rs.toReference().getCaption());
            }
        });
        logger.info("{} stations updated out of {}", (Object)yes.get(), (Object)all.get());
        logger.info("{} stations not updated because of code absence", (Object)code.get());
        logger.info("{} stations not updated because of station absence in InMob", (Object)imStation.get());
        logger.info("{} stations not updated because of city absence in InMob", (Object)imCity.get());
        logger.info("{} stations not updated because of country absence in InMob", (Object)imCountry.get());
        logger.info("{} stations not updated because of city absence in dictionary", (Object)noCity.get());
        logger.info("{} stations not updated because of city ambiguity", (Object)manyCities.get());
    }

    static class IMCountry {
        @JsonProperty(value="CountryId")
        String id;
        @JsonProperty(value="Alpha2Code")
        String code;

        IMCountry() {
        }
    }

    static class IMCity {
        @JsonProperty(value="CityId")
        String id;
        @JsonProperty(value="CountryId")
        String countryId;
        @JsonProperty(value="NameRu")
        String nameRu;
        @JsonProperty(value="NameEn")
        String nameEn;

        IMCity() {
        }
    }

    static class IMStation {
        @JsonProperty(value="CountryId")
        String countryId;
        @JsonProperty(value="CityId")
        String cityId;
        @JsonProperty(value="Code")
        String code;

        IMStation() {
        }
    }
}

