/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.db.update;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class UpdateTimeZonesHandler
implements SetupUpdateHandler {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public void execute(Element command) throws Exception {
        block20: {
            this.log.debug("executing UpdateTimeZonesHandler handler");
            InputStream resource = this.getClass().getResourceAsStream("timezones");
            if (resource == null) {
                throw new Exception("No timezone resource found");
            }
            DictionaryStorage storage = DictionaryStorage.get();
            BufferedReader reader = new BufferedReader(new InputStreamReader(resource, "UTF-8"));
            Throwable throwable = null;
            block11: while (true) {
                try {
                    while (true) {
                        String line;
                        if ((line = reader.readLine()) == null) {
                            break block20;
                        }
                        if (TextUtil.isBlank((String)line)) continue;
                        try {
                            String[] table = line.split("\t");
                            String code = table[0].trim();
                            GeoLocation geoLocation = DictHelper.findCityByCode((String)code, (CodeSystem)CodeSystem.IATA);
                            if (geoLocation == null) {
                                this.log.warn("city with code " + code + " not found");
                                continue;
                            }
                            if (!TextUtil.isBlank((String)geoLocation.getTimeZoneId())) {
                                this.log.debug("timezone already present for code " + code);
                                continue;
                            }
                            geoLocation.setTimeZoneId(table[1].trim());
                            geoLocation.setDataSource("UpdateTimeZonesHandler");
                            storage.save((BaseDictionary)geoLocation);
                            this.log.warn("city with code " + code + " was updated with timezone " + geoLocation.getTimeZoneId());
                            continue block11;
                        }
                        catch (Exception e) {
                            this.log.error("unable to process line " + line);
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
    }
}

