/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.db.update;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.ValidationMessageDict;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessagesResourcesEnvironment;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class UpdateValidationMessagesHandler
implements SetupUpdateHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void execute(Element command) throws Exception {
        this.log.debug("executing UpdateValidationMessagesHandler handler");
        DictionaryStorage storage = DictionaryStorage.get();
        DictionaryCache.get().getAll(ValidationMessageDict.class).values().forEach(vmd -> {
            boolean save = false;
            ValidationMessageType type = ValidationMessagesResourcesEnvironment.getFromEnvironment().getMessageTypes().values().stream().filter(vmt -> TextUtil.isSame((String)vmt.getErrorCode(), (String)vmd.getErrorCode(), (boolean)true, (boolean)true)).findFirst().orElse(null);
            if (type == null) {
                this.log.warn("validation message type with error code " + vmd.getErrorCode() + " is not found");
                return;
            }
            if (vmd.getDefaultSeverity() == null) {
                vmd.setDefaultSeverity(type.getDefaultSeverity());
                save = true;
            }
            if (vmd.getCategory() == null) {
                vmd.setCategory(type.getCategory());
                save = true;
            }
            if (save) {
                try {
                    vmd.setDataSource("UpdateValidationMessagesHandler");
                    storage.save((BaseDictionary)vmd);
                }
                catch (Exception e) {
                    this.log.error("unable to save validation message with code " + vmd.getErrorCode());
                }
            }
        });
    }
}

