/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.db.update.ruleTransliteration;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.profile.RulesHolder;
import com.gridnine.xtrip.common.model.profile.RulesHolderIndex;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.ibecorp.db.update.UpdateHelper;
import com.gridnine.xtrip.server.update.db.BaseResourceSetupUpdateHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class RuleTransliterationMigrationHandler
extends BaseResourceSetupUpdateHandler {
    private final Logger log = LoggerFactory.getLogger(RuleTransliterationMigrationHandler.class);

    public void execute(Element elm) throws Exception {
        String fileName = XHelper.readString((Element)elm, (String)"@fileName");
        if (TextUtil.isBlank((String)fileName)) {
            this.log.error("fileName is null, entity update will be skipped");
            return;
        }
        List<RulesHolder> rulesHolderList = UpdateHelper.buildBaseEntity(UpdateHelper.getURL(fileName, ((Object)((Object)this)).getClass()), RulesHolder.class);
        EntityStorage storage = EntityStorage.get();
        SearchResult indexSearchResult = storage.search(RulesHolderIndex.class, new SearchQuery());
        if (EntityStorageHelper.nonEmpty((SearchResult)indexSearchResult)) {
            for (RulesHolder rulesHolder : rulesHolderList) {
                for (RulesHolderIndex index : indexSearchResult.getData()) {
                    EntityContainer resolve = storage.resolve(index.getSource());
                    if (!EntityStorageHelper.nonEmpty((EntityContainer)resolve)) continue;
                    ((RulesHolder)resolve.getEntity()).getRuleSet().getRules().addAll(rulesHolder.getRuleSet().getRules());
                    UpdateHelper.fillModified(resolve, "XTR-12506");
                    storage.save(resolve, true);
                }
            }
        }
    }
}

