/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.docgen;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MoneyUtil;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperReport;

public class IBEJRDoocumentRenderTest
extends ModelTestBase {
    protected URL getEntitiesSetupFile() {
        return IBEJRDoocumentRenderTest.class.getResource("entities.zip");
    }

    protected URL getDictionariesSetupFile() {
        return IBEJRDoocumentRenderTest.class.getResource("dictionaries.zip");
    }

    public void testInvoiceFactura() throws Exception {
    }

    public void testTravelReservation() throws Exception {
    }

    public void testMoney2Str() {
        Locale loc = new Locale("ru");
        IBEJRDoocumentRenderTest.write(new BigDecimal(2456.56), "UAH", loc);
        IBEJRDoocumentRenderTest.write(new BigDecimal(2456.56), "RUB", loc);
        IBEJRDoocumentRenderTest.write(new BigDecimal(1456.56), "UAH", loc);
        IBEJRDoocumentRenderTest.write(new BigDecimal(1456.56), "RUB", loc);
        IBEJRDoocumentRenderTest.write(new BigDecimal(456.56), "UAH", loc);
        IBEJRDoocumentRenderTest.write(new BigDecimal(456.56), "RUB", loc);
        IBEJRDoocumentRenderTest.write(new BigDecimal(132.56), "UAH", loc);
        IBEJRDoocumentRenderTest.write(new BigDecimal(132.56), "RUB", loc);
        IBEJRDoocumentRenderTest.write(new BigDecimal(131.01), "UAH", loc);
        IBEJRDoocumentRenderTest.write(new BigDecimal(131.01), "RUB", loc);
    }

    public void testInvoiceDate() {
        SimpleDateFormat df = new SimpleDateFormat("dd MMMMMMMM yyyy\u0433.", new Locale("ua"));
        System.out.println(df.format(new Date()));
    }

    private static void write(BigDecimal total, String cur, Locale loc) {
        String str = MoneyUtil.money2str((Locale)loc, (String)cur, (double)total.doubleValue());
        System.out.println(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getContent(String file) throws IOException {
        try (FileInputStream is = new FileInputStream(new File(file));){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IoUtil.copyStream((InputStream)is, (OutputStream)baos, (int)256);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJ() throws Exception {
        JasperReport rep = JasperUtil.getReport((byte[])IBEJRDoocumentRenderTest.getContent("InvoiceFactura.jrxml"));
        HashMap params = new HashMap();
        byte[] jprintData = JasperUtil.fillReport((JasperReport)rep, params, (JRDataSource)new JREmptyDataSource(), null);
        byte[] excelData = JasperUtil.convertToExcel((byte[])jprintData);
        File tempFolder = Environment.getTempFolder();
        if (!tempFolder.exists()) {
            tempFolder.mkdirs();
        }
        File file = new File(tempFolder, "jexcel.xls");
        try (FileOutputStream faos = new FileOutputStream(file);){
            IoUtil.copyStream((InputStream)new ByteArrayInputStream(excelData), (OutputStream)faos, (int)256);
        }
    }

    public void testVat() {
        VatAmount amount = new VatAmount();
        amount.setTotalVat(BigDecimal.valueOf(190L), 20.0);
        System.out.println("v " + amount.getValue() + " / " + amount.getVatAmount());
    }
}

