/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.docgen;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.Number2WordsConverter;
import com.gridnine.xtrip.common.l10n.model.Number2WordsConverterRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.HistoricalValueHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.PersonalNameFormat;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.FilledTemplateDocument;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;

public class InvoiceFacturaJRDocumentRender {
    private static final String KEY_AGENCY_LOGO = "AGENCY_LOGO";
    private static final String KEY_AGENCY_LOGO_WIDTH = "AGENCY_LOGO_WIDTH";
    private static final String KEY_AGENCY_LOGO_HEIGHT = "AGENCY_LOGO_HEIGHT";
    private static final String KEY_AGENCY_NAME = "AGENCY_NAME";
    private static final String KEY_AGENCY_ADDRESS = "AGENCY_ADDRESS";
    private static final String KEY_AGENCY_PHONE = "AGENCY_PHONE";
    private static final String KEY_AGENCY_BANK_SETTLEMENT_ACCOUNT = "AGENCY_BANK_SETTLEMENT_ACCOUNT";
    private static final String KEY_AGENCY_BANK = "AGENCY_BANK";
    private static final String KEY_AGENCY_BANK_CITY = "AGENCY_BANK_CITY";
    private static final String KEY_AGENCY_BANK_BIC = "AGENCY_BANK_BIC";
    private static final String KEY_AGENCY_OKPO = "AGENCY_OKPO";
    private static final String KEY_AGENCY_INN = "AGENCY_INN";
    private static final String KEY_AGENCY_TAX_LICENSE_NUMBER = "AGENCY_TAX_LICENSE_NUMBER";
    private static final String KEY_AGENCY_TAX_SYSTEM = "AGENCY_TAX_SYSTEM";
    private static final String KEY_PAYER_NAME = "PAYER_NAME";
    private static final String KEY_PAYER_PHONE = "PAYER_PHONE";
    private static final String KEY_DOCUMENT_NUMBER = "DOCUMENT_NUMBER";
    private static final String KEY_DOCUMENT_DATE = "DOCUMENT_DATE";
    private static final String KEY_TOTAL_AMOUNT = "TOTAL_AMOUNT";
    private static final String KEY_VAT_RATE = "VAT_RATE";
    private static final String KEY_TOTAL_AMOUNT_VAT = "TOTAL_AMOUNT_VAT";
    private static final String KEY_TOTAL_AMOUNT_BY_WORDS = "TOTAL_AMOUNT_BY_WORDS";
    private static final String KEY_SIGNATURE = "SIGNATURE";
    private static final String KEY_SIGNATURE_WIDTH = "SIGNATURE_WIDTH";
    private static final String KEY_SIGNATURE_HEIGHT = "SIGNATURE_HEIGHT";
    private static final String KEY_STAMP = "STAMP";
    private static final String FIELD_NAME = "NAME";
    private static final String FIELD_COUNT = "COUNT";
    private static final String FIELD_AMOUNT_NET = "AMOUNT_NET";
    private static final String FIELD_AMOUNT_VAT = "AMOUNT_VAT";
    private static final String FIELD_AMOUNT = "AMOUNT";

    public DocumentData renderReport(EntityContainer<BookingFile> bookingFileContainer, Reservation reservation, EntityContainer<TemplateDocument> templateContainer, Locale locale) throws Exception {
        LinkedHashSet<Message> messages = new LinkedHashSet<Message>();
        TemplateDocument templateDocument = (TemplateDocument)templateContainer.getEntity();
        if (templateDocument.getContent() == null) {
            throw Xeption.forAdmin((String)"\u0423 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 {0} \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043e \u043f\u043e\u043b\u0435 '\u0448\u0430\u0431\u043b\u043e\u043d'", (Object[])new Object[]{templateDocument.getTitle()});
        }
        JasperReport jasperReport = JasperUtil.getReport((byte[])templateDocument.getContent());
        Map<String, Object> parameters = this.getParameters(bookingFileContainer, reservation, locale, messages);
        if (parameters == null) {
            throw new Exception("unable to create parameters");
        }
        JRDataSource dataSource = this.getDataSource(bookingFileContainer, reservation, jasperReport, locale, messages);
        if (dataSource == null) {
            throw new Exception("unable to create data source");
        }
        byte[] content = JasperUtil.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)dataSource, null);
        if (content == null) {
            throw new Exception("unable to fill document");
        }
        if ((content = JasperUtil.convertToPdf((byte[])content)) == null) {
            throw new Exception("unable to convertGeoLocationReference2Rest document to pdf");
        }
        String number = (String)parameters.get(KEY_DOCUMENT_NUMBER);
        Date date = (Date)parameters.get(KEY_DOCUMENT_DATE);
        FilledTemplateDocument filledTemplateDocument = new FilledTemplateDocument();
        filledTemplateDocument.setTitle(String.format("\u0421\u0447\u0435\u0442-\u0444\u0430\u043a\u0442\u0443\u0440\u0430 %s", number));
        filledTemplateDocument.setName("invoice-factura.pdf");
        filledTemplateDocument.setType(DocumentType.INVOICE);
        filledTemplateDocument.setContentType(ContentType.PDF);
        filledTemplateDocument.setContent(content);
        filledTemplateDocument.setCreated(new Date());
        filledTemplateDocument.setNavigationKey(bookingFileContainer.getUid());
        filledTemplateDocument.setOwner(bookingFileContainer.toReference());
        filledTemplateDocument.setCheckSum(MiscUtil.getCheckSum((byte[])filledTemplateDocument.getContent()));
        filledTemplateDocument.setTemplate(templateContainer.toReference());
        filledTemplateDocument.getMessages().addAll(messages);
        String recordLocator = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation);
        return new DocumentData(number, date, recordLocator, filledTemplateDocument);
    }

    protected Map<String, Object> getParameters(EntityContainer<BookingFile> bookingFileContainer, Reservation reservation, Locale locale, Set<Message> messages) {
        BankAccount bankAccount;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        EntityContainer agencyContainer = EntityStorage.get().resolve(bookingFile.getAgency());
        if (agencyContainer == null) {
            this.addMessage(messages, "\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430", null, MessageType.ERROR, new Object[0]);
            return null;
        }
        Organization agency = (Organization)agencyContainer.getEntity();
        Customer customer = bookingFile.getCustomer();
        if (customer == null) {
            this.addMessage(messages, "\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044f", null, MessageType.ERROR, new Object[0]);
            return null;
        }
        Date date = new Date();
        parameters.put("REPORT_LOCALE", locale);
        ImageData agencyLogoImageData = new ImageData(agency.getLogo());
        parameters.put(KEY_AGENCY_LOGO, agencyLogoImageData.getData());
        parameters.put(KEY_AGENCY_LOGO_WIDTH, agencyLogoImageData.getWidth());
        parameters.put(KEY_AGENCY_LOGO_HEIGHT, agencyLogoImageData.getHeight());
        parameters.put(KEY_AGENCY_NAME, L10nStringHelper.getValue((L10nString)agency.getFullName(), (Locale)locale, (boolean)false));
        parameters.put(KEY_AGENCY_ADDRESS, this.buildAddressString(ProfileHelper.getOrganizationAddresses((Organization)agency, (Date)date), Arrays.asList(AddressType.FACTUAL), locale));
        parameters.put(KEY_AGENCY_PHONE, this.buildPhoneString(agency.getCommunications(), Arrays.asList(CommunicationType.WORK_PHONE), locale));
        BankAccount bankAccount2 = bankAccount = agency.getBankAccounts().size() > 0 ? (BankAccount)agency.getBankAccounts().get(0) : null;
        if (bankAccount != null) {
            parameters.put(KEY_AGENCY_BANK_SETTLEMENT_ACCOUNT, bankAccount.getSettlementAccount());
            parameters.put(KEY_AGENCY_BANK, bankAccount.getBankName());
            if (bankAccount.getCity() != null) {
                parameters.put(KEY_AGENCY_BANK_CITY, bankAccount.getCity().toString(locale));
            }
            parameters.put(KEY_AGENCY_BANK_BIC, bankAccount.getBik());
        }
        parameters.put(KEY_AGENCY_OKPO, agency.getOkpoCode());
        parameters.put(KEY_AGENCY_INN, agency.getRegistrationId());
        parameters.put(KEY_AGENCY_TAX_LICENSE_NUMBER, HistoricalValueHelper.getValue((List)agency.getVatLicenseNumberHistory(), (Date)date));
        parameters.put(KEY_AGENCY_TAX_SYSTEM, agency.getTaxSystem());
        parameters.put(KEY_PAYER_NAME, this.buildNameString((PersonalName)customer.getPassport(), "L F M", locale));
        parameters.put(KEY_PAYER_PHONE, this.buildPhoneString(customer.getCommunications(), Arrays.asList(CommunicationType.MOBILE, CommunicationType.HOME_PHONE), locale));
        parameters.put(KEY_DOCUMENT_NUMBER, this.buildDocumentNumberString(reservation, date, locale));
        parameters.put(KEY_DOCUMENT_DATE, date);
        BigDecimal vatRate = DictHelper.getDefaultVat((Date)new Date());
        BigDecimal totalAmount = this.calculateTotalAmount(reservation);
        BigDecimal totalAmountVat = this.calculateTotalAmountVat(reservation);
        parameters.put(KEY_TOTAL_AMOUNT, totalAmount);
        parameters.put(KEY_VAT_RATE, vatRate);
        parameters.put(KEY_TOTAL_AMOUNT_VAT, totalAmountVat);
        if (totalAmount != null) {
            parameters.put(KEY_TOTAL_AMOUNT_BY_WORDS, this.buildAmountByWordsString(totalAmount, locale, "UAH"));
        }
        ImageData signatureImageData = new ImageData(agency.getSignature());
        parameters.put(KEY_SIGNATURE, signatureImageData.getData());
        parameters.put(KEY_SIGNATURE_WIDTH, signatureImageData.getWidth());
        parameters.put(KEY_SIGNATURE_HEIGHT, signatureImageData.getHeight());
        if (agency.getStamp() != null && agency.getStamp().getData() != null) {
            parameters.put(KEY_STAMP, new ByteArrayInputStream(agency.getStamp().getData()));
        }
        return parameters;
    }

    private String buildAddressString(List<Address> addresses, List<AddressType> addressTypes, Locale locale) {
        for (AddressType addressType : addressTypes) {
            for (Address address : ProfileHelper.filterAddresses(addresses, Collections.singleton(addressType))) {
                String addressString = ProfileHelper.buildFullAddress((Address)address, (Locale)locale, (boolean)false);
                if (TextUtil.isBlank((String)addressString)) continue;
                return addressString;
            }
        }
        return null;
    }

    private String buildPhoneString(List<Communication> communications, List<CommunicationType> communicationTypes, Locale locale) {
        for (CommunicationType communicationType : communicationTypes) {
            for (Communication communication : ProfileHelper.filterCommunications(communications, Collections.singleton(communicationType))) {
                String phoneString = ProfileHelper.buildFullPhoneNumber((Communication)communication);
                if (TextUtil.isBlank((String)phoneString)) continue;
                return phoneString.trim();
            }
        }
        return null;
    }

    private String buildNameString(PersonalName personalName, String pattern, Locale locale) {
        if (personalName == null) {
            return null;
        }
        PersonalNameFormat format = new PersonalNameFormat(pattern);
        return format.format(personalName);
    }

    private String buildDocumentNumberString(Reservation reservation, Date date, Locale locale) {
        StringBuilder documentNumberString = new StringBuilder();
        String recordLocator = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation);
        if (TextUtil.nonBlank((String)recordLocator)) {
            documentNumberString.append(recordLocator);
        }
        if (date != null) {
            SimpleDateFormat format = new SimpleDateFormat("ddMMyyyyHHmmss");
            documentNumberString.append(format.format(date));
        }
        return documentNumberString.toString();
    }

    private String buildAmountByWordsString(BigDecimal amount, Locale locale, String currency) {
        Number2WordsConverter converter = ((Number2WordsConverterRegistry)Environment.getPublished(Number2WordsConverterRegistry.class)).findConverter(locale, currency);
        if (converter != null) {
            try {
                return converter.toCurrencyWords(amount, currency, true, false, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private BigDecimal calculateTotalAmount(Reservation reservation) {
        BigDecimal totalAmount = null;
        for (BaseProduct baseProduct : reservation.getProducts()) {
            BigDecimal commissionsEquivalentValue;
            if (!(baseProduct instanceof Product)) continue;
            Product product = (Product)baseProduct;
            BigDecimal totalEquivalentFare = AirProductHelper.calculateTotalEquivalentFare((Product)product);
            if (totalEquivalentFare != null) {
                BigDecimal bigDecimal = totalAmount = totalAmount != null ? totalAmount.add(totalEquivalentFare) : totalEquivalentFare;
            }
            if ((commissionsEquivalentValue = AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null))) == null) continue;
            totalAmount = totalAmount != null ? totalAmount.add(commissionsEquivalentValue) : commissionsEquivalentValue;
        }
        return totalAmount;
    }

    private BigDecimal calculateTotalAmountVat(Reservation reservation) {
        BigDecimal totalAmountVat = null;
        for (BaseProduct baseProduct : reservation.getProducts()) {
            BigDecimal commissionsEquivalentValue;
            if (!(baseProduct instanceof Product)) continue;
            Product product = (Product)baseProduct;
            BigDecimal defaultVat = DictHelper.getDefaultVat();
            if (defaultVat == null || (commissionsEquivalentValue = AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null))) == null) continue;
            VatAmount vatAmount = new VatAmount();
            vatAmount.setTotalVat(commissionsEquivalentValue, defaultVat.doubleValue());
            totalAmountVat = totalAmountVat != null ? totalAmountVat.add(vatAmount.getVatAmount()) : vatAmount.getVatAmount();
        }
        return totalAmountVat;
    }

    protected JRDataSource getDataSource(EntityContainer<BookingFile> bookingFileContainer, Reservation reservation, JasperReport jasperReport, Locale locale, Set<Message> messages) {
        LinkedList data = new LinkedList();
        ArrayList productData = new ArrayList();
        ArrayList feeData = new ArrayList();
        for (BaseProduct baseProduct : reservation.getProducts()) {
            if (!(baseProduct instanceof Product)) continue;
            Product product = (Product)baseProduct;
            this.addProductData(productData, product, locale, messages);
            this.addServiceFeeData(feeData, product, locale, messages);
            this.addPaymentFeeData(feeData, product, locale, messages);
        }
        data.addAll(productData);
        data.addAll(feeData);
        return new JRMapCollectionDataSource(data);
    }

    private void addProductData(List<Map<String, ?>> data, Product product, Locale locale, Set<Message> messages) {
        BigDecimal totalEquivalentAmount;
        String traveller;
        SimpleDateFormat format;
        StringBuilder name = new StringBuilder();
        name.append(this.getLocalizedString("InvoiceFactura_Ticket", new Object[0]));
        String route = AirProductHelper.getRouteLine((Product)product, (Locale)Locale.ENGLISH, (boolean)false, null);
        if (!TextUtil.isBlank((String)route)) {
            name.append(" ");
            name.append(this.getLocalizedString("InvoiceFactura_Route", route.trim()));
        }
        Date firstDepartureDate = AirProductHelper.getFirstDepartureDate((Product)product);
        Date lastArriveDate = AirProductHelper.getLastArriveDate((Product)product);
        if (firstDepartureDate != null && lastArriveDate != null) {
            format = new SimpleDateFormat("dd/MM/yy");
            name.append(", ");
            name.append(String.format("%s-%s", format.format(firstDepartureDate), format.format(lastArriveDate)));
        }
        if (product.getTraveller() != null && product.getTraveller().getPassport() != null && !TextUtil.isBlank((String)(traveller = (format = new PersonalNameFormat("L F")).format((PersonalName)product.getTraveller().getPassport())))) {
            name.append(", ");
            name.append(this.getLocalizedString("InvoiceFactura_Passenger", traveller.trim()));
        }
        BigDecimal totalEquivalentNetAmount = totalEquivalentAmount = AirProductHelper.calculateTotalEquivalentFare((Product)product);
        HashMap<String, Object> record = new HashMap<String, Object>();
        record.put(FIELD_NAME, name.length() > 0 ? name.toString() : null);
        record.put(FIELD_COUNT, 1);
        record.put(FIELD_AMOUNT_NET, totalEquivalentNetAmount);
        record.put(FIELD_AMOUNT_VAT, null);
        record.put(FIELD_AMOUNT, totalEquivalentAmount);
        data.add(record);
    }

    private void addServiceFeeData(List<Map<String, ?>> data, Product product, Locale locale, Set<Message> messages) {
        PersonalNameFormat format;
        String traveller;
        Collection commissions = GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.serviceFeePropertyTypes, null, null);
        if (commissions.isEmpty()) {
            return;
        }
        StringBuilder name = new StringBuilder();
        name.append(this.getLocalizedString("InvoiceFactura_ServiceFee", new Object[0]));
        if (product.getTraveller() != null && product.getTraveller().getPassport() != null && !TextUtil.isBlank((String)(traveller = (format = new PersonalNameFormat("L F")).format((PersonalName)product.getTraveller().getPassport())))) {
            name.append(", ");
            name.append(this.getLocalizedString("InvoiceFactura_Passenger", traveller.trim()));
        }
        BigDecimal commissionsEquivalentAmount = AirProductHelper.calculateCommissionsEquivalentValue((Collection)commissions);
        BigDecimal commissionsEquivalentVatAmount = null;
        BigDecimal commissionsEquivalentNetAmount = null;
        BigDecimal defaultVat = DictHelper.getDefaultVat((BaseProduct)product);
        if (defaultVat != null) {
            VatAmount vatAmount = new VatAmount();
            vatAmount.setTotalVat(commissionsEquivalentAmount, defaultVat.doubleValue());
            commissionsEquivalentVatAmount = vatAmount.getVatAmount();
            commissionsEquivalentNetAmount = vatAmount.getValue();
        } else {
            commissionsEquivalentNetAmount = commissionsEquivalentAmount;
        }
        HashMap<String, Object> record = new HashMap<String, Object>();
        record.put(FIELD_NAME, name.length() > 0 ? name.toString() : null);
        record.put(FIELD_COUNT, 1);
        record.put(FIELD_AMOUNT_NET, commissionsEquivalentNetAmount);
        record.put(FIELD_AMOUNT_VAT, commissionsEquivalentVatAmount);
        record.put(FIELD_AMOUNT, commissionsEquivalentAmount);
        data.add(record);
    }

    private void addPaymentFeeData(List<Map<String, ?>> data, Product product, Locale locale, Set<Message> messages) {
        PersonalNameFormat format;
        String traveller;
        Collection commissions = GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.paymentFeePropertyTypes, null, null);
        if (commissions.isEmpty()) {
            return;
        }
        StringBuilder name = new StringBuilder();
        name.append(this.getLocalizedString("InvoiceFactura_PaidServiceFee", new Object[0]));
        if (product.getTraveller() != null && product.getTraveller().getPassport() != null && !TextUtil.isBlank((String)(traveller = (format = new PersonalNameFormat("L F")).format((PersonalName)product.getTraveller().getPassport())))) {
            name.append(", ");
            name.append(this.getLocalizedString("InvoiceFactura_Passenger", traveller.trim()));
        }
        BigDecimal commissionsEquivalentAmount = AirProductHelper.calculateCommissionsEquivalentValue((Collection)commissions);
        BigDecimal commissionsEquivalentVatAmount = null;
        BigDecimal commissionsEquivalentNetAmount = null;
        BigDecimal defaultVat = DictHelper.getDefaultVat((BaseProduct)product);
        if (defaultVat != null) {
            VatAmount vatAmount = new VatAmount();
            vatAmount.setTotalVat(commissionsEquivalentAmount, defaultVat.doubleValue());
            commissionsEquivalentVatAmount = vatAmount.getVatAmount();
            commissionsEquivalentNetAmount = vatAmount.getValue();
        } else {
            commissionsEquivalentNetAmount = commissionsEquivalentAmount;
        }
        HashMap<String, Object> record = new HashMap<String, Object>();
        record.put(FIELD_NAME, name.length() > 0 ? name.toString() : null);
        record.put(FIELD_COUNT, 1);
        record.put(FIELD_AMOUNT_NET, commissionsEquivalentNetAmount);
        record.put(FIELD_AMOUNT_VAT, commissionsEquivalentVatAmount);
        record.put(FIELD_AMOUNT, commissionsEquivalentAmount);
        data.add(record);
    }

    private String getLocalizedString(String key, Object ... parameters) {
        return L10nResourcesManager.createL10nMessage((String)key, (Object[])parameters).toString();
    }

    private void addMessage(Set<Message> messages, String text, String details, MessageType type, Object ... parameters) {
        Message message = new Message();
        message.setType(type);
        message.setMessage(L10nResourcesManager.createL10nMessage((String)text, (Object[])parameters));
        message.setDetails(details);
        if (!messages.contains(message)) {
            messages.add(message);
        }
    }

    public static class DocumentData {
        private final String number;
        private final Date date;
        private final String recordLocator;
        private final FilledTemplateDocument document;

        public DocumentData(String number, Date date, String recordLocator, FilledTemplateDocument document) {
            this.number = number;
            this.date = date;
            this.recordLocator = recordLocator;
            this.document = document;
        }

        public String getNumber() {
            return this.number;
        }

        public Date getDate() {
            return this.date;
        }

        public String getRecordLocator() {
            return this.recordLocator;
        }

        public FilledTemplateDocument getDocument() {
            return this.document;
        }
    }

    private static class ImageData {
        private final InputStream data;
        private final int width;
        private final int height;

        public ImageData(BinaryData data) {
            ByteArrayInputStream is = null;
            BufferedImage image = null;
            if (data != null && data.getData() != null) {
                is = new ByteArrayInputStream(data.getData());
                try {
                    image = ImageIO.read(is);
                    ((InputStream)is).reset();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.data = is;
            this.width = image != null ? image.getWidth() : 0;
            this.height = image != null ? image.getHeight() : 0;
        }

        public InputStream getData() {
            return this.data;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

