/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.docgen;

import com.gridnine.xtrip.common.ibecorp.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.BaseSMProfile;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMNotificationsSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMProfileType;
import com.gridnine.xtrip.common.model.system.ConsecutiveNumberCategory;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.cn.ConsecutiveNumberHelper;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class ServiceFeeReceiptGenerator {
    private static final String SFRNumber = "${sfrNumber}";

    public static void generate(EntityContainer<BookingFile> bookingFileContainer, String number) throws Exception {
        String documentNumber = !TextUtil.isBlank((String)number) ? number : String.format("%07d", ConsecutiveNumberHelper.incrementAndGetNumber((ConsecutiveNumberHelper.ConsecutiveNumberHandler)ConsecutiveNumberHelper.ConsecutiveNumberHandler.ofAgency((ConsecutiveNumberCategory)ConsecutiveNumberCategory.RECEIPT_SERVICE_FEE, (EntityReference)((BookingFile)bookingFileContainer.getEntity()).getAgency())));
        byte[] content = ServiceFeeReceiptGenerator.generateContext((BookingFile)bookingFileContainer.getEntity(), documentNumber).getBytes(StandardCharsets.UTF_8);
        EntityContainer documentContainer = new EntityContainer(Document.class);
        ((Document)documentContainer.getEntity()).setTitle("\u041a\u0432\u0438\u0442\u0430\u043d\u0446\u0438\u044f \u0441\u0435\u0440\u0432\u0438\u0441\u043d\u043e\u0433\u043e \u0441\u0431\u043e\u0440\u0430 - " + documentNumber);
        ((Document)documentContainer.getEntity()).setName(String.format("%s.html", documentNumber));
        ((Document)documentContainer.getEntity()).setOwner(bookingFileContainer.toReference());
        ((Document)documentContainer.getEntity()).setNavigationKey(bookingFileContainer.getUid());
        ((Document)documentContainer.getEntity()).setCreated(new Date());
        ((Document)documentContainer.getEntity()).setContentType(ContentType.HTML);
        ((Document)documentContainer.getEntity()).setContent(content);
        ((Document)documentContainer.getEntity()).setType(DocumentType.SERVICEFEERECEIPT);
        ((Document)documentContainer.getEntity()).setCheckSum(MiscUtil.getCheckSum((byte[])content));
        LogicalStorage.get().getEntityStorage().save(documentContainer, true);
    }

    public static String generateContext(BookingFile bookingFile, String docNumber) throws Exception {
        SMNotificationsSettings settings = Optional.ofNullable(EntityStorage.get().resolve(ProfileHelper.getProfile((EntityReference)bookingFile.getSite(), (SMProfileType)SMProfileType.NOTIFICATIONS_SETTINGS))).map(item -> (BaseSMProfile)item.getEntity()).orElse(null);
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
        StringBuilder buf = new StringBuilder();
        boolean isVatInline = settings != null ? settings.isServiceFreeReceiptVatInline() : false;
        buf.append("<table align='left' border='0'>");
        buf.append("<tr>");
        buf.append("<td>");
        String header = settings != null && settings.getServiceFeeReceiptNotification() != null ? settings.getServiceFeeReceiptNotification().getDataRu() : "";
        StringBuilder sb = new StringBuilder(256);
        sb.append("\u2116 ").append(docNumber).append(" \u043e\u0442 ");
        sb.append(sdf.format(new Date()));
        buf.append(header.replace(SFRNumber, sb.toString()));
        buf.append("</td>");
        buf.append("</tr>");
        buf.append("<tr>");
        buf.append("<td>");
        buf.append("<table border='1'>");
        buf.append("<tr>");
        buf.append("<th width='200px'>\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0443\u0441\u043b\u0443\u0433\u0438</th>");
        buf.append("<th width='200px'>\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0443\u0441\u043b\u0443\u0433\u0438</th>");
        if (isVatInline) {
            buf.append("<th width='200px'>\u0412 \u0442.\u0447. \u041d\u0414\u0421</th>");
        }
        buf.append("</tr>");
        Reservation baseProductReservation = BookingHelper.getBaseProductReservation((BookingFile)bookingFile);
        for (BaseProduct product : baseProductReservation.getProducts()) {
            if (!(product instanceof Product)) continue;
            Product prod = (Product)product;
            buf.append("<tr align='center'>");
            VatAmount fee = new VatAmount();
            fee.setTotalVat(BookingHelper.calculateFee((BaseProduct)prod, (ContractType)ContractType.CLIENT), 18.0);
            buf.append("<td>\u0421\u0435\u0440\u0432\u0438\u0441\u043d\u044b\u0439 \u0441\u0431\u043e\u0440 \u043a \u0430\u0432\u0438\u0430\u0431\u0438\u043b\u0435\u0442\u0443 \u2116 ").append(prod.getCarrierNumber()).append(' ').append(prod.getSystemNumber()).append("</td>");
            buf.append("<td>").append(NumberFormat.getInstance().format(fee.getTotal())).append("</td>");
            if (isVatInline) {
                buf.append("<td>").append(NumberFormat.getInstance().format(fee.getVatAmount())).append("</td>");
            }
            buf.append("</tr>");
        }
        List reservations = bookingFile.getReservations();
        for (Reservation reservation : reservations) {
            List products = reservation.getProducts();
            for (BaseProduct baseProduct : products) {
                InsuranceAccident insurance;
                BigDecimal feePrice;
                if (!(baseProduct instanceof InsuranceAccident) || (feePrice = BookingHelper.calculateFee((BaseProduct)(insurance = (InsuranceAccident)baseProduct), (ContractType)ContractType.CLIENT)) == null || BigDecimal.ZERO.compareTo(feePrice) == 0) continue;
                VatAmount fee = new VatAmount();
                fee.setTotalVat(feePrice, 18.0);
                buf.append("<tr align='center'>");
                buf.append("<td>\u0421\u0435\u0440\u0432\u0438\u0441\u043d\u044b\u0439 \u0441\u0431\u043e\u0440 \u043a \u0441\u0442\u0440\u0430\u0445\u043e\u0432\u043a\u0435 \u2116 ").append(insurance.getSystemNumber()).append("</td>");
                buf.append("<td>").append(NumberFormat.getInstance().format(fee.getTotal())).append("</td>");
                if (isVatInline) {
                    buf.append("<td>").append(NumberFormat.getInstance().format(fee.getVatAmount())).append("</td>");
                }
                buf.append("</tr>");
            }
        }
        buf.append("</table>");
        buf.append("</td>");
        buf.append("</tr>");
        buf.append("</table>");
        return buf.toString();
    }
}

