/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.docgen;

import com.gridnine.bof.midoffice.helper.PDFContent;
import com.gridnine.bof.midoffice.helper.PDFContentPart;
import com.gridnine.bof.midoffice.helper.PDFImage;
import com.gridnine.bof.midoffice.helper.PDFUtil;
import com.gridnine.bof.midoffice.helper.Position;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationRemark;
import com.gridnine.xtrip.common.model.booking.air.LuggageInfo;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.docgen.DocGenHelper;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.LoggerFactory;

public final class TravelDocGenerator {
    private static final PDFImage IMAGE;
    public static final Locale RUSSIAN;
    static CodeTranslator translator;
    private static final HashMap<Locale, List<String>> childGenderTitles;
    private static final HashMap<Locale, List<String>> adultGenderTitles;

    private static PDFImage createImage(BinaryData data) {
        if (data == null || data.getData() == null || data.getData().length == 0) {
            return null;
        }
        PDFImage result = new PDFImage();
        result.setPosition(Position.TOP_RIGHT);
        result.setWidth(80.0f);
        result.setHeight(43.81f);
        result.setMarginX(35.0f);
        result.setMarginY(25.0f);
        result.setData(data.getData());
        return result;
    }

    private static String findReservationRemark(Reservation reservation, String qualifiler) {
        for (ReservationRemark remark : reservation.getReservationRemarks()) {
            if (TextUtil.isBlank((String)remark.getQualifier()) || !remark.getQualifier().equals(qualifiler)) continue;
            return remark.getRemarkText();
        }
        return "";
    }

    public static byte[] generate(Product product, Locale loc) throws Exception {
        PDFContent[] parts = new PDFContent[5];
        parts[0] = TravelDocGenerator.createPDFContentPart(TravelDocGenerator.generateContent(product, loc), 9.5f, 1.25f);
        StringBuilder buf = new StringBuilder();
        buf.append("\r\n");
        buf.append(TravelDocGenerator.findReservationRemark(product.getReservation(), "TRAVELDOC_NOTICE_RU"));
        buf.append("\r\n");
        buf.append(TravelDocGenerator.findReservationRemark(product.getReservation(), "TRAVELDOC_NOTICE_EN"));
        buf.append("\r\n");
        parts[1] = TravelDocGenerator.createPDFContentPart(buf.toString(), 6.5f, 0.2f);
        parts[2] = TravelDocGenerator.createPDFContentPart(TravelDocGenerator.generatePassengerInfoContent(product, loc), 6.5f, 0.2f);
        parts[3] = TravelDocGenerator.createPDFContentPart("                                                              \u0421\u0422\u0420./PAGE 1/1", ((PDFContentPart)parts[0]).getFontSize(), ((PDFContentPart)parts[0]).getCharacterSpacing());
        EntityContainer subAgencyCtr = ((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(AirProductHelper.getSubagency((Product)product));
        PDFImage pDFImage = parts[4] = subAgencyCtr == null ? null : TravelDocGenerator.createImage(((Organization)subAgencyCtr.getEntity()).getLogo());
        if (parts[4] == null) {
            parts[4] = IMAGE;
        }
        return PDFUtil.wrapAsPDF((String)"", (PDFContent[])parts);
    }

    private static PDFContentPart createPDFContentPart(String text, float fontSize, float characterSpacing) {
        PDFContentPart result = new PDFContentPart();
        result.setText(text);
        result.setFontSize(fontSize);
        result.setCharacterSpacing(characterSpacing);
        return result;
    }

    private static BinaryData convertByteArray2BinaryData(byte[] image) {
        BinaryData data = new BinaryData();
        data.setContentType(ContentType.JPEG);
        data.setData(image);
        return data;
    }

    private static <D extends BaseDictionary> String extractCode(DictionaryReference<D> ref, String systemCode) {
        if (ref == null) {
            return null;
        }
        BaseDictionary loc = ((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(ref);
        if (loc == null) {
            return ref.getCode();
        }
        String result = (String)loc.getCodeVariants().get(systemCode);
        if (result != null) {
            return result;
        }
        return loc.getCode();
    }

    private static String extractAirline(String code, String systemCode) {
        Airline dict = (Airline)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).getAll(Airline.class).get(code);
        if (dict == null) {
            return code;
        }
        String result = (String)dict.getCodeVariants().get(systemCode);
        if (result != null) {
            return result;
        }
        return code;
    }

    private static String extractCurrency(String code, Locale loc) {
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        LocaleManager localeMgr = (LocaleManager)Environment.getPublished(LocaleManager.class);
        Locale currLocale = localeMgr.getCurrentLocale();
        localeMgr.setCurrentLocale(loc);
        String curr = ((CurrencyInfo)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).getAll(CurrencyInfo.class).get(code)).toString();
        localeMgr.setCurrentLocale(currLocale);
        return curr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <D extends BaseDictionary> String extractDict(DictionaryReference<D> ref, Locale loc) {
        if (ref == null) {
            return null;
        }
        LocaleManager localeMgr = (LocaleManager)Environment.getPublished(LocaleManager.class);
        Locale currLocale = localeMgr.getCurrentLocale();
        try {
            localeMgr.setCurrentLocale(loc);
            BaseDictionary dict = ((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(ref);
            if (dict == null) {
                String string = null;
                return string;
            }
            String string = dict.toString();
            return string;
        }
        finally {
            localeMgr.setCurrentLocale(currLocale);
        }
    }

    public static String generateContent(Product prod, Locale loc) throws Exception {
        Passport passport;
        StringBuilder buf = new StringBuilder();
        DocGenHelper.println(buf, 13, "\u042d\u041b\u0415\u041a\u0422\u0420\u041e\u041d\u041d\u042b\u0419 \u0411\u0418\u041b\u0415\u0422 (\u041c\u0410\u0420\u0428\u0420\u0423\u0422/\u041a\u0412\u0418\u0422\u0410\u041d\u0426\u0418\u042f) \u041d\u0421\u0410\u0412-\u0422\u041a\u041f");
        DocGenHelper.println(buf, 13, "ELECTRONIC TICKET (ITINERARY/RECEIPT) CCS/TCH");
        DocGenHelper.println(buf, 0, "");
        SimpleDateFormat df = new SimpleDateFormat("ddMMMyy", loc);
        Organization agency = (Organization)EntityStorage.get().resolve(prod.getReservation().getBookingFile().getAgency()).getEntity();
        StringBuilder sb = new StringBuilder(256);
        String locSuffix = loc.getLanguage().toUpperCase();
        sb.append(TravelDocGenerator.findReservationRemark(prod.getReservation(), "TRAVELDOC_AGENCY_VALIDATOR_" + locSuffix));
        DocGenHelper.print(buf, 0, sb.toString(), 20);
        DocGenHelper.println(buf, 12, "\u0414\u0410\u0422\u0410/DATE: " + df.format(prod.getIssueDate() == null ? new Date() : prod.getIssueDate()));
        sb.setLength(0);
        sb.append(TravelDocGenerator.findReservationRemark(prod.getReservation(), "TRAVELDOC_AGENCY_NAME_" + locSuffix));
        DocGenHelper.print(buf, 0, sb.toString(), 20);
        String docOfPassenger = null;
        sb.setLength(0);
        sb.append("\u0424\u0410\u041c\u0418\u041b\u0418\u042f/NAME: ");
        String genderTitle = "";
        Passport passport2 = passport = prod.getTraveller() == null ? null : prod.getTraveller().getPassport();
        if (passport != null) {
            PassengerTypeValue ptv = DictHelper.getPassengerTypeValue((DictionaryReference)prod.getPassengerType());
            switch (ptv) {
                case CHILD: 
                case INFANT: {
                    if (passport.getGender() == Gender.FEMALE) {
                        genderTitle = childGenderTitles.get(loc).get(0);
                        break;
                    }
                    genderTitle = childGenderTitles.get(loc).get(1);
                    break;
                }
                default: {
                    genderTitle = passport.getGender() == Gender.FEMALE ? adultGenderTitles.get(loc).get(0) : adultGenderTitles.get(loc).get(1);
                }
            }
            docOfPassenger = loc.equals(Locale.ENGLISH) ? TravelDocGenerator.getPassportCodeEn(passport.getType()) : TravelDocGenerator.getPassportCodeRu(passport.getType());
            docOfPassenger = TextUtil.isBlank((String)docOfPassenger) ? "" : docOfPassenger + passport.getNumber();
        }
        sb.append(TravelDocGenerator.buildName(passport, 30 - genderTitle.length())).append(' ').append(genderTitle);
        DocGenHelper.println(buf, 9, sb.toString());
        List addresses = ProfileHelper.getOrganizationAddresses((Organization)agency, (Date)prod.getIssueDate());
        if (!addresses.isEmpty()) {
            sb.setLength(0);
            sb.append(TravelDocGenerator.extractCode(((Address)addresses.get(0)).getCity(), loc.equals(Locale.ENGLISH) ? "IATA" : "CRT"));
            sb.append(' ');
            sb.append(TravelDocGenerator.extractCode(((Address)addresses.get(0)).getCountry(), loc.equals(Locale.ENGLISH) ? "IATA" : "CRT"));
            DocGenHelper.print(buf, 0, sb.toString(), 20);
        }
        sb.setLength(0);
        sb.append(TextUtil.isBlank((String)docOfPassenger) ? "" : docOfPassenger);
        DocGenHelper.println(buf, 23, sb.toString());
        sb.setLength(0);
        String number = TravelDocGenerator.findReservationRemark(prod.getReservation(), "TRAVELDOC_AGENCY_NUMBER_" + locSuffix);
        if (TextUtil.isBlank((String)number)) {
            sb.append(prod.getValidatorCode()).append(' ').append(prod.getCashierCode());
        } else {
            sb.append(number);
        }
        DocGenHelper.print(buf, 0, sb.toString(), 20);
        sb.setLength(0);
        sb.append("\u041e\u0422\u041f\u0420\u0412/\u041d\u0410\u0417\u041d/ORIG/DESTN: ");
        DictionaryReference startPoint = null;
        DictionaryReference endPoint = null;
        for (SegmentTariff st : prod.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                if (startPoint == null) {
                    startPoint = seg.getDepartureLocation();
                }
                endPoint = seg.getArriveLocation();
            }
        }
        sb.append(loc.equals(Locale.ENGLISH) ? translator.getNativeCode(startPoint) : TravelDocGenerator.extractCode(startPoint, "CRT"));
        sb.append(loc.equals(Locale.ENGLISH) ? translator.getNativeCode(endPoint) : TravelDocGenerator.extractCode(endPoint, "CRT"));
        DocGenHelper.println(buf, 0, sb.toString());
        DocGenHelper.println(buf, 0, "");
        sb.setLength(0);
        sb.append("\u0412\u042b\u0414\u0410\u041d \u041e\u0422/ISSUED BY          : ");
        sb.append(TravelDocGenerator.getName(prod.getCarrier(), loc));
        DocGenHelper.println(buf, 0, sb.toString());
        sb.setLength(0);
        sb.append("\u041d\u041e\u041c\u0415\u0420 \u0411\u0418\u041b\u0415\u0422\u0410/TICKET NUMBER  : ");
        String prodNumber = TravelDocGenerator.findReservationRemark(prod.getReservation(), "TRAVELDOC_PROD_" + prod.getSystemNumber() + "_" + locSuffix);
        if (TextUtil.isBlank((String)prodNumber)) {
            sb.append(prod.getCarrierNumber()).append(' ');
            sb.append(prod.getSystemNumber());
        } else {
            sb.append(prodNumber);
        }
        DocGenHelper.println(buf, 0, sb.toString());
        sb.setLength(0);
        sb.append("\u0414\u0410\u041d\u041d\u042b\u0415 \u0411\u0420\u041e\u041d/BOOKING REF     : ");
        sb.append(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)prod.getReservation()));
        sb.append('/');
        sb.append(TravelDocGenerator.getGDSCode(CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)prod.getReservation())));
        sb.append(' ');
        if (!TextUtil.isBlank((String)((Segment)((SegmentTariff)prod.getSegmentTariffs().get(0)).getSegments().get(0)).getAirlineLocator())) {
            sb.append(((Segment)((SegmentTariff)prod.getSegmentTariffs().get(0)).getSegments().get(0)).getAirlineLocator());
        }
        DocGenHelper.println(buf, 0, sb.toString());
        DocGenHelper.println(buf, 0, "");
        DocGenHelper.println(buf, 0, "\u041e\u0422/\u0414\u041e               \u0420\u0415\u0419\u0421   \u041a\u041b \u0414\u0410\u0422\u0410 \u0412\u0420\u0415\u041c\u042f \u0421\u0422 \u0411\u0410\u0417\u041e\u0412\u042b\u0419 \u0422\u0410\u0420\u0418\u0424   \u041d\u0414\u0414  \u041d\u0414\u041f  \u0411\u0410\u0413");
        DocGenHelper.println(buf, 0, "FROM/TO             FLIGHT CL DATE DEP   ST FARE BASIS      NVB  NVA  BAG");
        DocGenHelper.println(buf, 0, "-------------------------------------------------------------------------");
        SimpleDateFormat dtf = new SimpleDateFormat("ddMMM HHmm", loc);
        String[] df2 = new SimpleDateFormat("ddMMM", loc);
        SimpleDateFormat df3 = new SimpleDateFormat("HHmm", loc);
        Segment lastSeg = null;
        for (SegmentTariff st : prod.getSegmentTariffs()) {
            Iterator iterator = st.getSegments().iterator();
            while (iterator.hasNext()) {
                Segment seg;
                lastSeg = seg = (Segment)iterator.next();
                GeoLocation location = (GeoLocation)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(seg.getDepartureLocation());
                GeoLocation city = TravelDocGenerator.getCity(location);
                String locName = city != null ? TravelDocGenerator.getName(city, loc) : seg.getDepartureLocation().getCode();
                DocGenHelper.print(buf, 1, locName, 17);
                DocGenHelper.print(buf, 1, loc.equals(Locale.ENGLISH) ? translator.getNativeCode(seg.getAirline()) : TravelDocGenerator.extractAirline(seg.getAirline().getCode(), "CRT"), 3);
                DocGenHelper.print(buf, 0, seg.getFlightNo(), 5);
                DocGenHelper.print(buf, 0, TextUtil.isBlank((String)seg.getClassOfSvcCode()) ? (TextUtil.isBlank((String)seg.getClassOfService()) ? "" : seg.getClassOfService()) : seg.getClassOfSvcCode(), 2);
                DocGenHelper.print(buf, 0, dtf.format(seg.getStartDate()));
                DocGenHelper.print(buf, 2, "OK");
                DocGenHelper.print(buf, 1, seg.getFareBasis() == null ? "" : seg.getFareBasis(), 15);
                if (seg.getNotValidBefore() == null) {
                    DocGenHelper.print(buf, 0, "", 5);
                } else {
                    DocGenHelper.print(buf, 0, df2.format(seg.getNotValidBefore()), 5);
                }
                if (seg.getNotValidAfter() == null) {
                    DocGenHelper.print(buf, 0, "", 5);
                } else {
                    DocGenHelper.print(buf, 0, df2.format(seg.getNotValidAfter()), 5);
                }
                DocGenHelper.print(buf, 2, seg.getLuggageInfo().getUnit() == null ? "" : AirProductHelper.luggageInfoToSring((LuggageInfo)seg.getLuggageInfo(), (Locale)loc), 4);
                DocGenHelper.println(buf, 0, "");
                String terminal = null;
                if (location != null && !location.equals((Object)city) && location.getType() == LocationType.AIRPORT) {
                    String caption = TravelDocGenerator.extractDict(location.toReference(), loc);
                    terminal = TextUtil.isBlank((String)seg.getDepartTerminal()) ? "" : seg.getDepartTerminal();
                    sb.setLength(0);
                    sb.append(caption).append(' ').append(terminal);
                    if (sb.toString().length() < 17) {
                        DocGenHelper.print(buf, 1, sb.toString(), 17);
                    } else {
                        DocGenHelper.print(buf, 1, caption, 17);
                    }
                } else {
                    DocGenHelper.print(buf, 1, "", 17);
                }
                DocGenHelper.print(buf, 9, "\u0412\u0420\u0415\u041c\u042f \u041f\u0420\u0418\u0411\u042b\u0422\u0418\u042f/ARRIVAL TIME:");
                DocGenHelper.println(buf, 0, df3.format(seg.getEndDate()));
                if (TextUtil.isBlank(terminal)) continue;
                DocGenHelper.println(buf, 1, terminal, 17);
            }
            if (lastSeg == null) continue;
            GeoLocation location = (GeoLocation)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(lastSeg.getArriveLocation());
            GeoLocation city = TravelDocGenerator.getCity(location);
            String locName = city != null ? TravelDocGenerator.getName(city, loc) : lastSeg.getArriveLocation().getCode();
            DocGenHelper.println(buf, 1, locName, 17);
            if (location == null || location.equals((Object)city) || location.getType() != LocationType.AIRPORT) continue;
            DocGenHelper.println(buf, 1, TravelDocGenerator.extractDict(location.toReference(), loc) + (TextUtil.isBlank((String)lastSeg.getArriveTerminal()) ? "" : ' ' + lastSeg.getArriveTerminal()), 17);
        }
        DocGenHelper.println(buf, 0, "");
        sb.setLength(0);
        if (!loc.equals(Locale.ENGLISH) && !TextUtil.isBlank((String)prod.getEndorsement()) && prod.getEndorsement().contains("ONLY")) {
            String[] ss = prod.getEndorsement().split("\\s");
            sb.append("\u0422\u041e\u041b\u042c\u041a\u041e ");
            for (String s : ss) {
                if (s.equals("ONLY")) continue;
                sb.append(TravelDocGenerator.extractAirline(ss[0].trim(), "CRT"));
            }
        }
        if (sb.length() == 0) {
            sb.append(prod.getEndorsement());
        }
        TravelDocGenerator.split(buf, "\u041f\u0415\u0420\u0415\u0414\u0410\u0422. \u041d\u0410\u0414\u041f\u0418\u0421\u0418/\u041e\u0413\u0420\u0410\u041d\u0418\u0427./ENDORSEMENTS/RESTRICTIONS: " + sb.toString(), 0, 74);
        DocGenHelper.println(buf, 0, "");
        DocGenHelper.println(buf, 0, "\u0424\u041e\u0420\u041c\u0410 \u041e\u041f\u041b\u0410\u0422\u042b/FORM OF PAYMENT  : " + TravelDocGenerator.getFopData(prod, loc));
        DocGenHelper.println(buf, 0, "");
        sb.setLength(0);
        sb.append("\u0420\u0410\u0421\u0427\u0401\u0422 \u0422\u0410\u0420\u0418\u0424\u0410/FARE CALCULATION: ");
        sb.append(prod.getFareCalculationData());
        TravelDocGenerator.split(buf, sb.toString(), 0, 74);
        DocGenHelper.println(buf, 0, "");
        DecimalFormat nf = new DecimalFormat("#0");
        sb.setLength(0);
        sb.append("\u0422\u0410\u0420\u0418\u0424/FARE         : ");
        Money baseFare = AirProductHelper.getBaseFare((Product)prod);
        sb.append(baseFare == null ? "" : nf.format(baseFare.getValue()));
        sb.append(baseFare == null ? "" : TravelDocGenerator.extractCurrency(baseFare.getCurrency(), loc));
        DocGenHelper.print(buf, 0, sb.toString(), 37);
        String equivCurr = TravelDocGenerator.extractCurrency(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)""), loc);
        sb.setLength(0);
        sb.append("\u042d\u041a\u0412\u0418\u0412.\u0412 \u0412\u0410\u041b.\u041f\u041b/EQUIV.FARE PD: ");
        sb.append(nf.format(AirProductHelper.getEquivalentFare((Product)prod)));
        sb.append(equivCurr);
        DocGenHelper.println(buf, 0, sb.toString());
        DocGenHelper.print(buf, 0, "\u0421\u0411\u041e\u0420/TAX/FEE/CHARGE: ", 20);
        sb.setLength(0);
        for (Tax tax : AirProductTaxHelper.getTaxesByCodes((Product)prod, (boolean)false, (String[])new String[0])) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            if (!TextUtil.isBlank((String)tax.getCode())) {
                sb.append(tax.getCode());
            }
            sb.append(nf.format(tax.getEquivalentAmount())).append(equivCurr);
        }
        DocGenHelper.println(buf, 17, sb.toString());
        sb.setLength(0);
        sb.append("\u0418\u0422\u041e\u0413\u041e/TOTAL        : ");
        BigDecimal total = BookingHelper.calculateProductPrice((BaseProduct)prod, (ContractType)ContractType.CLIENT).getTotal();
        sb.append(nf.format(total)).append(equivCurr);
        DocGenHelper.println(buf, 0, sb.toString());
        return buf.toString();
    }

    private static String generatePassengerInfoContent(Product prod, Locale loc) throws Exception {
        StringBuilder content = new StringBuilder();
        DecimalFormat numberFormat = new DecimalFormat("#0");
        String equivCurrencyCode = TravelDocGenerator.extractCurrency(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)""), loc);
        DocGenHelper.println(content, 0, "");
        DocGenHelper.println(content, 0, "-------------------------------------------------------------------------");
        DocGenHelper.println(content, 0, "");
        DocGenHelper.println(content, 0, "\u0414\u041e\u041f\u041e\u041b\u041d\u0418\u0422\u0415\u041b\u042c\u041d\u0410\u042f \u0418\u041d\u0424\u041e\u0420\u041c\u0410\u0426\u0418\u042f \u0414\u041b\u042f \u041f\u0410\u0421\u0421\u0410\u0416\u0418\u0420\u0410 / ADDITIONAL INFORMATION FOR THE PASSEGNER:");
        DocGenHelper.println(content, 0, "");
        BigDecimal total = BookingHelper.calculateProductPrice((BaseProduct)prod, (ContractType)ContractType.CLIENT).getTotal();
        BigDecimal fee = BookingHelper.calculateFee((BaseProduct)prod, (ContractType)ContractType.CLIENT);
        DocGenHelper.println(content, 0, "\u041f\u041b\u0410\u0422\u0410 \u0417\u0410 \u0418\u041d\u0424\u041e\u0420\u041c\u0410\u0426\u0418\u0424\u041e\u041d\u041d\u042b\u0415 \u0423\u0421\u041b\u0423\u0413\u0418 \u0410\u0413\u0415\u041d\u0422\u0421\u0422\u0412\u0410 / FEE FOR INFORMATION SERVICES OF THE AGENCY: " + numberFormat.format(fee) + equivCurrencyCode);
        DocGenHelper.println(content, 0, "");
        DocGenHelper.println(content, 0, "\u0414\u041e\u041a\u0423\u041c\u0415\u041d\u0422, \u041f\u041e\u0414\u0422\u0412\u0415\u0420\u0416\u0414\u0410\u042e\u0429\u0418\u0419 \u041f\u0420\u041e\u0418\u0417\u0412\u0415\u0414\u0415\u041d\u041d\u0423\u042e \u041e\u041f\u041b\u0410\u0422\u0423, \u041c\u041e\u0416\u041d\u041e \u041f\u041e\u041b\u0423\u0427\u0418\u0422\u042c \u0412 \u041e\u0424\u0418\u0421\u0415 \u0410\u0413\u0415\u041d\u0422\u0421\u0422\u0412\u0410, \u0423\u041a\u0410\u0417\u0410\u041d\u041d\u041e\u041c \u041d\u0410 \u0421\u0410\u0419\u0422\u0415 /");
        DocGenHelper.println(content, 0, "DOCUMENT CONFIRMING THE PAYMENT IS AVAILABLE IN THE OFFICE OF THE AGENCY, SHOWN ON THE WEB-SITE");
        DocGenHelper.println(content, 0, "");
        DocGenHelper.println(content, 0, "\u041e\u0411\u0429\u0410\u042f \u0421\u0423\u041c\u041c\u0410 / TOTAL AMOUNT: " + numberFormat.format(total.add(fee)) + equivCurrencyCode);
        return content.toString();
    }

    private static void split(StringBuilder buf, String text, int indent, int limit) {
        if (TextUtil.isBlank((String)text)) {
            DocGenHelper.println(buf, 0, "");
            return;
        }
        if (text.length() <= limit) {
            DocGenHelper.println(buf, 0, text);
            return;
        }
        int pos = 0;
        while (true) {
            if (pos + limit >= text.length()) break;
            DocGenHelper.println(buf, pos == 0 ? 0 : indent, text.substring(pos, pos + limit));
            pos += limit;
        }
        DocGenHelper.println(buf, indent, text.substring(pos));
    }

    private static String getFopData(Product prod, Locale loc) {
        if (AirProductHelper.getClientContractRelation((Product)prod).getFops().isEmpty()) {
            return "";
        }
        ProductFop fop = (ProductFop)AirProductHelper.getClientContractRelation((Product)prod).getFops().get(0);
        switch (fop.getType()) {
            case WEBMONEYR_PLATRON: 
            case WEBMONEYZ_PLATRON: 
            case WEBMONEYE_PLATRON: 
            case WEBMONEYRBANK_PLATRON: 
            case YANDEXMONEY_PLATRON: 
            case MOBW_PLATRON: 
            case MONEYMAILRU_PLATRON: 
            case W1RUR_PLATRON: 
            case W1USD_PLATRON: 
            case PAYPALUSD_PLATRON: 
            case PAYPALEUR_PLATRON: 
            case MONEYMAIL_PLATRON: 
            case RBKMONEY_PLATRON: 
            case INTELLECTMONEY_PLATRON: 
            case PSCB_PLATRON: 
            case BANKCARDPRU_PLATRON: 
            case EUROSET_PLATRON: 
            case EUROPLAT_PLATRON: 
            case SVYAZNOY_PLATRON: 
            case ELECSNET_PLATRON: 
            case OSMP_PLATRON: 
            case OSMPII_PLATRON: 
            case UNIKASSA_PLATRON: 
            case COMEPAY_PLATRON: 
            case PINPAY_PLATRON: 
            case ESGP_PLATRON: 
            case PETROCOMMERCE_PLATRON: 
            case CYBERPLAT_CONTACT_PLATRON: 
            case CONTACT_PLATRON: 
            case MASTERBANK_PLATRON: 
            case BANKTRANSFER_PLATRON: 
            case BANKTRANSFERUSD_PLATRON: 
            case BANKTRANSFEREUR_PLATRON: 
            case CASH_PLATRON: 
            case BEELINEMK_PLATRON: 
            case RURU_PLATRON: 
            case INPLATMTS_PLATRON: 
            case INPLATMEGAFON_PLATRON: 
            case MTSMK_PLATRON: 
            case MEGAFONMK_PLATRON: 
            case MOBILEPHONE_PLATRON: 
            case ALFACLICK_PLATRON: 
            case FAKTURA_PLATRON: 
            case PSB_PLATRON: 
            case HANDYBANK_PLATRON: 
            case TEST_PLATRON: 
            case TESTCARD_PLATRON: 
            case WEBMONEY_CHRONOPAY: 
            case YANDEX_MONEY_CHRONOPAY: 
            case QIWI_PAYONLINE: 
            case WEBMONEY_PAYONLINE: 
            case CASH_DELIVERY: 
            case CASH: 
            case YANDEX_MONEY_UNITELLER: 
            case RBK_MONEY_UNITELLER: 
            case MONEY_MAIL_UNITELLER: 
            case WEB_CREDS_UNITELLER: 
            case EASY_PAY_UNITELLER: 
            case PLATEZH_RU_UNITELLER: 
            case DENGI_MAIL_RU_UNITELLER: 
            case MOBILE_PAYMENT_MEGAFON_UNITELLER: 
            case MOBILE_PAYMENT_MTS_UNITELLER: 
            case MOBILE_PAYMENT_BEELINE_UNITELLER: 
            case PAYPAL_UNITELLER: 
            case VKONTAKTE_UNITELLER: 
            case EUROSET_UNITELLER: 
            case YOTA_MONEY_UNITELLER: 
            case QIWI_WALLET_UNITELLER: 
            case PLAT_FON_UNITELLER: 
            case MONEYBOOKERS_UNITELLER: 
            case WEB_MONEY_WMR_UNITELLER: {
                return loc.equals(Locale.ENGLISH) ? "CASH" : "\u041d\u0410\u041b";
            }
            case INVOICE_RAPIDA: 
            case INVOICE: 
            case PTA: {
                return loc.equals(Locale.ENGLISH) ? "INVOICE" : "\u041f\u041f";
            }
            case CREDIT_CARD: 
            case CREDIT_CARD_ONLINE_CHRONOPAY: 
            case CREDIT_CARD_ONLINE_RAIFFEISEN: 
            case CREDIT_CARD_ONLINE_RBS: 
            case CREDIT_CARD_ONLINE_RBS_V2: 
            case CREDIT_CARD_ONLINE_SIRENA: 
            case CREDIT_CARD_ONLINE_CLEARPARK: 
            case CREDIT_CARD_ONLINE_PAYONLINE: 
            case CREDIT_CARD_AGENCY: 
            case RUSSIANSTANDARD_PLATRON: 
            case RAIFFEISEN_PLATRON: 
            case MASTERBANKCARD_PLATRON: 
            case TRANSCRED_PLATRON: 
            case CREDIT_CARD_UNITELLER: {
                String vendor = "";
                if (fop.getCard() != null) {
                    switch (fop.getCard().getVendor()) {
                        case AMEX: {
                            vendor = "AX";
                            break;
                        }
                        case DINERS_CLUB: {
                            vendor = "DC";
                            break;
                        }
                        case JCB: {
                            vendor = "JC";
                            break;
                        }
                        case MASTERCARD: {
                            vendor = "CA";
                            break;
                        }
                        case VISA: {
                            vendor = "VI";
                            break;
                        }
                        case MIR: {
                            vendor = "MR";
                            break;
                        }
                        default: {
                            vendor = fop.getCard().getVendor().toString();
                        }
                    }
                }
                return (loc.equals(Locale.ENGLISH) ? "CC " : "\u041f\u041a ") + vendor + (fop.getCard() == null ? "" : fop.getCard().getNumber());
            }
        }
        return "";
    }

    private static String getGDSCode(GdsName gds) {
        if (gds == null) {
            return "";
        }
        switch (gds) {
            case SABRE: {
                return "SABRE";
            }
            case SIRENA: {
                return "1H";
            }
            case GABRIEL: {
                return "GABRIEL";
            }
        }
        return "";
    }

    private static GeoLocation getCity(GeoLocation loc) {
        GeoLocation result = loc;
        while (result != null) {
            if (result.getType() == LocationType.CITY) {
                return result;
            }
            result = (GeoLocation)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(result.getParent());
        }
        return loc;
    }

    private static <D extends BaseDictionary> String getName(DictionaryReference<D> ref, Locale locale) {
        return TravelDocGenerator.getName(((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(ref), locale);
    }

    private static <D extends BaseDictionary> String getName(D res, Locale locale) {
        if (res == null) {
            return "";
        }
        String result = (String)MiscUtil.findByLocale((Map)res.getTranslations(), (Locale)locale);
        if (TextUtil.isBlank((String)result) && !MiscUtil.equals((Object)locale, (Object)Locale.ENGLISH)) {
            result = (String)MiscUtil.findByLocale((Map)res.getTranslations(), (Locale)Locale.ENGLISH);
        }
        return TextUtil.isBlank((String)result) ? res.getCode() : result;
    }

    private static String getPassportCodeRu(PassportType type) {
        if (type == null) {
            return "\u0422\u0421";
        }
        switch (type) {
            case INTERNAL: {
                return "\u041f\u0421";
            }
            case FOREIGN: {
                return "\u041f\u0421\u041f";
            }
            case DIPLOMATIC: {
                return "\u0414\u041f";
            }
            case BIRTHDAY_NOTIFICATION: {
                return "\u0421\u0420";
            }
            case CERTIFICATEOFRELEASE: {
                return "\u0421\u041f\u041e";
            }
            case SEAMANSID: {
                return "\u041f\u041c";
            }
            case MILITARYID: {
                return "\u0412\u0411";
            }
            case PASSPORT: {
                return "\u041d\u041f";
            }
        }
        return "\u0422\u0421";
    }

    private static String getPassportCodeEn(PassportType type) {
        if (type == null) {
            return "NS";
        }
        switch (type) {
            case INTERNAL: {
                return "PS";
            }
            case FOREIGN: {
                return "PSP";
            }
            case DIPLOMATIC: {
                return "DP";
            }
            case BIRTHDAY_NOTIFICATION: {
                return "SR";
            }
            case CERTIFICATEOFRELEASE: {
                return "SPO";
            }
            case SEAMANSID: {
                return "PM";
            }
            case MILITARYID: {
                return "VB";
            }
            case PASSPORT: {
                return "NP";
            }
        }
        return "NS";
    }

    private static String buildName(Passport passport, int limit) {
        if (passport == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        if (passport.getLastName().length() > limit) {
            buf.append(passport.getLastName().substring(0, limit));
        } else {
            buf.append(passport.getLastName());
        }
        if (buf.length() < limit) {
            buf.append('/');
        }
        if (passport.getFirstName().length() > limit - buf.length()) {
            buf.append(passport.getFirstName().substring(0, limit - buf.length()));
        } else {
            buf.append(passport.getFirstName());
        }
        if (buf.length() < limit && !TextUtil.isBlank((String)passport.getMiddleName())) {
            buf.append(' ').append(passport.getMiddleName().charAt(0));
        }
        return buf.toString();
    }

    private TravelDocGenerator() {
    }

    static {
        PDFImage image;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (InputStream strm = TravelDocGenerator.class.getResourceAsStream("logo.jpg");){
                IoUtil.copyStream((InputStream)strm, (OutputStream)baos, (int)256);
            }
            image = TravelDocGenerator.createImage(TravelDocGenerator.convertByteArray2BinaryData(baos.toByteArray()));
        }
        catch (Exception e) {
            LoggerFactory.getLogger(TravelDocGenerator.class).error("failed loading logo image", (Throwable)e);
            image = null;
        }
        IMAGE = image;
        RUSSIAN = new Locale("RU");
        translator = new CodeTranslator(new String[]{"IATA", "ISO", "CRT"});
        childGenderTitles = new HashMap();
        adultGenderTitles = new HashMap();
        childGenderTitles.put(Locale.ENGLISH, Arrays.asList("MSS", "MSTR"));
        childGenderTitles.put(RUSSIAN, Arrays.asList("\u0413-\u0416\u0410", "\u0413-\u041d"));
        adultGenderTitles.put(Locale.ENGLISH, Arrays.asList("MRS", "MR"));
        adultGenderTitles.put(RUSSIAN, Arrays.asList("\u0413-\u0416\u0410", "\u0413-\u041d"));
    }
}

