/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.docgen;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.FilledTemplateDocument;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;

public class TravelReservationJRDocumentRender {
    private static final String KEY_FIRST_DEPARTURE_DATE = "FIRST_DEPARTURE_DATE";
    private static final String KEY_LAST_ARRIVE_DATE = "LAST_ARRIVE_DATE";
    private static final String KEY_DESTINATION = "DESTINATION";
    private static final String KEY_TRAVELLERS_NAMES = "TRAVELLERS_NAMES";
    private static final String KEY_RECORD_LOCATOR = "RESERVATION_CODE";
    private static final String KEY_MARKETING_CARRIERS_RECORD_LOCATORS = "MARKETING_CARRIERS_RESERVATION_CODES";
    private static final String KEY_AGENCY_LOGO = "AGENCY_LOGO";
    private static final String KEY_AGENCY_LOGO_WIDTH = "AGENCY_LOGO_WIDTH";
    private static final String KEY_AGENCY_LOGO_HEIGHT = "AGENCY_LOGO_HEIGHT";
    private static final String KEY_AGENCY_NAME = "AGENCY_NAME";
    private static final String KEY_AGENCY_PHONE = "AGENCY_PHONE";
    private static final String KEY_AGENCY_EMAIL = "AGENCY_EMAIL";
    private static final String FIELD_SEGMENT_ID = "SEGMENT_ID";
    private static final String FIELD_OVERNIGHT = "OVERNIGHT";
    private static final String FIELD_DEPARTURE_DATE = "DEPARTURE_DATE";
    private static final String FIELD_ARRIVE_DATE = "ARRIVE_DATE";
    private static final String FIELD_CODE_SHARE = "CODE_SHARE";
    private static final String FIELD_MARKETING_CARRIER_NAME = "MARKETING_CARRIER_NAME";
    private static final String FIELD_MARKETING_CARRIER_FLIGHT_NUMBER = "MARKETING_CARRIER_FLIGHT_NUMBER";
    private static final String FIELD_OPERATING_CARRIER_NAME = "OPERATING_CARRIER_NAME";
    private static final String FIELD_FLIGHT_DURATION = "FLIGHT_DURATION";
    private static final String FIELD_DEPARTURE_AIRPORT_CODE = "DEPARTURE_AIRPORT_CODE";
    private static final String FIELD_DEPARTURE_LOCATION = "DEPARTURE_LOCATION";
    private static final String FIELD_DEPARTURE_TERMINAL = "DEPARTURE_TERMINAL";
    private static final String FIELD_ARRIVE_AIRPORT_CODE = "ARRIVE_AIRPORT_CODE";
    private static final String FIELD_ARRIVE_LOCATION = "ARRIVE_LOCATION";
    private static final String FIELD_ARRIVE_TERMINAL = "ARRIVE_TERMINAL";
    private static final String FIELD_AIRCRAFT = "AIRCRAFT";
    private static final String FIELD_NUMBER_OF_STOPS = "NUMBER_OF_STOPS";
    private static final String FIELD_ISSUED = "ISSUED";
    private static final String FIELD_TRAVELLER_NAME = "TRAVELLER_NAME";
    private static final String FIELD_SERVICE_CLASS = "SERVICE_CLASS";
    private static final String FIELD_SYSTEM_NUMBER = "SYSTEM_NUMBER";
    private static final String FIELD_MEALS = "MEALS";

    public FilledTemplateDocument renderReport(EntityContainer<BookingFile> bookingFileContainer, Reservation reservation, EntityContainer<TemplateDocument> templateContainer, Locale locale) throws Exception {
        LinkedHashSet<Message> messages = new LinkedHashSet<Message>();
        TemplateDocument templateDocument = (TemplateDocument)templateContainer.getEntity();
        JasperReport jasperReport = JasperUtil.getReport((byte[])templateDocument.getContent());
        if (templateDocument.getContent() == null) {
            throw Xeption.forAdmin((String)"\u0423 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 {0} \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043e \u043f\u043e\u043b\u0435 '\u0448\u0430\u0431\u043b\u043e\u043d'", (Object[])new Object[]{templateDocument.getTitle()});
        }
        Map<String, Object> parameters = this.getParameters(bookingFileContainer, reservation, locale, messages);
        if (parameters == null) {
            throw new Exception("unable to create parameters");
        }
        JRDataSource dataSource = this.getDataSource(bookingFileContainer, reservation, jasperReport, locale, messages);
        if (dataSource == null) {
            throw new Exception("unable to create data source");
        }
        byte[] content = JasperUtil.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)dataSource, null);
        if (content == null) {
            throw new Exception("unable to fill document");
        }
        if ((content = JasperUtil.convertToPdf((byte[])content)) == null) {
            throw new Exception("unable to convert document to pdf");
        }
        Date date = new Date();
        FilledTemplateDocument filledTemplateDocument = new FilledTemplateDocument();
        filledTemplateDocument.setTitle(String.format("Travel-Reservation %s", CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation)));
        filledTemplateDocument.setName("travel-reservation.pdf");
        filledTemplateDocument.setType(DocumentType.TRAVELDOCUMENT);
        filledTemplateDocument.setContentType(ContentType.PDF);
        filledTemplateDocument.setContent(content);
        filledTemplateDocument.setCreated(date);
        filledTemplateDocument.setNavigationKey(bookingFileContainer.getUid());
        filledTemplateDocument.setOwner(bookingFileContainer.toReference());
        filledTemplateDocument.setCheckSum(MiscUtil.getCheckSum((byte[])filledTemplateDocument.getContent()));
        filledTemplateDocument.setTemplate(templateContainer.toReference());
        filledTemplateDocument.getMessages().addAll(messages);
        return filledTemplateDocument;
    }

    protected Map<String, Object> getParameters(EntityContainer<BookingFile> bookingFileContainer, Reservation reservation, Locale locale, Set<Message> messages) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        EntityContainer agencyContainer = EntityStorage.get().resolve(bookingFile.getAgency());
        if (agencyContainer == null) {
            this.addMessage(messages, "\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430", null, MessageType.ERROR, new Object[0]);
            return null;
        }
        Organization agency = (Organization)agencyContainer.getEntity();
        parameters.put("REPORT_LOCALE", locale);
        parameters.put(KEY_FIRST_DEPARTURE_DATE, this.getFirstDepartureDate(reservation));
        parameters.put(KEY_LAST_ARRIVE_DATE, this.getLastArriveDate(reservation));
        parameters.put(KEY_DESTINATION, this.buildDestinationString(reservation, locale));
        parameters.put(KEY_TRAVELLERS_NAMES, this.buildTravellersNamesString(reservation, locale));
        parameters.put(KEY_RECORD_LOCATOR, CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation));
        parameters.put(KEY_MARKETING_CARRIERS_RECORD_LOCATORS, this.buildMarketingCarriersRecordLocatorsString(reservation, locale));
        ImageData imageData = new ImageData(agency.getLogo());
        parameters.put(KEY_AGENCY_LOGO, imageData.getData());
        parameters.put(KEY_AGENCY_LOGO_WIDTH, imageData.getWidth());
        parameters.put(KEY_AGENCY_LOGO_HEIGHT, imageData.getHeight());
        parameters.put(KEY_AGENCY_NAME, L10nStringHelper.getValue((L10nString)agency.getShortName(), (Locale)locale, (boolean)false));
        parameters.put(KEY_AGENCY_PHONE, this.buildPhoneString(agency.getCommunications(), Arrays.asList(CommunicationType.WORK_PHONE), locale));
        parameters.put(KEY_AGENCY_EMAIL, this.buildEmailString(agency.getCommunications(), Arrays.asList(CommunicationType.EMAIL), locale));
        return parameters;
    }

    private Date getFirstDepartureDate(Reservation reservation) {
        Date date = null;
        for (BaseProduct baseProduct : reservation.getProducts()) {
            if (!(baseProduct instanceof Product)) continue;
            Product product = (Product)baseProduct;
            for (SegmentTariff segmentTariff : product.getSegmentTariffs()) {
                for (Segment segment : segmentTariff.getSegments()) {
                    if (segment.getStartDate() == null || date != null && !segment.getStartDate().before(date)) continue;
                    date = segment.getStartDate();
                }
            }
        }
        return date;
    }

    private Date getLastArriveDate(Reservation reservation) {
        Date date = null;
        for (BaseProduct baseProduct : reservation.getProducts()) {
            if (!(baseProduct instanceof Product)) continue;
            Product product = (Product)baseProduct;
            for (SegmentTariff segmentTariff : product.getSegmentTariffs()) {
                for (Segment segment : segmentTariff.getSegments()) {
                    if (segment.getEndDate() == null || date != null && !segment.getEndDate().after(date)) continue;
                    date = segment.getEndDate();
                }
            }
        }
        return date;
    }

    private String buildDestinationString(Reservation reservation, Locale locale) {
        Product product = null;
        for (BaseProduct baseProduct : reservation.getProducts()) {
            if (!(baseProduct instanceof Product)) continue;
            product = (Product)baseProduct;
            break;
        }
        if (product == null) {
            return null;
        }
        String destinationCityCode = null;
        HashSet<String> cityCodes = new HashSet<String>();
        for (SegmentTariff segmentTariff : product.getSegmentTariffs()) {
            for (Segment segment : segmentTariff.getSegments()) {
                GeoLocation arrivalCity;
                DictionaryReference arriveLocation;
                GeoLocation departureCity;
                String departureCityCode = null;
                String arriveCityCode = null;
                DictionaryReference departureLocation = segment.getDepartureLocation();
                if (departureLocation != null && (departureCity = DictHelper.findCityByAirport((String)(departureCityCode = departureLocation.getCode()))) != null) {
                    departureCityCode = departureCity.getCode();
                }
                if ((arriveLocation = segment.getArriveLocation()) != null && (arrivalCity = DictHelper.findCityByAirport((String)(arriveCityCode = arriveLocation.getCode()))) != null) {
                    arriveCityCode = arrivalCity.getCode();
                }
                cityCodes.add(departureCityCode);
                if (arriveCityCode != null && !cityCodes.contains(arriveCityCode)) {
                    destinationCityCode = arriveCityCode;
                }
                cityCodes.add(arriveCityCode);
            }
        }
        if (destinationCityCode == null) {
            return null;
        }
        StringBuilder destinationString = new StringBuilder();
        GeoLocation destinationCity = (GeoLocation)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).findByCode(GeoLocation.class, destinationCityCode);
        if (destinationCity != null) {
            DictionaryReference destinationCountry;
            destinationString.append(destinationCity.toString(locale));
            if (destinationCity.getCountry() != null && (destinationCountry = destinationCity.getCountry()) != null) {
                if (destinationString.length() > 0) {
                    destinationString.append(", ");
                }
                destinationString.append(destinationCountry.toString(locale));
            }
        }
        return destinationString.length() > 0 ? destinationString.toString() : null;
    }

    private String buildTravellersNamesString(Reservation reservation, Locale locale) {
        ArrayList<Traveller> travellers = new ArrayList<Traveller>();
        for (BaseProduct baseProduct : reservation.getProducts()) {
            Product product;
            Traveller traveller;
            if (!(baseProduct instanceof Product) || (traveller = (product = (Product)baseProduct).getTraveller()) == null || travellers.contains(traveller)) continue;
            travellers.add(traveller);
        }
        StringBuilder travellersNames = new StringBuilder();
        for (Traveller traveller : travellers) {
            String travellerName = this.buildTravellerNameString(traveller, locale);
            if (TextUtil.isBlank((String)travellerName)) continue;
            if (travellersNames.length() > 0) {
                travellersNames.append("\n");
            }
            travellersNames.append(travellerName);
        }
        return travellersNames.length() > 0 ? travellersNames.toString() : null;
    }

    private String buildTravellerNameString(Traveller traveller, Locale locale) {
        if (traveller.getPassport() != null) {
            StringBuilder travellerName = new StringBuilder();
            Passport passport = traveller.getPassport();
            if (passport != null) {
                if (!TextUtil.isBlank((String)passport.getLastName())) {
                    travellerName.append(passport.getLastName().trim());
                }
                if (!TextUtil.isBlank((String)passport.getFirstName())) {
                    if (travellerName.length() > 0) {
                        travellerName.append("/");
                    }
                    travellerName.append(passport.getFirstName().trim());
                }
                if (passport.getGender() != null) {
                    if (travellerName.length() > 0) {
                        travellerName.append(" ");
                    }
                    if (passport.getGender() == Gender.MALE) {
                        travellerName.append("mr");
                    } else if (passport.getGender() == Gender.FEMALE) {
                        travellerName.append("mrs");
                    }
                }
                if (travellerName.length() > 0) {
                    return travellerName.toString();
                }
            }
        }
        return null;
    }

    private String buildMarketingCarriersRecordLocatorsString(Reservation reservation, Locale locale) {
        ArrayList<String> recordLocators = new ArrayList<String>();
        for (BaseProduct baseProduct : reservation.getProducts()) {
            if (!(baseProduct instanceof Product)) continue;
            Product product = (Product)baseProduct;
            for (SegmentTariff segmentTariff : product.getSegmentTariffs()) {
                for (Segment segment : segmentTariff.getSegments()) {
                    StringBuilder recordLocator = new StringBuilder();
                    if (!TextUtil.isBlank((String)segment.getAirlineLocator())) {
                        recordLocator.append(segment.getAirlineLocator().trim());
                    }
                    if (segment.getAirline() != null && !TextUtil.isBlank((String)segment.getAirline().getCode())) {
                        if (recordLocator.length() > 0) {
                            recordLocator.append(" ");
                        }
                        recordLocator.append(String.format("(%s)", segment.getAirline().getCode()));
                    }
                    if (recordLocator.length() <= 0 || recordLocators.contains(recordLocator.toString())) continue;
                    recordLocators.add(recordLocator.toString());
                }
            }
        }
        return recordLocators.size() > 0 ? TextUtil.join((String)", ", recordLocators) : null;
    }

    private String buildPhoneString(List<Communication> communications, List<CommunicationType> communicationTypes, Locale locale) {
        for (CommunicationType communicationType : communicationTypes) {
            for (Communication communication : ProfileHelper.filterCommunications(communications, Collections.singleton(communicationType))) {
                String phoneString = ProfileHelper.buildFullPhoneNumber((Communication)communication);
                if (TextUtil.isBlank((String)phoneString)) continue;
                return phoneString.trim();
            }
        }
        return null;
    }

    private String buildEmailString(List<Communication> communications, List<CommunicationType> communicationTypes, Locale locale) {
        for (CommunicationType communicationType : communicationTypes) {
            for (Communication communication : ProfileHelper.filterCommunications(communications, Collections.singleton(communicationType))) {
                String emailString = communication.getSense();
                if (TextUtil.isBlank((String)emailString)) continue;
                return emailString.trim();
            }
        }
        return null;
    }

    private String buildClassOfServiceString(ClassOfService classOfService, Locale locale) {
        String classOfServiceString = null;
        LocaleManager localeManager = (LocaleManager)Environment.getPublished(LocaleManager.class);
        Locale currentLocale = localeManager.getCurrentLocale();
        localeManager.setCurrentLocale(localeManager.isSupportedLocale(locale) ? locale : Locale.ENGLISH);
        classOfServiceString = classOfService.toString();
        localeManager.setCurrentLocale(currentLocale);
        return classOfServiceString;
    }

    protected JRDataSource getDataSource(EntityContainer<BookingFile> bookingFileContainer, Reservation reservation, JasperReport jasperReport, Locale locale, Set<Message> messages) {
        ArrayList data = new ArrayList();
        DictionaryCache dictionaryCache = (DictionaryCache)Environment.getPublished(DictionaryCache.class);
        LinkedHashMap<String, ArrayList<SegmentInfo>> segmentInfos = new LinkedHashMap<String, ArrayList<SegmentInfo>>();
        for (BaseProduct baseProduct : reservation.getProducts()) {
            if (!(baseProduct instanceof Product)) continue;
            Product product = (Product)baseProduct;
            for (SegmentTariff segmentTariff : product.getSegmentTariffs()) {
                for (Segment segment : segmentTariff.getSegments()) {
                    SegmentInfo segmentInfo = new SegmentInfo();
                    segmentInfo.setRecordLocator(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation));
                    segmentInfo.setTraveller(product.getTraveller());
                    segmentInfo.setSystemNumber(product.getSystemNumber());
                    segmentInfo.setSegment(segment);
                    segmentInfo.setProduct(product);
                    String hashCode = String.valueOf(segmentInfo.hashCode());
                    ArrayList<SegmentInfo> infos = (ArrayList<SegmentInfo>)segmentInfos.get(hashCode);
                    if (infos == null) {
                        infos = new ArrayList<SegmentInfo>();
                        segmentInfos.put(hashCode, infos);
                    }
                    infos.add(segmentInfo);
                }
            }
        }
        for (Map.Entry entry : segmentInfos.entrySet()) {
            String hashCode = (String)entry.getKey();
            for (SegmentInfo segmentInfo : (List)entry.getValue()) {
                ClassOfService classOfService;
                GeoLocation arriveAirport;
                GeoLocation departureAirport;
                Segment segment = segmentInfo.getSegment();
                HashMap<String, Object> record = new HashMap<String, Object>();
                record.put(FIELD_SEGMENT_ID, hashCode);
                record.put(FIELD_OVERNIGHT, segment.getStartDate() != null && segment.getEndDate() != null && MiscUtil.clearTime((Date)segment.getStartDate()).before(MiscUtil.clearTime((Date)segment.getEndDate())));
                record.put(FIELD_DEPARTURE_DATE, segment.getStartDate());
                record.put(FIELD_ARRIVE_DATE, segment.getEndDate());
                record.put(FIELD_CODE_SHARE, segment.isCodeShare());
                if (segment.getAirline() != null) {
                    record.put(FIELD_MARKETING_CARRIER_NAME, segment.getAirline().toString(locale));
                }
                StringBuilder flightNumber = new StringBuilder();
                if (segment.getAirline() != null && !TextUtil.isBlank((String)segment.getAirline().getCode())) {
                    flightNumber.append(segment.getAirline().getCode().trim());
                }
                if (!TextUtil.isBlank((String)segment.getFlightNo())) {
                    if (flightNumber.length() > 0) {
                        flightNumber.append(" ");
                    }
                    flightNumber.append(segment.getFlightNo().trim());
                }
                record.put(FIELD_MARKETING_CARRIER_FLIGHT_NUMBER, flightNumber.length() > 0 ? flightNumber.toString() : null);
                if (segment.getCodeShareCarrier() != null) {
                    record.put(FIELD_OPERATING_CARRIER_NAME, segment.getCodeShareCarrier().toString(locale));
                }
                if (segment.getFlightDuration() != null) {
                    record.put(FIELD_FLIGHT_DURATION, segment.getFlightDuration().longValue() * 60L * 1000L);
                }
                ArrayList<CodeSystem> codeSystems = new ArrayList<CodeSystem>(Arrays.asList(CodeSystem.values()));
                codeSystems.remove(CodeSystem.IATA);
                codeSystems.remove(CodeSystem.CRT);
                codeSystems.add(0, CodeSystem.CRT);
                codeSystems.add(0, CodeSystem.IATA);
                if (segment.getDepartureLocation() != null && (departureAirport = (GeoLocation)dictionaryCache.resolveReference(segment.getDepartureLocation())) != null && departureAirport.getType() == LocationType.AIRPORT) {
                    record.put(FIELD_DEPARTURE_AIRPORT_CODE, DictHelper.getCodeVariant((BaseDictionary)departureAirport, codeSystems));
                    StringBuilder departureLocationString = new StringBuilder();
                    departureLocationString.append(departureAirport.toString(locale));
                    GeoLocation departureCity = DictHelper.findCityByAirport((String)departureAirport.getCode());
                    if (departureCity != null) {
                        if (departureLocationString.length() > 0) {
                            departureLocationString.append(", ");
                        }
                        departureLocationString.append(departureCity.toString(locale));
                        if (departureCity.getCountry() != null) {
                            DictionaryReference departureCountry = departureCity.getCountry();
                            if (departureLocationString.length() > 0) {
                                departureLocationString.append(", ");
                            }
                            departureLocationString.append(departureCountry.toString(locale));
                        }
                    }
                    record.put(FIELD_DEPARTURE_LOCATION, departureLocationString.length() > 0 ? departureLocationString.toString() : null);
                }
                record.put(FIELD_DEPARTURE_TERMINAL, segment.getDepartTerminal());
                if (segment.getArriveLocation() != null && (arriveAirport = (GeoLocation)dictionaryCache.resolveReference(segment.getArriveLocation())) != null && arriveAirport.getType() == LocationType.AIRPORT) {
                    record.put(FIELD_ARRIVE_AIRPORT_CODE, DictHelper.getCodeVariant((BaseDictionary)arriveAirport, codeSystems));
                    StringBuilder arriveLocationString = new StringBuilder();
                    arriveLocationString.append(arriveAirport.toString(locale));
                    GeoLocation arriveCity = DictHelper.findCityByAirport((String)arriveAirport.getCode());
                    if (arriveCity != null) {
                        if (arriveLocationString.length() > 0) {
                            arriveLocationString.append(", ");
                        }
                        arriveLocationString.append(arriveCity.toString(locale));
                        if (arriveCity.getCountry() != null) {
                            DictionaryReference arriveCountry = arriveCity.getCountry();
                            if (arriveLocationString.length() > 0) {
                                arriveLocationString.append(", ");
                            }
                            arriveLocationString.append(arriveCountry.toString(locale));
                        }
                    }
                    record.put(FIELD_ARRIVE_LOCATION, arriveLocationString.length() > 0 ? arriveLocationString.toString() : null);
                }
                record.put(FIELD_ARRIVE_TERMINAL, segment.getArriveTerminal());
                if (segment.getBoard() != null) {
                    record.put(FIELD_AIRCRAFT, segment.getBoard().toString(locale));
                }
                if (segment.getNoOfStops() != null) {
                    record.put(FIELD_NUMBER_OF_STOPS, segment.getNoOfStops().toString());
                }
                record.put(FIELD_ISSUED, segmentInfo.getSystemNumber() != null);
                if (segmentInfo.getTraveller() != null) {
                    record.put(FIELD_TRAVELLER_NAME, this.buildTravellerNameString(segmentInfo.getTraveller(), locale));
                }
                if (segment.getClassOfSvcCode() != null && (classOfService = DictHelper.findClassOfService((Segment)segment, (Date)segmentInfo.getProduct().getIssueDate())) != null) {
                    record.put(FIELD_SERVICE_CLASS, this.buildClassOfServiceString(classOfService, locale));
                }
                record.put(FIELD_SYSTEM_NUMBER, segmentInfo.getSystemNumber());
                if (segment.getMealServiceIndicator() != null) {
                    record.put(FIELD_MEALS, segment.getMealServiceIndicator().toString(locale));
                }
                data.add(record);
            }
        }
        return new JRMapCollectionDataSource(data);
    }

    private void addMessage(Set<Message> messages, String text, String details, MessageType type, Object ... parameters) {
        Message message = new Message();
        message.setType(type);
        message.setMessage(L10nResourcesManager.createL10nMessage((String)text, (Object[])parameters));
        message.setDetails(details);
        if (!messages.contains(message)) {
            messages.add(message);
        }
    }

    private static class SegmentInfo {
        private static final String ISSUED = "issued";
        private static final String BOOKED = "booked";
        private String recordLocator;
        private Traveller traveller;
        private String systemNumber;
        private Segment segment;
        private Product product;

        private SegmentInfo() {
        }

        public String getRecordLocator() {
            return this.recordLocator;
        }

        public void setRecordLocator(String recordLocator) {
            this.recordLocator = recordLocator;
        }

        public Traveller getTraveller() {
            return this.traveller;
        }

        public void setTraveller(Traveller traveller) {
            this.traveller = traveller;
        }

        public String getSystemNumber() {
            return this.systemNumber;
        }

        public void setSystemNumber(String systemNumber) {
            this.systemNumber = systemNumber;
        }

        public Segment getSegment() {
            return this.segment;
        }

        public void setSegment(Segment segment) {
            this.segment = segment;
        }

        public Product getProduct() {
            return this.product;
        }

        public void setProduct(Product product) {
            this.product = product;
        }

        public int hashCode() {
            int hashCode = 37;
            if (this.recordLocator != null) {
                hashCode = hashCode * 17 + this.recordLocator.hashCode();
            }
            hashCode = this.systemNumber != null ? hashCode * 17 + ISSUED.hashCode() : hashCode * 17 + BOOKED.hashCode();
            if (this.segment != null) {
                if (this.segment.getStartDate() != null) {
                    hashCode = hashCode * 17 + this.segment.getStartDate().hashCode();
                }
                if (this.segment.getEndDate() != null) {
                    hashCode = hashCode * 17 + this.segment.getEndDate().hashCode();
                }
                if (this.segment.getAirline() != null) {
                    hashCode = hashCode * 17 + this.segment.getAirline().hashCode();
                }
                if (this.segment.getFlightNo() != null) {
                    hashCode = hashCode * 17 + this.segment.getFlightNo().hashCode();
                }
                if (this.segment.getCodeShareCarrier() != null) {
                    hashCode = hashCode * 17 + this.segment.getCodeShareCarrier().hashCode();
                }
                if (this.segment.getDepartureLocation() != null) {
                    hashCode = hashCode * 17 + this.segment.getDepartureLocation().hashCode();
                }
                if (this.segment.getDepartTerminal() != null) {
                    hashCode = hashCode * 17 + this.segment.getDepartTerminal().hashCode();
                }
                if (this.segment.getArriveLocation() != null) {
                    hashCode = hashCode * 17 + this.segment.getArriveLocation().hashCode();
                }
                if (this.segment.getArriveTerminal() != null) {
                    hashCode = hashCode * 17 + this.segment.getArriveTerminal().hashCode();
                }
                if (this.segment.getBoard() != null) {
                    hashCode = hashCode * 17 + this.segment.getBoard().hashCode();
                }
            }
            return hashCode;
        }

        public boolean equals(Object object) {
            if (!(object instanceof SegmentInfo)) {
                return false;
            }
            SegmentInfo segmentInfo = (SegmentInfo)object;
            if (!MiscUtil.equals((Object)this.recordLocator, (Object)segmentInfo.recordLocator)) {
                return false;
            }
            if (!MiscUtil.equals((Object)(this.systemNumber != null ? ISSUED : BOOKED), (Object)(segmentInfo.systemNumber != null ? ISSUED : BOOKED))) {
                return false;
            }
            if (this.segment != null && segmentInfo.segment != null) {
                return MiscUtil.equals((Object)this.segment.getStartDate(), (Object)segmentInfo.segment.getStartDate()) && MiscUtil.equals((Object)this.segment.getEndDate(), (Object)segmentInfo.segment.getEndDate()) && MiscUtil.equals((Object)this.segment.getAirline(), (Object)segmentInfo.segment.getAirline()) && MiscUtil.equals((Object)this.segment.getFlightNo(), (Object)segmentInfo.segment.getFlightNo()) && MiscUtil.equals((Object)this.segment.getCodeShareCarrier(), (Object)segmentInfo.segment.getCodeShareCarrier()) && MiscUtil.equals((Object)this.segment.getDepartureLocation(), (Object)segmentInfo.segment.getDepartureLocation()) && MiscUtil.equals((Object)this.segment.getDepartTerminal(), (Object)segmentInfo.segment.getDepartTerminal()) && MiscUtil.equals((Object)this.segment.getArriveLocation(), (Object)segmentInfo.segment.getArriveLocation()) && MiscUtil.equals((Object)this.segment.getArriveTerminal(), (Object)segmentInfo.segment.getArriveTerminal()) && MiscUtil.equals((Object)this.segment.getBoard(), (Object)segmentInfo.segment.getBoard());
            }
            return this.segment == null && segmentInfo.segment == null;
        }
    }

    private static class ImageData {
        private final InputStream data;
        private final int width;
        private final int height;

        public ImageData(BinaryData data) {
            ByteArrayInputStream is = null;
            BufferedImage image = null;
            if (data != null && data.getData() != null) {
                is = new ByteArrayInputStream(data.getData());
                try {
                    image = ImageIO.read(is);
                    ((InputStream)is).reset();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.data = is;
            this.width = image != null ? image.getWidth() : 0;
            this.height = image != null ? image.getHeight() : 0;
        }

        public InputStream getData() {
            return this.data;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

