/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.export;

import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.export.DictionaryCompressedData;
import com.gridnine.xtrip.common.model.export.EntityCompressedData;
import com.gridnine.xtrip.common.model.export.ExportCategory;
import com.gridnine.xtrip.common.model.export.ExportHelper;
import com.gridnine.xtrip.common.model.export.ibecorp.IBEBookingXmlCommonExportSettings;
import com.gridnine.xtrip.common.model.export.ibecorp.IBEBookingXmlExportSettings;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.server.ibecorp.export.IBEBookingXmlExportHelper;
import com.gridnine.xtrip.server.model.export.BaseExportSettingsWithCommonSettingsRootEntityExportHandler;
import java.util.List;

public class IBEBookingXmlExportHandler
extends BaseExportSettingsWithCommonSettingsRootEntityExportHandler<BookingFile, IBEBookingXmlExportSettings, IBEBookingXmlCommonExportSettings> {
    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public ExportCategory getExportCategory() {
        return ExportCategory.IBE_BOOKING_XML;
    }

    public Class<IBEBookingXmlExportSettings> getSettingsClass() {
        return IBEBookingXmlExportSettings.class;
    }

    protected byte[] export(EntityContainer<BookingFile> object, IBEBookingXmlExportSettings settings, IBEBookingXmlCommonExportSettings commonSettings, List<Message> messages) throws Exception {
        return IBEBookingXmlExportHelper.export((BookingFile)object.getEntity(), ExportHelper.standardResolver, settings, messages);
    }

    protected boolean accept(BookingFile bf, IBEBookingXmlExportSettings settings, IBEBookingXmlCommonExportSettings commonSettings) {
        ReservationStatus status = CommonIbecorpHelper.getReservationStatus((BookingFile)bf);
        if (null == status) {
            return false;
        }
        switch (status) {
            case CANCELED: 
            case ISSUED: 
            case BOOKING: {
                return settings.getAgency().equals((Object)bf.getAgency());
            }
        }
        return false;
    }

    public Class<IBEBookingXmlCommonExportSettings> getCommonSettingsClass() {
        return IBEBookingXmlCommonExportSettings.class;
    }

    @Deprecated
    protected byte[] export(EntityCompressedData object, EntityCompressedData previousVersion, List<EntityCompressedData> referencedEntities, List<DictionaryCompressedData> referencedDictionaries, IBEBookingXmlExportSettings settings, IBEBookingXmlCommonExportSettings commonSettings, List<Message> messages) throws Exception {
        return null;
    }
}

