/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.export;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationRemark;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.export.ExportHelper;
import com.gridnine.xtrip.common.model.export.ibecorp.IBEBookingXmlExportSettings;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.slf4j.LoggerFactory;

public class IBEBookingXmlExportHelper {
    private static final Locale localeRu = new Locale("ru");
    private static final CodeTranslator codeTranslator = new CodeTranslator(new String[]{CodeSystem.IATA.name()});
    private static NumberFormat priceFormat;
    static final JAXBContext JAXB_CONTEXT;
    private static final String dtf = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String df = "yyyy-MM-dd";

    private static GeoLocationWrapper getLocation(DictionaryReference<GeoLocation> ref) {
        GeoLocation loc = (GeoLocation)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(ref);
        if (loc == null) {
            return null;
        }
        GeoLocationWrapper wrapper = new GeoLocationWrapper();
        DictionaryCache dictionaryCache = (DictionaryCache)Environment.getPublished(DictionaryCache.class);
        wrapper.country = (Country)dictionaryCache.resolveReference(loc.getCountry());
        switch (loc.getType()) {
            case CITY: {
                wrapper.city = loc;
                break;
            }
            case AIRPORT: {
                wrapper.airport = loc;
            }
        }
        GeoLocation parent = loc;
        HashSet<GeoLocation> seen = new HashSet<GeoLocation>();
        while (parent != null && (parent = (GeoLocation)dictionaryCache.resolveReference(parent.getParent())) != null) {
            if (seen.contains(parent)) {
                LoggerFactory.getLogger(IBEBookingXmlExportHelper.class).warn("cyclic parents detected for GEO location " + loc);
                break;
            }
            seen.add(parent);
            if (wrapper.country == null) {
                wrapper.country = (Country)dictionaryCache.resolveReference(parent.getCountry());
            }
            switch (parent.getType()) {
                case CITY: {
                    wrapper.city = parent;
                    break;
                }
                case AIRPORT: {
                    wrapper.airport = parent;
                }
            }
        }
        return wrapper;
    }

    private static BigDecimal getTaxes(Product prod) {
        BigDecimal result = BigDecimal.ZERO;
        for (Tax tax : prod.getTaxes()) {
            result = result.add(tax.getEquivalentAmount());
        }
        return result;
    }

    private static void exportTravellers(BookingFile bf, ReservationWrapper wrapper) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat(df);
        Reservation res = (Reservation)bf.getReservations().get(0);
        for (BaseProduct bp : res.getProducts()) {
            if (!(bp instanceof Product)) continue;
            Product prod = (Product)bp;
            Traveller trav = prod.getTraveller();
            TravellerWrapper traveller = new TravellerWrapper();
            wrapper.travellers.travellers.add(traveller);
            traveller.lastname = trav.getPassport().getLastName();
            traveller.firstname = trav.getPassport().getFirstName();
            traveller.gender.value = trav.getPassport().getGender().toString();
            traveller.gender.code = trav.getPassport().getGender().name();
            StringBuilder ticketNumber = new StringBuilder(TextUtil.nonNullStr((String)prod.getCarrierNumber()) + TextUtil.nonNullStr((String)prod.getSystemNumber()));
            traveller.ticket = ticketNumber.toString();
            if (trav.getPassport().getBirthday() != null) {
                traveller.birthdate = dateFormat.format(trav.getPassport().getBirthday());
            }
            if (trav.getPassport().getCitizenship() != null) {
                traveller.citizenship = new AirItemWrapper();
                traveller.citizenship.value = DictHelper.toString((DictionaryReference)trav.getPassport().getCitizenship());
                traveller.citizenship.code = codeTranslator.getNativeCode(trav.getPassport().getCitizenship());
            }
            if (trav.getPassport().getType() != null) {
                traveller.doctype = new AirItemWrapper();
                traveller.doctype.value = trav.getPassport().getType().toString();
                traveller.doctype.code = trav.getPassport().getType().name();
            }
            if (trav.getPassport().getOriginCountry() != null) {
                traveller.doccountry = new AirItemWrapper();
                traveller.doccountry.value = DictHelper.toString((DictionaryReference)trav.getPassport().getOriginCountry());
                traveller.doccountry.code = codeTranslator.getNativeCode(trav.getPassport().getOriginCountry());
            }
            for (Communication comm : trav.getCommunications()) {
                CommunicationWrapper commWrapper = new CommunicationWrapper();
                traveller.communications.add(commWrapper);
                switch (comm.getType()) {
                    case EMAIL: {
                        commWrapper.type = "email";
                        commWrapper.value = comm.getSense();
                        break;
                    }
                    case CELL: 
                    case HOME_PHONE: 
                    case MOBILE: 
                    case WORK_PHONE: {
                        commWrapper.type = "phone";
                        commWrapper.value = IBEBookingXmlExportHelper.buildPhoneNumber(comm);
                        break;
                    }
                }
            }
            if (trav.getPassport().getExpired() != null) {
                traveller.docexpiry = dateFormat.format(trav.getPassport().getExpired());
            }
            traveller.docnum = trav.getPassport().getNumber();
            traveller.fare = priceFormat.format(AirProductHelper.getEquivalentFare((Product)prod).doubleValue());
            traveller.taxes = priceFormat.format(IBEBookingXmlExportHelper.getTaxes(prod).doubleValue());
            traveller.fees = priceFormat.format(GeneralProductHelper.calculateFee((BaseProduct)prod, (ContractType)ContractType.CLIENT).doubleValue());
            Commission commission = BookingHelper.getTotalVendorCommission((Product)prod);
            if (commission == null) continue;
            if (commission.getRate() != null) {
                traveller.commissionRate = priceFormat.format(commission.getRate());
                continue;
            }
            traveller.commissionValue = priceFormat.format(commission.getEquivalentAmount().doubleValue());
        }
    }

    private static void exportSegments(BookingFile bf, ReservationWrapper wrapper) {
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat(dtf);
        boolean segmentsAdded = false;
        Reservation res = (Reservation)bf.getReservations().get(0);
        for (BaseProduct bp : res.getProducts()) {
            if (!(bp instanceof Product)) continue;
            Product prod = (Product)bp;
            if (segmentsAdded) continue;
            if (prod.getCarrier() != null) {
                wrapper.carrier = new AirItemWrapper();
                wrapper.carrier.value = DictHelper.toStringWithL10n((DictionaryReference)prod.getCarrier(), (Locale)localeRu);
                wrapper.carrier.code = codeTranslator.getNativeCode(prod.getCarrier());
            }
            for (SegmentTariff st : prod.getSegmentTariffs()) {
                for (Segment s : st.getSegments()) {
                    SegmentWrapper segment = new SegmentWrapper();
                    wrapper.segments.segments.add(segment);
                    GeoLocationWrapper from = IBEBookingXmlExportHelper.getLocation((DictionaryReference<GeoLocation>)s.getDepartureLocation());
                    if (from.airport != null) {
                        segment.departureAirport = new AirItemWrapper();
                        segment.departureAirport.value = DictHelper.toStringWithL10n((DictionaryReference)from.airport.toReference(), (Locale)localeRu);
                        segment.departureAirport.code = codeTranslator.getNativeCode((DictionaryReference)from.airport.toReference());
                    }
                    if (from.city != null) {
                        segment.departureCity = new AirItemWrapper();
                        segment.departureCity.value = DictHelper.toStringWithL10n((DictionaryReference)from.city.toReference(), (Locale)localeRu);
                        segment.departureCity.code = codeTranslator.getNativeCode((DictionaryReference)from.city.toReference());
                    }
                    if (from.country != null) {
                        segment.departureCountry = new AirItemWrapper();
                        segment.departureCountry.value = DictHelper.toStringWithL10n((DictionaryReference)from.country.toReference(), (Locale)localeRu);
                        segment.departureCountry.code = codeTranslator.getNativeCode((DictionaryReference)from.country.toReference());
                    }
                    segment.departureTerminal = s.getDepartTerminal();
                    GeoLocationWrapper to = IBEBookingXmlExportHelper.getLocation((DictionaryReference<GeoLocation>)s.getArriveLocation());
                    if (to.airport != null) {
                        segment.arrivalAirport = new AirItemWrapper();
                        segment.arrivalAirport.value = DictHelper.toStringWithL10n((DictionaryReference)to.airport.toReference(), (Locale)localeRu);
                        segment.arrivalAirport.code = codeTranslator.getNativeCode((DictionaryReference)to.airport.toReference());
                    }
                    if (to.city != null) {
                        segment.arrivalCity = new AirItemWrapper();
                        segment.arrivalCity.value = DictHelper.toStringWithL10n((DictionaryReference)to.city.toReference(), (Locale)localeRu);
                        segment.arrivalCity.code = codeTranslator.getNativeCode((DictionaryReference)to.city.toReference());
                    }
                    if (to.country != null) {
                        segment.arrivalCountry = new AirItemWrapper();
                        segment.arrivalCountry.value = DictHelper.toStringWithL10n((DictionaryReference)to.country.toReference(), (Locale)localeRu);
                        segment.arrivalCountry.code = codeTranslator.getNativeCode((DictionaryReference)to.country.toReference());
                    }
                    segment.arrivalTerminal = s.getArriveTerminal();
                    segment.board = new AirItemWrapper();
                    segment.board.value = DictHelper.toStringWithL10n((DictionaryReference)s.getBoard(), (Locale)localeRu);
                    segment.board.code = codeTranslator.getNativeCode(s.getBoard());
                    segment.departure = dateTimeFormat.format(s.getStartDate());
                    segment.arrival = dateTimeFormat.format(s.getEndDate());
                    segment.marketing = new Marketing();
                    segment.marketing.airline = new AirItemWrapper();
                    segment.marketing.airline.value = DictHelper.toStringWithL10n((DictionaryReference)s.getAirline(), (Locale)localeRu);
                    segment.marketing.airline.code = codeTranslator.getNativeCode(s.getAirline());
                    segment.marketing.flightno = s.getFlightNo();
                    if (s.getCodeShareCarrier() != null) {
                        segment.operating = new Operating();
                        segment.operating.airline = new AirItemWrapper();
                        segment.operating.airline.value = DictHelper.toStringWithL10n((DictionaryReference)s.getCodeShareCarrier(), (Locale)localeRu);
                        segment.operating.airline.code = codeTranslator.getNativeCode(s.getCodeShareCarrier());
                    }
                    ClassOfService classOfService = DictHelper.findClassOfService((Segment)s, (Date)prod.getIssueDate());
                    segment.srvClass = new AirItemWrapper();
                    segment.srvClass.value = classOfService.toString();
                    segment.srvClass.code = s.getClassOfSvcCode();
                }
            }
            segmentsAdded = true;
        }
    }

    private static ReservationWrapper exportReservarion(BookingFile bf) throws Exception {
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat(dtf);
        ReservationWrapper booking = new ReservationWrapper();
        Reservation res = (Reservation)bf.getReservations().get(0);
        for (BaseProduct product : res.getProducts()) {
            if (!(product instanceof Product)) continue;
            for (ProductFop fop : AirProductHelper.getVendorContractRelation((Product)((Product)product)).getFops()) {
                FOPWrapper fopWrapper = new FOPWrapper();
                fopWrapper.name = fop.getType().toString();
                booking.fops.fops.add(fopWrapper);
            }
        }
        booking.pnr = CommonReservationGdsNameInfoHelper.getExport1CRecordLocator((Reservation)res);
        booking.timelimit = dateTimeFormat.format(res.getTimeLimit());
        StatusWrapper status = new StatusWrapper();
        ReservationStatus rs = CommonIbecorpHelper.getReservationStatus((BookingFile)bf);
        status.status = rs.toString();
        status.code = rs.name();
        booking.status = status;
        for (ReservationRemark r : res.getReservationRemarks()) {
            RemarkWrapper remark = new RemarkWrapper();
            remark.qualifier = r.getQualifier();
            remark.remarkText = r.getRemarkText();
            booking.reservationRemarks.items.add(remark);
        }
        IBEBookingXmlExportHelper.exportSegments(bf, booking);
        IBEBookingXmlExportHelper.exportTravellers(bf, booking);
        return booking;
    }

    private static String buildPhoneNumber(Communication comm) {
        StringBuilder phone = new StringBuilder(32);
        if (!TextUtil.isBlank((String)comm.getCountryCode())) {
            phone.append(comm.getCountryCode());
        }
        if (!TextUtil.isBlank((String)comm.getCityCode())) {
            phone.append(comm.getCityCode());
        }
        if (!TextUtil.isBlank((String)comm.getInternalNumber())) {
            phone.append(comm.getInternalNumber());
        }
        if (phone.length() == 0) {
            phone.append(comm.getSense());
        }
        return phone.toString();
    }

    public static byte[] export(BookingFile bf, ExportHelper.ObjectResolver resolver, IBEBookingXmlExportSettings settings, List<Message> messages) throws Exception {
        Marshaller marshaller = JAXB_CONTEXT.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        marshaller.marshal((Object)IBEBookingXmlExportHelper.exportReservarion(bf), (OutputStream)baos);
        return baos.toByteArray();
    }

    static {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        priceFormat = new DecimalFormat("0.00", dfs);
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{ReservationWrapper.class, StatusWrapper.class, TravellerWrapper.class, Gender.class, CommunicationWrapper.class, SegmentWrapper.class, AirItemWrapper.class, Marketing.class, Operating.class, TravellersWrapper.class, SegmentsWrapper.class, RemarkWrapper.class, ReservationRemarkWrapper.class});
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    static class GeoLocationWrapper {
        Country country;
        GeoLocation city;
        GeoLocation airport;

        GeoLocationWrapper() {
        }
    }

    static class Gender {
        @XmlAttribute(name="code")
        String code;
        @XmlValue
        String value;

        Gender() {
        }
    }

    static class CommunicationWrapper {
        @XmlAttribute
        String type;
        @XmlValue
        String value;

        CommunicationWrapper() {
        }
    }

    @XmlType(name="traveller", propOrder={"lastname", "firstname", "gender", "ticket", "birthdate", "citizenship", "doctype", "doccountry", "communications", "docexpiry", "docnum", "fare", "taxes", "fees", "commissionRate", "commissionValue"})
    static class TravellerWrapper {
        @XmlElement
        String lastname;
        @XmlElement
        String firstname;
        @XmlElement
        Gender gender = new Gender();
        @XmlElement
        String ticket;
        @XmlElement
        String birthdate;
        @XmlElement
        AirItemWrapper citizenship;
        @XmlElement
        AirItemWrapper doctype;
        @XmlElement
        AirItemWrapper doccountry;
        @XmlElement(name="contact")
        List<CommunicationWrapper> communications = new LinkedList<CommunicationWrapper>();
        @XmlElement
        String docexpiry;
        @XmlElement
        String docnum;
        @XmlElement
        String fare;
        @XmlElement
        String taxes;
        @XmlElement
        String fees;
        @XmlElement(name="commission_rate")
        String commissionRate;
        @XmlElement(name="commission_value")
        String commissionValue;

        TravellerWrapper() {
        }
    }

    static class StatusWrapper {
        @XmlValue
        String status;
        @XmlAttribute(name="code")
        String code;

        StatusWrapper() {
        }
    }

    static class AirItemWrapper {
        @XmlValue
        String value;
        @XmlAttribute
        String code;

        AirItemWrapper() {
        }
    }

    static class Operating {
        @XmlElement
        AirItemWrapper airline;

        Operating() {
        }
    }

    @XmlType(propOrder={"airline", "flightno"})
    static class Marketing {
        @XmlElement
        AirItemWrapper airline;
        @XmlElement
        String flightno;

        Marketing() {
        }
    }

    @XmlType(propOrder={"departureAirport", "departureCity", "departureCountry", "departureTerminal", "arrivalAirport", "arrivalCity", "arrivalCountry", "arrivalTerminal", "board", "departure", "arrival", "marketing", "operating", "srvClass"})
    static class SegmentWrapper {
        @XmlElement(name="departure_airport")
        AirItemWrapper departureAirport;
        @XmlElement(name="departure_city")
        AirItemWrapper departureCity;
        @XmlElement(name="departure_country")
        AirItemWrapper departureCountry;
        @XmlElement(name="departure_terminal")
        String departureTerminal;
        @XmlElement(name="arrival_airport")
        AirItemWrapper arrivalAirport;
        @XmlElement(name="arrival_city")
        AirItemWrapper arrivalCity;
        @XmlElement(name="arrival_country")
        AirItemWrapper arrivalCountry;
        @XmlElement(name="arrival_terminal")
        String arrivalTerminal;
        @XmlElement
        AirItemWrapper board;
        @XmlElement
        String departure;
        @XmlElement
        String arrival;
        @XmlElement
        Marketing marketing;
        @XmlElement
        Operating operating;
        @XmlElement(name="class")
        AirItemWrapper srvClass;

        SegmentWrapper() {
        }
    }

    static class SegmentsWrapper {
        @XmlElement(name="segment")
        List<SegmentWrapper> segments = new LinkedList<SegmentWrapper>();

        SegmentsWrapper() {
        }
    }

    static class TravellersWrapper {
        @XmlElement(name="traveller")
        List<TravellerWrapper> travellers = new LinkedList<TravellerWrapper>();

        TravellersWrapper() {
        }
    }

    static class RemarkWrapper {
        @XmlElement
        String qualifier;
        @XmlElement
        String remarkText;

        RemarkWrapper() {
        }
    }

    static class FOPWrapper {
        @XmlElement
        String name;

        FOPWrapper() {
        }
    }

    static class FOPsWrapper {
        @XmlElement(name="fop")
        List<FOPWrapper> fops = new LinkedList<FOPWrapper>();

        FOPsWrapper() {
        }
    }

    static class ReservationRemarkWrapper {
        @XmlElement(name="remark")
        List<RemarkWrapper> items = new LinkedList<RemarkWrapper>();

        ReservationRemarkWrapper() {
        }
    }

    @XmlRootElement(name="reservation")
    @XmlType(propOrder={"pnr", "timelimit", "status", "fops", "reservationRemarks", "carrier", "segments", "travellers"})
    static class ReservationWrapper {
        @XmlElement
        String pnr;
        @XmlElement
        String timelimit;
        @XmlElement
        StatusWrapper status;
        @XmlElement(name="fops")
        FOPsWrapper fops = new FOPsWrapper();
        @XmlElement(name="reservation_remarks")
        ReservationRemarkWrapper reservationRemarks = new ReservationRemarkWrapper();
        @XmlElement
        AirItemWrapper carrier;
        @XmlElement
        SegmentsWrapper segments = new SegmentsWrapper();
        @XmlElement
        TravellersWrapper travellers = new TravellersWrapper();

        ReservationWrapper() {
        }
    }
}

