/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.rest.AuthToken;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.server.fx.rpc.service.AuthServiceImpl;
import com.gridnine.xtrip.server.ibecorp.assets.SiteUserPreferences;
import com.gridnine.xtrip.server.ibecorp.common.rest.authorization.AuthorizationHelper;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import com.gridnine.xtrip.server.web.rest.AuthRestInterceptor;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class ExtApiV1AuthInterceptor
implements AuthRestInterceptor {
    private static HashSet<String> safePath = new HashSet();

    public void authorize(RestContext context, Map<String, Object> data) throws Exception {
        HttpServletRequest request = context.getRequest();
        try {
            Cookie[] cookies = request.getCookies();
            if (cookies == null || cookies.length == 0) {
                throw Xeption.forEndUser((String)"user not logged in", (Object[])new Object[0]);
            }
            AuthToken token = null;
            for (Cookie cookie : cookies) {
                if (!"IBECORP_B2B_AUTH_TOKEN_COOKIE".equals(cookie.getName())) continue;
                token = AuthToken.decode((String)cookie.getValue());
                break;
            }
            if (token == null) {
                throw Xeption.forEndUser((String)"user not logged in", (Object[])new Object[0]);
            }
            if (token.isExpired()) {
                request.getSession().invalidate();
                request.setAttribute("RETAIN_REQUEST_TOKEN", (Object)Boolean.FALSE);
                throw Xeption.forEndUser((String)"auth token expired", (Object[])new Object[0]);
            }
            if (!AuthServiceImpl.validateAuthToken((Serializable)((Object)token.getData()))) {
                throw Xeption.forEndUser((String)"authorization failed", (Object[])new Object[0]);
            }
            EntityContainer<Person> authUser = AuthorizationHelper.findProfileByLogin(AuthServiceImpl.extractUserLoginFromToken((Serializable)((Object)token.getData())));
            data.put(IBusIbecorpContextKeys.AUTHORIZED_USER.name(), authUser.toReference());
            data.put(IBusIbecorpContextKeys.CURRENT_ORGANIZATION.name(), ExtApiV1AuthInterceptor.defineCurrentOrganization(authUser));
            request.setAttribute("AUTH_DATA", (Object)token.getData());
        }
        catch (Exception e) {
            if (e instanceof Xeption && safePath.stream().anyMatch(safeRoute -> request.getRequestURI().contains((CharSequence)safeRoute))) {
                return;
            }
            context.setStatus(403);
            throw e;
        }
    }

    private static EntityReference<Organization> defineCurrentOrganization(EntityContainer<Person> authUser) {
        EntityReference<Organization> result;
        List employments = ((Person)authUser.getEntity()).getEmployments();
        if (!employments.isEmpty()) {
            if (employments.size() > 1) {
                SiteUserPreferences preferences = (SiteUserPreferences)AssetsStorage.get().find(SiteUserPreferences.class, "loginName", (Object)((Person)authUser.getEntity()).getLoginName());
                if (preferences == null) {
                    throw Xeption.forDeveloper((String)"\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u043e\u0441\u043d\u043e\u0432\u043d\u044b\u0445 \u043c\u0435\u0441\u0442 \u0440\u0430\u0431\u043e\u0442\u044b \u0434\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f {0}, \u043d\u043e \u043d\u0438 \u043e\u0434\u043d\u043e \u043d\u0435 \u0431\u044b\u043b\u043e \u0432\u044b\u0431\u0440\u0430\u043d\u043e \u043f\u0440\u0438 \u0432\u0445\u043e\u0434\u0435 \u043d\u0430 \u0441\u0430\u0439\u0442", (Object[])new Object[]{((Person)authUser.getEntity()).getLoginName()});
                }
                result = preferences.getOrganizationReference();
            } else {
                if (!((PersonEmployment)employments.get(0)).isMainEmployment()) {
                    throw Xeption.forAdmin((String)"\u041c\u0435\u0441\u0442\u043e \u0440\u0430\u0431\u043e\u0442\u044b \u0434\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u043d\u0435 \u043e\u0442\u043c\u0435\u0447\u0435\u043d\u043e \u043a\u0430\u043a \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0435.", (Object[])new Object[0]);
                }
                result = ((PersonEmployment)employments.get(0)).getOrganization();
            }
        } else {
            throw Xeption.forAdmin((String)"\u041d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043c\u0435\u0441\u0442\u043e \u0440\u0430\u0431\u043e\u0442\u044b \u0434\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f {0}", (Object[])new Object[]{((Person)authUser.getEntity()).getLoginName()});
        }
        return result;
    }

    static {
        safePath.add("getSiteSettings");
        safePath.add("getCountries");
        safePath.add("getLocations");
    }
}

