/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1;

import com.gridnine.xtrip.common.gds.model.DocaInformation;
import com.gridnine.xtrip.common.gds.model.DocoInformation;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.BookingAirlineBonusCard;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.common.components.Rate;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.ExtApiV1BonusCard;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.ExtApiV1DocaInfo;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.ExtApiV1DocoInfo;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.ExtApiV1Money;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.ExtApiV1Phone;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.ExtApiV1Rate;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Comparator;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ExtApiV1CommonConverterHelper {
    public static final Comparator<ExtApiV1Money> MONEY_COMPARATOR = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.getAmount() == 0.0 || o2.getAmount() == 0.0) {
            return Double.compare(o1.getAmount(), o2.getAmount());
        }
        if (o1.getCurrencyCode() == null || o2.getCurrencyCode() == null) {
            throw new IllegalStateException("Currency code is null");
        }
        if (o1.getCurrencyCode().equals(o2.getCurrencyCode())) {
            return Double.compare(o1.getAmount(), o2.getAmount());
        }
        throw new IllegalStateException("Mismatch currencies");
    };

    public static ExtApiV1Money convertMoney2Rest(BigDecimal amount, String currency) {
        ExtApiV1Money result = new ExtApiV1Money();
        result.setAmount(amount.setScale(Currency.getInstance(currency).getDefaultFractionDigits(), RoundingMode.HALF_UP).doubleValue());
        result.setCurrencyCode(currency);
        result.setCurrency((String)MiscUtil.findByLocale((Map)DictHelper.getCurrencyInfoByAnyCode((String)currency).getTranslations(), (Locale)LocaleHelper.getCurrentLocale()));
        return result;
    }

    public static ExtApiV1Money convertMoney2Rest(Money money) {
        ExtApiV1Money result = new ExtApiV1Money();
        if (money != null) {
            if (money.getValue() != null) {
                result.setAmount((double)money.getValue().setScale(0, RoundingMode.HALF_DOWN).intValue());
            }
            if (money.getCurrency() != null) {
                result.setCurrencyCode(money.getCurrency());
                result.setCurrency((String)MiscUtil.findByLocale((Map)DictHelper.getCurrencyInfoByAnyCode((String)money.getCurrency()).getTranslations(), (Locale)LocaleHelper.getCurrentLocale()));
            }
        }
        return result;
    }

    public static Collection<ExtApiV1Rate> convertRatesToRest(List<Rate> rates) {
        return rates.stream().map(rate -> {
            ExtApiV1Rate result = new ExtApiV1Rate();
            result.setTotal(ExtApiV1CommonConverterHelper.convertMoney2Rest(rate.getRate(), rate.getCurrency().getCode()));
            result.setSymbol(((CurrencyInfo)DictionaryCache.get().resolveReference(rate.getCurrency())).getDisplaySymbol());
            return result;
        }).collect(Collectors.toList());
    }

    public static <T extends Communication> T convertRest2PhoneCommunication(ExtApiV1Phone phone, CommunicationType type, Supplier<T> supplier) {
        Communication result = (Communication)supplier.get();
        result.setType(type);
        result.setCountryCode(phone.getCountryCode());
        result.setCityCode(phone.getCityCode());
        result.setSense(phone.getNumber());
        return (T)result;
    }

    public static ExtApiV1Phone convertPhoneCommunication2Rest(Communication communication) {
        if (communication == null) {
            return null;
        }
        ExtApiV1Phone result = new ExtApiV1Phone();
        result.setCountryCode(communication.getCountryCode());
        result.setCityCode(communication.getCityCode());
        result.setNumber(communication.getSense());
        return result;
    }

    public static <T extends Communication> T convertRest2EmailCommunication(String email, Supplier<T> supplier) {
        Communication communication = (Communication)supplier.get();
        communication.setType(CommunicationType.EMAIL);
        communication.setSense(email);
        return (T)communication;
    }

    public static String convertEmailCommunication2Rest(Communication communication) {
        return communication.getSense();
    }

    public static BookingAirlineBonusCard convertRest2BonusCard(ExtApiV1BonusCard bonusCard) {
        BookingAirlineBonusCard card = new BookingAirlineBonusCard();
        card.setAirline(bonusCard.getAirline());
        card.setNumber(bonusCard.getNumber());
        return card;
    }

    public static <T> T findByLocale(Map<Locale, T> map, Locale locale) {
        Object temp = MiscUtil.findByLocale(map, (Locale)locale);
        if (temp == null) {
            temp = MiscUtil.findByLocale(map, (Locale)Locale.ENGLISH);
        }
        return (T)temp;
    }

    public static DocoInformation convertRest2DocoInformation(ExtApiV1DocoInfo docoInfo) {
        DocoInformation result = new DocoInformation();
        result.setPlaceOfBirthCountry(docoInfo.getPlaceOfBirthCountry());
        result.setPlaceOfBirthCity(docoInfo.getPlaceOfBirthCity());
        result.setPlaceOfBirthState(docoInfo.getPlaceOfBirthState());
        result.setVisaNumber(docoInfo.getVisaNumber());
        result.setVisaIssueDate(docoInfo.getVisaIssueDate().toDate());
        result.setVisaIssuePlace(docoInfo.getVisaIssuePlace());
        result.setVisaApplicableCountry(docoInfo.getVisaApplicableCountry());
        return result;
    }

    public static DocaInformation convertRest2DocaInformation(ExtApiV1DocaInfo docaInfo) {
        DocaInformation result = new DocaInformation();
        result.setCountry(docaInfo.getCountry());
        result.setStateProvince(docaInfo.getStateProvince());
        result.setCity(docaInfo.getCity());
        result.setStreet(docaInfo.getStreet());
        result.setZipPostalCode(docaInfo.getZipPostalCode());
        result.setType(docaInfo.getAddressType());
        return result;
    }
}

