/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.rest.AuthToken;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import com.gridnine.xtrip.server.web.rest.GenericRestInterceptorAdapter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.BooleanUtils;

public class ExtApiV1CommonInterceptor
extends GenericRestInterceptorAdapter {
    public static void updateAuthCookie(HttpServletRequest req, HttpServletResponse res) throws Exception {
        String authData = null;
        Enumeration en = req.getAttributeNames();
        while (en.hasMoreElements()) {
            if (!"AUTH_DATA".equals(en.nextElement())) continue;
            authData = (String)req.getAttribute("AUTH_DATA");
            break;
        }
        boolean retainRequestToken = BooleanUtils.toBooleanDefaultIfNull((Boolean)((Boolean)req.getAttribute("RETAIN_REQUEST_TOKEN")), (boolean)true);
        Cookie cookie = new Cookie("IBECORP_B2B_AUTH_TOKEN_COOKIE", "");
        cookie.setPath("/");
        if (TextUtil.isBlank((String)authData) && !retainRequestToken) {
            cookie.setMaxAge(0);
        } else if (!TextUtil.isBlank((String)authData)) {
            cookie.setMaxAge(-1);
            cookie.setValue(new AuthToken(authData).encode());
        } else {
            Optional<String> optValue = Arrays.stream((Object[])Optional.ofNullable(req.getCookies()).orElse(new Cookie[0])).filter(c -> "IBECORP_B2B_AUTH_TOKEN_COOKIE".equals(c.getName())).findFirst().map(Cookie::getValue).filter(value -> !TextUtil.isBlank((String)value));
            if (optValue.isPresent()) {
                cookie.setValue(optValue.get());
                cookie.setMaxAge(-1);
            } else {
                cookie.setMaxAge(0);
            }
        }
        res.addCookie(cookie);
    }

    public void after(RestContext context, Map<String, Object> data) throws Exception {
        boolean isUpdateToken;
        boolean bl = isUpdateToken = data.containsKey(IBusIbecorpContextKeys.UPDATE_TOKEN.name()) ? (Boolean)data.get(IBusIbecorpContextKeys.UPDATE_TOKEN.name()) : true;
        if (isUpdateToken) {
            ExtApiV1CommonInterceptor.updateAuthCookie(context.getRequest(), context.getResponse());
        }
    }

    public void before(RestContext context, Map<String, Object> data) throws Exception {
        Locale locale = CommonHelper.getRequestedLocale(context);
        ((LocaleManager)Environment.getPublished(LocaleManager.class)).setCurrentLocale(locale);
    }
}

