/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.DocaAddressType;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.BonusCardValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.DocaValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.DocoValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.PassportValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.PhoneValidationMessages;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.ExtApiV1BonusCard;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.ExtApiV1DocaInfo;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.ExtApiV1DocoInfo;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.ExtApiV1Passport;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.ExtApiV1Phone;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.joda.time.LocalDate;
import org.joda.time.Period;
import org.joda.time.ReadablePartial;

public final class ExtApiV1CommonValidationHelper {
    public static final Pattern EMAIL_ADDRESS_PATTERN = Pattern.compile("([0-9A-Za-z-_]+\\.)*[0-9A-Za-z-_]+@((([0-9A-Za-z-_]+\\.)+[A-Za-z]+)|(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}))");
    private static final Pattern NAME_PATTERN = Pattern.compile("([\\s\\p{Alpha}\u0410-\u042f\u0430-\u044f])*");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("\\d+");
    private static final Pattern ALPHA_AND_SPACES_PATTERN = Pattern.compile("([A-Za-z ])*");
    private static final Pattern ALPHA_NUMERIC_PATTERN = Pattern.compile("([0-9A-Za-z])*");
    private static final Pattern ALPHA_NUMERIC_AND_SPACES_PATTERN = Pattern.compile("([0-9A-Za-z ])*");

    public static boolean isValidName(String name, boolean isValidateLatinCharacters, Collection<ValidationMessage> validationMessages, ValidationMessage missingName, ValidationMessage nonLatinName, ValidationMessage illegalName, ValidationMessage containsSpaceName, ValidationMessage lengthLimitName) {
        if (TextUtil.isBlank((String)name)) {
            validationMessages.add(missingName);
            return false;
        }
        if (isValidateLatinCharacters && !ExtApiV1CommonValidationHelper.isLatinCharactersName(name)) {
            validationMessages.add(nonLatinName);
            return false;
        }
        if (!ExtApiV1CommonValidationHelper.isValidNameFormat(name)) {
            validationMessages.add(illegalName);
            return false;
        }
        if (ExtApiV1CommonValidationHelper.hasSpaces(name)) {
            validationMessages.add(containsSpaceName);
            return false;
        }
        if (!ExtApiV1CommonValidationHelper.isValidNameLength(name)) {
            validationMessages.add(lengthLimitName);
            return false;
        }
        return true;
    }

    public static boolean isLatinCharactersName(String name) {
        return name.chars().filter(c -> Character.isWhitespace(c) || c <= 127).findFirst().isPresent();
    }

    private static boolean isValidNameFormat(String name) {
        return NAME_PATTERN.matcher(name).matches();
    }

    private static boolean hasSpaces(String name) {
        return name.matches(".*\\s.*");
    }

    private static boolean isValidNameLength(String name) {
        return name.length() <= 63;
    }

    public static Collection<ValidationMessage> isValidBirthDate(LocalDate date) {
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        if (Objects.isNull(date)) {
            validationMessages.add(PassportValidationMessages.getMissingBirthDate());
            return validationMessages;
        }
        Period period = new Period((ReadablePartial)date, (ReadablePartial)LocalDate.now());
        int age = period.getYears();
        if (age < 0 || age > 150) {
            validationMessages.add(PassportValidationMessages.getIllegalBirthDate());
        }
        return validationMessages;
    }

    public static boolean isNumber(String str) {
        return NUMBER_PATTERN.matcher(str).matches();
    }

    public static boolean isValidEmailFormat(String email) {
        return EMAIL_ADDRESS_PATTERN.matcher(email).matches();
    }

    private static String buildPhone2String(ExtApiV1Phone phone) {
        StringBuilder result = new StringBuilder();
        result.append(phone.getCountryCode()).append(phone.getCityCode()).append(phone.getNumber());
        return result.toString();
    }

    public static boolean isValidPhone(ExtApiV1Phone phone, Collection<ValidationMessage> messages) {
        if (TextUtil.isBlank((String)phone.getCountryCode())) {
            phone.getValidationContext().getCityCodeValidationMessages().add(PhoneValidationMessages.getMissingCountryCode());
        }
        if (TextUtil.isBlank((String)phone.getCityCode())) {
            phone.getValidationContext().getCityCodeValidationMessages().add(PhoneValidationMessages.getMissingCityCode());
        }
        if (TextUtil.isBlank((String)phone.getNumber())) {
            phone.getValidationContext().getCityCodeValidationMessages().add(PhoneValidationMessages.getMissingNumber());
        }
        if (!ExtApiV1CommonValidationHelper.buildPhone2String(phone).chars().allMatch(Character::isDigit)) {
            messages.add(PhoneValidationMessages.getIllegalPhone());
        }
        return messages.isEmpty() && ValidationHelper.isValid((Validatable)phone);
    }

    public static boolean isRu(DictionaryReference<Country> citizenship) {
        return "RU".equals(citizenship.getCode());
    }

    public static boolean isUa(DictionaryReference<Country> citizenship) {
        return "UA".equals(citizenship.getCode());
    }

    public static LocalDate calculateExpiredDate(ExtApiV1Passport passport) {
        LocalDate result;
        if (ExtApiV1CommonValidationHelper.isUa((DictionaryReference<Country>)passport.getCitizenship())) {
            result = new LocalDate(2099, 12, 31);
        } else {
            Period period = new Period((ReadablePartial)passport.getBirthDate(), (ReadablePartial)LocalDate.now());
            int age = period.getYears();
            result = new LocalDate((Object)passport.getBirthDate());
            result = age < 21 ? result.plusYears(21) : (age < 45 ? result.plusYears(45) : result.plusYears(120));
            result.plusDays(40);
        }
        return result;
    }

    public static boolean isValidBonusCard(ExtApiV1BonusCard bonusCard, Flight gdsFlight) {
        if (bonusCard.getAirline() == null) {
            bonusCard.getValidationContext().getAirlineValidationMessages().add(BonusCardValidationMessages.getIllegalBonusCard());
            return false;
        }
        if (TextUtil.isBlank((String)bonusCard.getNumber())) {
            bonusCard.getValidationContext().getNumberValidationMessages().add(BonusCardValidationMessages.getIllegalBonusCard());
            return false;
        }
        Set airlines = FlightHelper.getFlightSegmentsStream((Flight)gdsFlight).flatMap(s -> {
            HashSet<DictionaryReference> carriers = new HashSet<DictionaryReference>();
            carriers.add(s.getAirline());
            carriers.add(s.getAirline());
            return carriers.stream();
        }).collect(Collectors.toSet());
        if (!DictHelper.validateAlliances((DictionaryReference)bonusCard.getAirline(), airlines)) {
            bonusCard.getValidationContext().getAirlineValidationMessages().add(BonusCardValidationMessages.getIllegalBonusCard());
            bonusCard.getValidationContext().getNumberValidationMessages().add(BonusCardValidationMessages.getIllegalBonusCard());
            return false;
        }
        return true;
    }

    public static boolean hasBonusCard(ExtApiV1BonusCard bonusCard) {
        return bonusCard != null && (Objects.nonNull(bonusCard.getAirline()) || !TextUtil.isBlank((String)bonusCard.getNumber()));
    }

    public static void validateDocoInfo(ExtApiV1DocoInfo docoInfo) {
        boolean emptyVisaIssuePlace;
        boolean emptyVisaNumber;
        ExtApiV1CommonValidationHelper.isEmptyDocoDocaField(docoInfo.getPlaceOfBirthCountry(), false, (Collection<ValidationMessage>)docoInfo.getValidationContext().getPlaceOfBirthCountryValidationMessages(), DocoValidationMessages.getMissingPlaceOfBirthCountry());
        ExtApiV1CommonValidationHelper.isEmptyDocoDocaField(docoInfo.getVisaApplicableCountry(), docoInfo.isVisa(), (Collection<ValidationMessage>)docoInfo.getValidationContext().getVisaApplicableCountryValidationMessages(), DocoValidationMessages.getMissingVisaApplicableCountry());
        ExtApiV1CommonValidationHelper.isEmptyDocoDocaField(docoInfo.getVisaIssueDate(), docoInfo.isVisa(), (Collection<ValidationMessage>)docoInfo.getValidationContext().getVisaIssueDateValidationMessages(), DocoValidationMessages.getMissingVisaIssueDate());
        boolean emptyPlaceOfBirthCity = ExtApiV1CommonValidationHelper.isEmptyDocoDocaField(docoInfo.getPlaceOfBirthCity(), !docoInfo.isVisa(), (Collection<ValidationMessage>)docoInfo.getValidationContext().getPlaceOfBirthCityValidationMessages(), DocoValidationMessages.getMissingPlaceOfBirthCity());
        if (!emptyPlaceOfBirthCity) {
            ExtApiV1CommonValidationHelper.isIllegalDocoDocaField(docoInfo.getPlaceOfBirthCity(), ALPHA_AND_SPACES_PATTERN, docoInfo.getValidationContext().getPlaceOfBirthCityValidationMessages(), DocoValidationMessages.getIllegalPlaceOfBirthCity());
            ExtApiV1CommonValidationHelper.isTooLongDocoDocaField(docoInfo.getPlaceOfBirthCity(), 30, docoInfo.getValidationContext().getPlaceOfBirthCityValidationMessages(), DocoValidationMessages.getTooLongPlaceOfBirthCity());
        }
        if (!(emptyVisaNumber = ExtApiV1CommonValidationHelper.isEmptyDocoDocaField(docoInfo.getVisaNumber(), docoInfo.isVisa(), (Collection<ValidationMessage>)docoInfo.getValidationContext().getVisaNumberValidationMessages(), DocoValidationMessages.getMissingVisaNumber()))) {
            ExtApiV1CommonValidationHelper.isIllegalDocoDocaField(docoInfo.getVisaNumber(), ALPHA_NUMERIC_PATTERN, docoInfo.getValidationContext().getVisaNumberValidationMessages(), DocoValidationMessages.getIllegalVisaNumber());
            ExtApiV1CommonValidationHelper.isTooLongDocoDocaField(docoInfo.getVisaNumber(), 15, docoInfo.getValidationContext().getVisaNumberValidationMessages(), DocoValidationMessages.getTooLongVisaNumber());
        }
        if (!(emptyVisaIssuePlace = ExtApiV1CommonValidationHelper.isEmptyDocoDocaField(docoInfo.getVisaIssuePlace(), docoInfo.isVisa(), (Collection<ValidationMessage>)docoInfo.getValidationContext().getVisaIssuePlaceValidationMessages(), DocoValidationMessages.getMissingVisaIssuePlace()))) {
            ExtApiV1CommonValidationHelper.isIllegalDocoDocaField(docoInfo.getVisaIssuePlace(), ALPHA_AND_SPACES_PATTERN, docoInfo.getValidationContext().getVisaIssuePlaceValidationMessages(), DocoValidationMessages.getIllegalVisaIssuePlace());
            ExtApiV1CommonValidationHelper.isTooLongDocoDocaField(docoInfo.getVisaIssuePlace(), 35, docoInfo.getValidationContext().getVisaIssuePlaceValidationMessages(), DocoValidationMessages.getTooLongVisaIssuePlace());
        }
    }

    public static void validateDocaInfo(ExtApiV1DocaInfo docaInfo) {
        boolean emptyZipPostalCode;
        boolean emptyStreet;
        boolean emptyCity;
        ExtApiV1CommonValidationHelper.isEmptyDocoDocaField(docaInfo.getCountry(), true, (Collection<ValidationMessage>)docaInfo.getValidationContext().getCountryValidationMessages(), DocaValidationMessages.getMissingCountry());
        boolean emptyStageProvince = ExtApiV1CommonValidationHelper.isEmptyDocoDocaField(docaInfo.getStateProvince(), docaInfo.getAddressType() == DocaAddressType.DESTINATION, (Collection<ValidationMessage>)docaInfo.getValidationContext().getStateProvinceValidationMessages(), DocaValidationMessages.getMissingStateProvince());
        if (!emptyStageProvince) {
            ExtApiV1CommonValidationHelper.isIllegalDocoDocaField(docaInfo.getStateProvince(), ALPHA_AND_SPACES_PATTERN, docaInfo.getValidationContext().getStateProvinceValidationMessages(), DocaValidationMessages.getIllegalStateProvince());
            ExtApiV1CommonValidationHelper.isTooLongDocoDocaField(docaInfo.getStateProvince(), 35, docaInfo.getValidationContext().getStateProvinceValidationMessages(), DocaValidationMessages.getTooLongStateProvince());
        }
        if (!(emptyCity = ExtApiV1CommonValidationHelper.isEmptyDocoDocaField(docaInfo.getCity(), docaInfo.getAddressType() == DocaAddressType.DESTINATION, (Collection<ValidationMessage>)docaInfo.getValidationContext().getCityValidationMessages(), DocaValidationMessages.getIllegalCity()))) {
            ExtApiV1CommonValidationHelper.isIllegalDocoDocaField(docaInfo.getCity(), ALPHA_AND_SPACES_PATTERN, docaInfo.getValidationContext().getCityValidationMessages(), DocaValidationMessages.getIllegalCity());
            ExtApiV1CommonValidationHelper.isTooLongDocoDocaField(docaInfo.getCity(), 35, docaInfo.getValidationContext().getCityValidationMessages(), DocaValidationMessages.getTooLongCity());
        }
        if (!(emptyStreet = ExtApiV1CommonValidationHelper.isEmptyDocoDocaField(docaInfo.getStreet(), docaInfo.getAddressType() == DocaAddressType.DESTINATION, (Collection<ValidationMessage>)docaInfo.getValidationContext().getStreetValidationMessages(), DocaValidationMessages.getMissingStreet()))) {
            ExtApiV1CommonValidationHelper.isIllegalDocoDocaField(docaInfo.getStreet(), ALPHA_NUMERIC_AND_SPACES_PATTERN, docaInfo.getValidationContext().getStreetValidationMessages(), DocaValidationMessages.getIllegalStreet());
            ExtApiV1CommonValidationHelper.isTooLongDocoDocaField(docaInfo.getStreet(), 35, docaInfo.getValidationContext().getStreetValidationMessages(), DocaValidationMessages.getTooLongStreet());
        }
        if (!(emptyZipPostalCode = ExtApiV1CommonValidationHelper.isEmptyDocoDocaField(docaInfo.getZipPostalCode(), false, (Collection<ValidationMessage>)docaInfo.getValidationContext().getZipPostalCodeValidationMessages(), DocaValidationMessages.getMissingZipPostalCode()))) {
            ExtApiV1CommonValidationHelper.isIllegalDocoDocaField(docaInfo.getZipPostalCode(), ALPHA_NUMERIC_AND_SPACES_PATTERN, docaInfo.getValidationContext().getZipPostalCodeValidationMessages(), DocaValidationMessages.getIllegalZipPostalCode());
            ExtApiV1CommonValidationHelper.isTooLongDocoDocaField(docaInfo.getZipPostalCode(), 17, docaInfo.getValidationContext().getZipPostalCodeValidationMessages(), DocaValidationMessages.getTooLongZipPostalCode());
        }
    }

    private static boolean isEmptyDocoDocaField(Object field, boolean required, Collection<ValidationMessage> messages, ValidationMessage message) {
        if (field == null) {
            if (required) {
                messages.add(message);
            }
            return true;
        }
        return false;
    }

    private static boolean isEmptyDocoDocaField(String field, boolean required, Collection<ValidationMessage> messages, ValidationMessage message) {
        if (TextUtil.isBlank((String)field)) {
            if (required) {
                messages.add(message);
            }
            return true;
        }
        return false;
    }

    private static boolean isIllegalDocoDocaField(String field, Pattern pattern, Collection<ValidationMessage> messages, ValidationMessage message) {
        if (pattern != null && !pattern.matcher(field).matches()) {
            messages.add(message);
            return true;
        }
        return false;
    }

    private static boolean isTooLongDocoDocaField(String field, int maxLength, Collection<ValidationMessage> messages, ValidationMessage message) {
        if (field.length() > maxLength) {
            messages.add(message);
            return true;
        }
        return false;
    }
}

