/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.server.ibecorp.assets.SiteUserPreferences;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.authorization.ExtApiV1AuthorizationHelper;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import com.gridnine.xtrip.server.web.rest.AuthRestInterceptor;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ExtApiV1SalesContextAuthInterceptor
implements AuthRestInterceptor {
    public void authorize(RestContext context, Map<String, Object> data) throws Exception {
        SalesContext result;
        EntityReference authorizedUserRef = Objects.requireNonNull((EntityReference)data.get(IBusIbecorpContextKeys.AUTHORIZED_USER.name()));
        EntityReference siteRef = Objects.requireNonNull((EntityReference)data.get(IBusIbecorpContextKeys.SITE.name()));
        EntityContainer authorizedUserCtr = EntityStorage.get().resolve(authorizedUserRef);
        Person authorizedUser = (Person)authorizedUserCtr.getEntity();
        if (!ExtApiV1AuthorizationHelper.isValidB2BPersonTypes(authorizedUser)) {
            throw Xeption.forEndUser((String)String.format("User [%s] has not valid types [%s]", authorizedUser, CommonHelper.getEnumsCaptionsJoin(Arrays.stream(PersonType.values()).filter(ExtApiV1AuthorizationHelper.VALID_B2B_TYPES_CRITERION).collect(Collectors.toSet()))), (Object[])new Object[0]);
        }
        Set personTypes = authorizedUser.getTypes().stream().filter(ExtApiV1AuthorizationHelper.VALID_B2B_TYPES_CRITERION).collect(Collectors.toSet());
        PersonType personType = null;
        if (personTypes.size() > 1) {
            personType = this.findSelectedPersonType(authorizedUser.getLoginName());
        } else if (personTypes.size() == 1) {
            personType = (PersonType)personTypes.iterator().next();
        }
        if (personType == PersonType.AGENT) {
            result = ExtApiV1AuthorizationHelper.getB2BSalesContextForAgent((EntityReference<Person>)authorizedUserRef, (EntityReference<SMSite>)siteRef);
        } else if (personType == PersonType.PASSENGER) {
            result = ExtApiV1AuthorizationHelper.getB2BSalesContextForCorporant((EntityReference<Person>)authorizedUserRef, (EntityReference<SMSite>)siteRef);
        } else {
            throw Xeption.forEndUser((String)String.format("\u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043a\u043e\u0440\u043f\u043e\u0440\u0430\u0442\u043d\u0442\u0430 \u0438\u043b\u0438 \u0430\u0433\u0435\u043d\u0442\u0430, \u043f\u0440\u043e\u0444\u0438\u043b\u044c [%s] \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f", authorizedUser), (Object[])new Object[0]);
        }
        data.put(IBusMidofficeContextKeys.SALES_CONTEXT.name(), result);
    }

    private PersonType findSelectedPersonType(String loginName) {
        SiteUserPreferences preferences = (SiteUserPreferences)AssetsStorage.get().find(SiteUserPreferences.class, "loginName", (Object)loginName);
        if (preferences == null) {
            throw Xeption.forDeveloper((String)String.format("site preferences for loginName %s is not found", loginName), (Object[])new Object[0]);
        }
        return preferences.getPersonType();
    }
}

