/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.authorization.login;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibecorp.common.rest.authorization.AuthorizationHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.authorization.AuthorizationValidationMessages;
import com.gridnine.xtrip.server.ibecorp.externalApi.rest.extApiV1.model.authorization.ExtApiV1LoginParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;

public class ExtApiV1LoginProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ExtApiV1LoginParameters parameters = (ExtApiV1LoginParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        String password = parameters.getPassword();
        try {
            LogicalStorage.get().authorize(parameters.getLogin(), password.toCharArray());
            EntityContainer<Person> authorizedUser = null;
            try {
                EntityContainer<Person> loggedProfile = AuthorizationHelper.findProfileByLogin(parameters.getLogin());
                if (this.isAuthenticatedUser((Person)loggedProfile.getEntity())) {
                    authorizedUser = loggedProfile;
                }
                ctx.putObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER, (Object)authorizedUser.toReference());
            }
            catch (Exception e) {
                this.log.error(String.format("Error logging in user. Cannot find profile [%s]", parameters.getLogin()));
                throw e;
            }
        }
        catch (Throwable t) {
            parameters.getValidationContext().getLoginValidationMessages().add(AuthorizationValidationMessages.getInvalidLoginOrPassword());
            parameters.getValidationContext().getPasswordValidationMessages().add(AuthorizationValidationMessages.getInvalidLoginOrPassword());
            throw new ValidationException();
        }
    }

    protected boolean isAuthenticatedUser(Person person) {
        return AuthorizationHelper.isValidB2BPersonTypes(person);
    }
}

