/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.authorization.login;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.ibecorp.common.rest.authorization.AuthorizationHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.authorization.login.ExtApiV1AuthConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.rest.extApiV1.model.authorization.ExtApiV1LoginResult;
import com.gridnine.xtrip.server.ibecorp.externalApi.rest.extApiV1.model.authorization.ExtApiV1SelectablePreferences;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ExtApiV1LoginResultSelectablePreferencesConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Set personTypes;
        ExtApiV1LoginResult result = new ExtApiV1LoginResult();
        EntityReference userRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER);
        result.setSelectablePreferences(new ExtApiV1SelectablePreferences());
        Person user = (Person)EntityStorage.get().resolve(userRef).getEntity();
        if (user.getEmployments().size() > 1) {
            SearchQuery query = new SearchQuery();
            query.getPreferredProperties().add(OrganizationIndex.Property.shortName.name());
            query.getCriteria().getCriterions().add(SearchCriterion.in((String)"containerUid", (Object[])AuthorizationHelper.getValidEmployments(user).stream().map(empl -> empl.getOrganization().getUid()).toArray()));
            List data = EntityStorage.get().search(OrganizationIndex.class, query).getData();
            data.stream().map(ExtApiV1AuthConverterHelper::convertOrganizationIndex2RestEmployer).forEach(restEmpl -> result.getSelectablePreferences().getEmployers().add(restEmpl));
        }
        if ((personTypes = user.getTypes().stream().filter(AuthorizationHelper.VALID_B2B_TYPES_CRITERION).collect(Collectors.toSet())).size() > 1) {
            result.getSelectablePreferences().getPersonTypes().addAll(personTypes);
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

