/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.authorization.login;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.authorization.B2BLoginParametersValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.authorization.AuthorizationHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.cabinet.ExtApiV1CabinetConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.cabinet.ExtApiV1Employer;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.cabinet.ExtApiV1EmployerType;
import com.gridnine.xtrip.server.ibecorp.externalApi.rest.extApiV1.model.authorization.ExtApiV1LoginParameters;
import com.gridnine.xtrip.server.ibecorp.externalApi.rest.extApiV1.model.authorization.ExtApiV1SelectedPreferences;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Optional;

public class ExtApiV1SelectedPreferencesValidator
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ExtApiV1LoginParameters params = (ExtApiV1LoginParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        ExtApiV1SelectedPreferences selectedPreferences = params.getSelectedPreferences();
        EntityReference userRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER);
        PersonType personType = selectedPreferences.getPersonType();
        ExtApiV1EmployerType employerType = Optional.ofNullable(selectedPreferences.getEmployer()).map(ExtApiV1Employer::getType).orElse(null);
        if (personType == null || employerType == null) {
            Person user = (Person)EntityStorage.get().resolve(userRef).getEntity();
            if (personType == null) {
                user.getTypes().stream().filter(AuthorizationHelper.VALID_B2B_TYPES_CRITERION).findFirst().get();
            }
            if (employerType == null) {
                EntityReference orgRef = AuthorizationHelper.getValidEmployments(user).get(0).getOrganization();
                OrganizationType orgType = CabinetHelper.getOrganizationTypes((EntityReference<Organization>)orgRef).iterator().next();
                employerType = ExtApiV1CabinetConverterHelper.convertOrganizationType2EmployerType(orgType, (EntityReference<Organization>)orgRef);
            }
        }
        if (this.isUserRoleIncompatibleWithPlaceOfWork(personType, employerType)) {
            params.getValidationContext().getSelectedPreferencesValidationMessages().add(B2BLoginParametersValidationMessages.getUserRoleIncompatibleWithPlaceOfWork((String)personType.toString(), (String)employerType.toString()));
            throw new ValidationException();
        }
    }

    private boolean isUserRoleIncompatibleWithPlaceOfWork(PersonType personType, ExtApiV1EmployerType employerType) {
        return personType == PersonType.AGENT && employerType == ExtApiV1EmployerType.CORPORATE_CLIENT || personType == PersonType.PASSENGER && employerType != ExtApiV1EmployerType.CORPORATE_CLIENT;
    }
}

